/*
 * Decompiled with CFR 0.152.
 */
package ext.scf3.client;

import ext.base.core.BcConstants;
import ext.base.table.BcTableColumn;
import ext.base.table.BcTableContext;
import ext.lib.rmi.client.RmiLocalAgent;
import ext.lib.rmi.model.RmiRequest;
import ext.lib.rmi.model.RmiRespons;
import ext.lib.task.TskAbstractCallable;
import ext.scf.stub.ScfHandleStub;
import ext.scf3.client.ScfTableLoadEventHandler;
import ext.scf3.stub.ScfDatabaseStub;
import java.util.List;
import javax.swing.event.EventListenerList;

public class ScfTableLoadTask
extends TskAbstractCallable {
    public static final int STATUS_init = -1;
    public static final int STATUS_idling = 1;
    public static final int STATUS_running = 2;
    public static final int STATUS_cancelling = 3;
    public static final int STATUS_canceled = 4;
    protected String handleId;
    protected int status;
    protected boolean eod;
    protected int requireRowCount = 100;
    private Integer rowCount;
    protected int loadedRowSize;
    private int requestCount;
    protected RmiRequest rmiReq1;
    private RmiRequest rmiReq2;
    protected RmiRespons handleRes;
    private List<BcTableColumn> tableColumnList;
    private RmiLocalAgent localAgent;
    private EventListenerList eventListenerList = new EventListenerList();

    public String getHandleId() {
        return this.handleId;
    }

    public RmiLocalAgent getLocalAgent() {
        return this.localAgent;
    }

    public void setLocalAgent(RmiLocalAgent localAgent) {
        this.localAgent = localAgent;
    }

    public ScfTableLoadTask() throws Exception {
        this.init();
    }

    public void init() throws Exception {
        this.status = -1;
        this.handleId = null;
        this.handleRes = null;
        this.eod = false;
        this.rowCount = -1;
        this.loadedRowSize = 0;
        this.requestCount = 0;
        this.tableColumnList = null;
    }

    public Object taskProcess() throws Exception {
        this.status = 2;
        if (this.handleRes == null) {
            this.tableLoadStarted(this);
            RmiRespons rmiRes = this.getLocalAgent().invoke(this.rmiReq1);
            this.setHandleRespons(rmiRes);
        }
        try {
            this.rmiReq2 = ScfDatabaseStub.getInstance().getNextRecord(this.handleId, this.requireRowCount);
            while (!this.eod) {
                if (this.status != 2) {
                    break;
                }
                this.loadRows();
            }
        }
        finally {
            try {
                ScfHandleStub.getInstance().removeHandle(this.getLocalAgent(), this.handleId);
            }
            finally {
                this.status = 1;
            }
        }
        this.tableLoadFinished(this, this.eod);
        return this.loadedRowSize;
    }

    public void setHandleRespons(RmiRespons handleRes) throws Exception {
        this.handleRes = handleRes;
        if (handleRes.getStatusId() == -9) {
            throw handleRes.getException();
        }
        this.handleId = handleRes.getDataAsString("hId");
        Object tmpObject = handleRes.getObject("tableColumnList");
        if (tmpObject == null) {
            RmiRespons rmiRes = ScfDatabaseStub.getInstance().getTableHeader(this.getLocalAgent(), this.handleId);
            this.setHandleRespons2(rmiRes);
        } else {
            this.setHandleRespons2(handleRes);
        }
    }

    protected void setHandleRespons2(RmiRespons rmiRes2) throws Exception {
        boolean isOk = rmiRes2.getDataAsBoolean();
        if (isOk) {
            Object result = rmiRes2.getObject("tableColumnList");
            if (result instanceof List) {
                List tableColumnList = (List)rmiRes2.getObject("tableColumnList");
                this.rowCount = (Integer)rmiRes2.getObject("tb_rs");
                if (this.rowCount == null) {
                    this.rowCount = -1;
                }
                BcTableContext tableContext = (BcTableContext)rmiRes2.getObject("tb_ctx");
                this.tableColumnReceived(this, tableColumnList, this.rowCount, tableContext);
            } else {
                this.eod = true;
                this.generalResultReceived(this, result);
            }
        } else {
            this.canceled(this);
        }
    }

    protected void loadRows() throws Exception {
        List rowList;
        ++this.requestCount;
        RmiRespons rmiRes = this.getLocalAgent().invoke(this.rmiReq2);
        Integer eodNum = (Integer)rmiRes.getObject("eod");
        if (eodNum != null) {
            boolean bl = this.eod = eodNum == BcConstants.Existence.TRUE.value;
        }
        if ((rowList = (List)rmiRes.getObject("tb_rl")) != null) {
            this.rowListReceived(this, rowList);
        }
    }

    public RmiRequest getRequest() {
        return this.rmiReq1;
    }

    public void setRequest(RmiRequest rmiReq1) throws Exception {
        this.rmiReq1 = rmiReq1;
    }

    protected void tableLoadStarted(ScfTableLoadTask tableLoadTask) throws Exception {
        ScfTableLoadEventHandler[] scfTableLoadEventHandlerArray = (ScfTableLoadEventHandler[])this.eventListenerList.getListeners(ScfTableLoadEventHandler.class);
        int n = scfTableLoadEventHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScfTableLoadEventHandler tableLoadEvent = scfTableLoadEventHandlerArray[n2];
            tableLoadEvent.tableLoadStarted(this);
            ++n2;
        }
    }

    protected void tableColumnReceived(ScfTableLoadTask tableLoadTask, List<BcTableColumn> tableColumnList, int rowCount, BcTableContext tableContext) throws Exception {
        this.tableColumnList = tableColumnList;
        ScfTableLoadEventHandler[] scfTableLoadEventHandlerArray = (ScfTableLoadEventHandler[])this.eventListenerList.getListeners(ScfTableLoadEventHandler.class);
        int n = scfTableLoadEventHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScfTableLoadEventHandler tableLoadEvent = scfTableLoadEventHandlerArray[n2];
            tableLoadEvent.tableColumnReceived(tableLoadTask, tableColumnList, rowCount, tableContext);
            ++n2;
        }
    }

    protected void rowListReceived(ScfTableLoadTask tableLoadTask, List<List> rowList) throws Exception {
        this.loadedRowSize += rowList.size();
        ScfTableLoadEventHandler[] scfTableLoadEventHandlerArray = (ScfTableLoadEventHandler[])this.eventListenerList.getListeners(ScfTableLoadEventHandler.class);
        int n = scfTableLoadEventHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScfTableLoadEventHandler tableLoadEvent = scfTableLoadEventHandlerArray[n2];
            tableLoadEvent.rowListReceived(tableLoadTask, rowList);
            ++n2;
        }
        this.loadedRowSizeChanged(tableLoadTask, this.rowCount, this.loadedRowSize);
    }

    protected void tableLoadFinished(ScfTableLoadTask tableLoadTask, boolean eod) throws Exception {
        ScfTableLoadEventHandler[] scfTableLoadEventHandlerArray = (ScfTableLoadEventHandler[])this.eventListenerList.getListeners(ScfTableLoadEventHandler.class);
        int n = scfTableLoadEventHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScfTableLoadEventHandler tableLoadEvent = scfTableLoadEventHandlerArray[n2];
            tableLoadEvent.tableLoadFinished(tableLoadTask, eod);
            ++n2;
        }
    }

    protected void loadedRowSizeChanged(ScfTableLoadTask tableLoadTask, int rowCount, int loadedRowCount) throws Exception {
        ScfTableLoadEventHandler[] scfTableLoadEventHandlerArray = (ScfTableLoadEventHandler[])this.eventListenerList.getListeners(ScfTableLoadEventHandler.class);
        int n = scfTableLoadEventHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScfTableLoadEventHandler tableLoadEvent = scfTableLoadEventHandlerArray[n2];
            tableLoadEvent.loadedRowSizeChanged(tableLoadTask, rowCount, loadedRowCount);
            ++n2;
        }
    }

    protected void generalResultReceived(ScfTableLoadTask tableLoadTask, Object generalResult) throws Exception {
        ScfTableLoadEventHandler[] scfTableLoadEventHandlerArray = (ScfTableLoadEventHandler[])this.eventListenerList.getListeners(ScfTableLoadEventHandler.class);
        int n = scfTableLoadEventHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScfTableLoadEventHandler tableLoadEvent = scfTableLoadEventHandlerArray[n2];
            tableLoadEvent.generalResultReceived(tableLoadTask, generalResult);
            ++n2;
        }
    }

    protected void cancelStarted(ScfTableLoadTask tableLoadTask, Object source) throws Exception {
        ScfTableLoadEventHandler[] scfTableLoadEventHandlerArray = (ScfTableLoadEventHandler[])this.eventListenerList.getListeners(ScfTableLoadEventHandler.class);
        int n = scfTableLoadEventHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScfTableLoadEventHandler tableLoadEvent = scfTableLoadEventHandlerArray[n2];
            tableLoadEvent.cancelStarted(tableLoadTask, source);
            ++n2;
        }
    }

    protected void canceled(ScfTableLoadTask tableLoadTask) throws Exception {
        ScfTableLoadEventHandler[] scfTableLoadEventHandlerArray = (ScfTableLoadEventHandler[])this.eventListenerList.getListeners(ScfTableLoadEventHandler.class);
        int n = scfTableLoadEventHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScfTableLoadEventHandler tableLoadEvent = scfTableLoadEventHandlerArray[n2];
            tableLoadEvent.canceled(tableLoadTask);
            ++n2;
        }
    }

    protected void tableLoadError(ScfTableLoadTask tableLoadTask, Throwable throwable) {
        ScfTableLoadEventHandler[] scfTableLoadEventHandlerArray = (ScfTableLoadEventHandler[])this.eventListenerList.getListeners(ScfTableLoadEventHandler.class);
        int n = scfTableLoadEventHandlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScfTableLoadEventHandler tableLoadEvent = scfTableLoadEventHandlerArray[n2];
            tableLoadEvent.tableLoadError(tableLoadTask, throwable);
            ++n2;
        }
    }

    public void cancel(Object source) throws Exception {
        if (this.status != 2) {
            return;
        }
        this.cancelStarted(this, source);
        this.status = 3;
        RmiRespons rmiRes = ScfDatabaseStub.getInstance().stopQuery(this.getLocalAgent(), this.handleId);
        this.status = 4;
    }

    @Override
    protected void taskError(Throwable throwable) {
        this.tableLoadError(this, throwable);
    }

    public List<BcTableColumn> getTableColumnList() {
        return this.tableColumnList;
    }

    public EventListenerList getEventListenerList() {
        return this.eventListenerList;
    }
}

