/*
 * Decompiled with CFR 0.152.
 */
package ext.scf3.client;

import ext.appfw.common.AfbApplication;
import ext.base.core.BcNumberUtil;
import ext.base.core.BcTimeUtil;
import ext.base.event.BcEventHandler;
import ext.base.event.BcProgressEvent;
import ext.base.log.BcLoggableObject;
import ext.base.thread.BcMonitor;
import ext.base.util.BcConsoleHelper;
import ext.base.util.BcWords;
import ext.base.xml.BcXmlUtil;
import ext.lib.awt.AwtUtil;
import ext.lib.rmi.model.RmiRequest;
import ext.lib.rmi.model.RmiRespons;
import ext.libx.swg.SwgxDesktopBase;
import ext.scf.client.ScfClientContainer;
import ext.scf2.client.ScfFileDownloader;
import ext.scf3.rmo.ScfClientUpdatorRMO;
import ext.scf3.swg.ScfClientUpdateMonitorPanel;
import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ScfClientUpdator
extends BcLoggableObject
implements BcEventHandler<BcProgressEvent> {
    protected ScfFileDownloader fileDownloader;
    protected ScfClientUpdateMonitorPanel loadMonitorPanel;
    protected long fileLengthSum = 0L;
    protected long loadedSizeSum = 0L;
    protected long loadStartMillis;
    protected String moduleName;
    protected String moduleVersion;
    protected String destFile;
    protected BcConsoleHelper consoleHelper = new BcConsoleHelper();

    public void checkAppVersion() throws Exception {
        long fileLength;
        int fileCount;
        Document bootConfig = AfbApplication.getInstance().getBootConfig();
        Node node_moduleUpdator = BcXmlUtil.getNode(bootConfig, "moduleUpdator");
        this.moduleName = BcXmlUtil.getTextValue(node_moduleUpdator, "name");
        this.moduleVersion = BcXmlUtil.getTextValue(node_moduleUpdator, "version");
        this.destFile = BcXmlUtil.getTextValue(node_moduleUpdator, "destFile");
        this.getLogger().debug("moduleName=" + this.moduleName + " moduleVersion=" + this.moduleVersion + " destFile=" + this.destFile);
        this.getLogger().info("\u30d7\u30ed\u30b0\u30e9\u30e0\u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u78ba\u8a8d\u4e2d\u3067\u3059...");
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(ScfClientUpdatorRMO.class.getName());
        rmiReq.setMethodName("getNewClientJarFilePath");
        rmiReq.addData(this.moduleName);
        rmiReq.addData(this.moduleVersion);
        RmiRespons rmiRes = ScfClientContainer.getInstance().getAgent().invoke(rmiReq);
        int updateStatus = rmiRes.getDataAsInteger();
        if (updateStatus == 1) {
            return;
        }
        if (updateStatus == 9) {
            String msg = "\u3053\u306e\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u306f\u4e92\u63db\u6027\u304c\u7121\u3044\u304b\u3001\u30a2\u30c3\u30d7\u30c7\u30fc\u30c8\u304c\u4e0d\u53ef\u80fd\u3067\u3059\u3002";
            if (AwtUtil.isGuiEnabled()) {
                JOptionPane.showMessageDialog(SwgxDesktopBase.getInstance().getMainFrame(), msg, BcWords.getInstance().information, 1);
            } else {
                this.consoleHelper.pause(msg);
            }
            System.exit(0);
        }
        if ((fileCount = rmiRes.getDataAsInteger().intValue()) <= 0) {
            return;
        }
        boolean doUpdate = this.updateConfirm();
        if (!doUpdate) {
            System.exit(0);
        }
        this.fileDownloader = new ScfFileDownloader(ScfClientContainer.getInstance().getAgent());
        int chunkSize = 0x100000;
        this.fileDownloader.setChunkSize(chunkSize);
        this.fileDownloader.addProgressEventHandler(this);
        if (AwtUtil.isGuiEnabled()) {
            this.loadMonitorPanel = new ScfClientUpdateMonitorPanel();
            this.loadMonitorPanel.showAsFrame();
        } else {
            final DefaultBoundedRangeModel boundedRangeModel = new DefaultBoundedRangeModel();
            boundedRangeModel.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ev) {
                    ScfClientUpdator.this.getLogger().info(String.valueOf(boundedRangeModel.getValue()) + " %");
                }
            });
        }
        ArrayList<File> fileList = new ArrayList<File>();
        ArrayList<Long> fileLengthList = new ArrayList<Long>();
        int i = 0;
        while (i < fileCount) {
            File file = (File)rmiRes.getData();
            fileList.add(file);
            fileLength = rmiRes.getDataAsLong();
            fileLengthList.add(fileLength);
            this.fileLengthSum += fileLength;
            ++i;
        }
        this.loadStartMillis = System.currentTimeMillis();
        i = 0;
        while (i < fileList.size()) {
            File svFile = (File)fileList.get(i);
            fileLength = (Long)fileLengthList.get(i);
            if (AwtUtil.isGuiEnabled()) {
                this.loadMonitorPanel.fileNameLabel.setText(String.valueOf(svFile.getName()) + " (" + (i + 1) + "/" + fileList.size() + ")");
                long sizeKB = fileLength / 1024L;
                this.loadMonitorPanel.fileSizeLabel.setText(String.valueOf(BcNumberUtil.toString(sizeKB)) + "KB");
            }
            this.loadFile(svFile);
            this.loadedSizeSum += fileLength;
            ++i;
        }
        this.fileDownloader.removeProgressEventHandler(this);
        this.fileDownloader = null;
        if (AwtUtil.isGuiEnabled()) {
            this.loadMonitorPanel.close();
            String msg = "\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3092\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002";
            JOptionPane.showMessageDialog(SwgxDesktopBase.getInstance().getMainFrame(), msg, BcWords.getInstance().information, 1);
        } else {
            String msg = "\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3092\u5b8c\u4e86\u3057\u307e\u3057\u305f\u3002\u3044\u3065\u308c\u304b\u306e\u30ad\u30fc\u3092\u62bc\u3057\u3066\u304f\u3060\u3055\u3044\u3002";
            this.consoleHelper.pause(msg);
        }
        System.exit(0);
    }

    protected boolean updateConfirm() throws Exception {
        boolean res = false;
        String msg = "\u672c\u30af\u30e9\u30a4\u30a2\u30f3\u30c8\u306e\u66f4\u65b0\u304c\u5fc5\u8981\u3067\u3059\u3002\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u3092\u5b9f\u884c\u3057\u307e\u3059\u304b\uff1f";
        if (AwtUtil.isGuiEnabled()) {
            if (JOptionPane.showConfirmDialog(SwgxDesktopBase.getInstance().getMainFrame(), msg, BcWords.getInstance().confirm, 0) == 0) {
                res = true;
            }
        } else {
            res = this.consoleHelper.ask_yn(String.valueOf(msg) + " (Y/N)");
        }
        return res;
    }

    protected void loadFile(File svFile) throws Exception {
        String msg;
        File tmpFile;
        File toFile = new File(AfbApplication.getInstance().toReal(this.destFile));
        if (toFile.exists() && !toFile.delete()) {
            String msg2 = "\u30a2\u30c3\u30d7\u30c7\u30fc\u30c8\u30d5\u30a1\u30a4\u30eb\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            if (AwtUtil.isGuiEnabled()) {
                JOptionPane.showMessageDialog(SwgxDesktopBase.getInstance().getMainFrame(), msg2, BcWords.getInstance().warning, 1);
            } else {
                this.consoleHelper.pause(msg2);
            }
            System.exit(0);
        }
        if ((tmpFile = new File(String.valueOf(AfbApplication.getInstance().toReal("${ROOT}bin/")) + "temp")).exists() && !tmpFile.delete()) {
            String msg3 = "\u30c6\u30f3\u30dd\u30e9\u30ea\u30d5\u30a1\u30a4\u30eb\u306e\u4f5c\u6210\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            if (AwtUtil.isGuiEnabled()) {
                JOptionPane.showMessageDialog(SwgxDesktopBase.getInstance().getMainFrame(), msg3, BcWords.getInstance().warning, 1);
            } else {
                this.consoleHelper.pause(msg3);
            }
            System.exit(0);
        }
        BcMonitor monitor = new BcMonitor();
        this.fileDownloader.download(monitor, svFile, tmpFile, false);
        monitor.sync();
        if (!this.fileDownloader.isComplete()) {
            msg = "\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            if (AwtUtil.isGuiEnabled()) {
                JOptionPane.showMessageDialog(SwgxDesktopBase.getInstance().getMainFrame(), msg, BcWords.getInstance().warning, 1);
            } else {
                this.consoleHelper.pause(msg);
            }
            tmpFile.delete();
            System.exit(0);
        }
        if (!tmpFile.renameTo(toFile)) {
            msg = "\u30c6\u30f3\u30dd\u30e9\u30ea\u30d5\u30a1\u30a4\u30eb\u306e\u30ea\u30cd\u30fc\u30e0\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002";
            if (AwtUtil.isGuiEnabled()) {
                JOptionPane.showMessageDialog(SwgxDesktopBase.getInstance().getMainFrame(), msg, BcWords.getInstance().warning, 1);
            } else {
                this.consoleHelper.pause(msg);
            }
            System.exit(0);
        }
    }

    @Override
    public void handle(BcProgressEvent ev) throws Exception {
        double per = (double)(this.loadedSizeSum + ev.value) / (double)this.fileLengthSum * 100.0;
        long period = System.currentTimeMillis() - this.loadStartMillis;
        double restTime = (double)period / per * (100.0 - per);
        String restTimeStr = BcTimeUtil.getTermString((long)restTime);
        if (AwtUtil.isGuiEnabled()) {
            this.loadMonitorPanel.progressBar.setValue((int)per);
            this.loadMonitorPanel.restTimeLabel.setText(restTimeStr);
        } else {
            String msg = " \u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u4e2d... " + (int)per + "%  " + ev.value + "/" + ev.max;
            this.getLogger().info(msg);
        }
    }
}

