/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xsys.server;

import ext.appfw.common.AfbApplication;
import ext.base.core.BcTimeUtil;
import ext.base.log.BcLogUtil;
import ext.base.reflect.BcReflectUtil;
import ext.base.runtime.BcClassLoader;
import ext.lib.datasource.DtsConnectionManager;
import ext.lib.datasource.DtsConnectionManagerImpl;
import ext.lib.datasource.DtsSession;
import ext.lib.datasource.DtsSessionFactory;
import ext.lib.datasource.DtsSessionFactoryManegaer;
import ext.lib.rmi.agent.RmiAgent;
import ext.lib.rmi.model.RmiRmoArgument;
import ext.lib.rmi.server.RmiAgentEventHandler;
import ext.lib.rmi.server.RmiServer;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.context.SqlContext_H2;
import ext.module.xdts.server.XdtsServerModule;
import ext.module.xfil.server.XfilServerModule;
import ext.module.xmmd.server.XmmdServerModule;
import ext.module.xsys.server.XsysDatasourceUpdater;
import ext.scf.server.ScfAbstractServerModule;
import ext.scf.server.ScfServerContainer;
import ext.scf.server.ScfServerModule;
import ext.scf5.dao.ScfSchemaVersionDAO;
import ext.scf5.model.ScfSchemaVersion;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class XsysServerModule
extends ScfAbstractServerModule
implements RmiAgentEventHandler {
    String[] classNames = new String[]{XfilServerModule.class.getName(), XdtsServerModule.class.getName(), XmmdServerModule.class.getName()};
    List<ScfServerModule> serverModuleList = new ArrayList<ScfServerModule>();

    @Override
    public void init() throws Exception {
        int i = 0;
        while (i < this.classNames.length) {
            String className = this.classNames[i];
            Class<?> clazz = Class.forName(className);
            ScfServerModule serverModule = (ScfServerModule)BcReflectUtil.getInstance(clazz);
            this.serverModuleList.add(serverModule);
            serverModule.init();
            ++i;
        }
        this.setupDatasource();
        this.updateSchema();
        if (ScfServerContainer.getInstance().rmiServerModule != null) {
            RmiServer rmixServer = ScfServerContainer.getInstance().rmiServerModule.getServer();
            rmixServer.addAgentEventHandler(this);
        }
    }

    @Override
    public void start() throws Exception {
        int i = 0;
        while (i < this.serverModuleList.size()) {
            ScfServerModule serverModule = this.serverModuleList.get(i);
            serverModule.start();
            ++i;
        }
    }

    @Override
    public void end() throws Exception {
        int i = 0;
        while (i < this.serverModuleList.size()) {
            ScfServerModule serverModule = this.serverModuleList.get(i);
            serverModule.end();
            ++i;
        }
    }

    protected void setupDatasource() throws Exception {
        String dbPath = AfbApplication.getInstance().toReal("${ROOT}data/main");
        String driverClassName = "org.h2.Driver";
        String dbUrl = SqlContext_H2.cretaeUrlFile(dbPath);
        BcLogUtil.debug("dbUrl=" + dbUrl);
        Properties dbConProps = new Properties();
        dbConProps.setProperty(SqlConstants.DatasourceProperty.user.name(), "xsys_admin");
        dbConProps.setProperty(SqlConstants.DatasourceProperty.password.name(), "ex4rhk8x");
        URL url = this.getClass().getResource("lib/h2-2.2.224.jar");
        URL[] urls = new URL[]{url};
        URLClassLoader classLoader = new URLClassLoader(urls, (ClassLoader)new BcClassLoader());
        Driver driver = SqlUtil.createDriver(driverClassName, classLoader);
        DtsConnectionManagerImpl connectionManager = new DtsConnectionManagerImpl();
        ((DtsConnectionManager)connectionManager).setup(SqlUtil.createDriver(driverClassName), dbUrl, dbConProps);
        DtsSessionFactory dtsSessionFactory = new DtsSessionFactory("main", connectionManager);
        DtsSessionFactoryManegaer.getInstance().addSessionFactory(dtsSessionFactory);
    }

    protected void updateSchema() throws Exception {
        DtsSessionFactory dtsSessionFactory = DtsSessionFactoryManegaer.getInstance().getSessionFactory("main");
        DtsSession dtsSession = dtsSessionFactory.createSession(this);
        try {
            try {
                SqlContext sqlContext = dtsSession.getSqlContext();
                ScfSchemaVersion schemaVersion = null;
                if (sqlContext.existTable(dtsSession.getConnection(), ScfSchemaVersionDAO.getInstance().getTableName())) {
                    schemaVersion = ScfSchemaVersionDAO.getInstance().getLatest(dtsSession);
                }
                if (schemaVersion == null) {
                    schemaVersion = new ScfSchemaVersion();
                    schemaVersion.versionId = 0;
                }
                if (schemaVersion.versionId > 3) {
                    String msg = "Not suport. schemaVersion=" + schemaVersion.versionId;
                    throw new Exception(msg);
                }
                XsysDatasourceUpdater datasourceUpdater = new XsysDatasourceUpdater();
                while (schemaVersion.versionId < 3) {
                    ++schemaVersion.versionId;
                    schemaVersion.updateStartTimestamp = BcTimeUtil.createCalendar();
                    datasourceUpdater.update(dtsSession, schemaVersion.versionId);
                    schemaVersion.updateEndTimestamp = BcTimeUtil.createCalendar();
                    ScfSchemaVersionDAO.getInstance().putEntity(dtsSession, schemaVersion);
                    dtsSession.commit();
                }
            }
            catch (Exception ex) {
                dtsSession.rollback();
                throw ex;
            }
        }
        finally {
            dtsSession.desturuct();
        }
    }

    @Override
    public void agentAdded(RmiAgent rmixAgent) throws Exception {
    }

    @Override
    public void agentRemoved(RmiAgent rmixAgent) throws Exception {
    }

    @Override
    public void firstStatusChecked(RmiAgent rmixAgent) throws Exception {
    }

    @Override
    public void invokeException(RmiRmoArgument rmixArg, Throwable throwable) throws Exception {
        BcLogUtil.error(throwable);
    }
}

