/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xsys.fx;

import ext.base.event.BcEventHandler;
import ext.base.event.BcEventHandlerList;
import ext.base.event.BcProgressEvent;
import ext.base.util.BcInputValidator;
import ext.base.util.BcInstanceManager;
import ext.base.util.BcMessageCreator;
import ext.base.util.BcObjectNotFoundException;
import ext.base.util.BcResult;
import ext.base.util.BcWords;
import ext.lib.fx.control.FxDateField;
import ext.lib.fx.control.FxLabel;
import ext.lib.fx.control.FxPasswordField;
import ext.lib.fx.control.FxTextArea;
import ext.lib.fx.control.FxTextField;
import ext.lib.fx.layout.FxDecoratePane;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.scene.FxScene;
import ext.lib.fx.stage.FxStage;
import ext.lib.fx.util.FxOptionPane;
import ext.lib.fx.util.FxUtil;
import ext.module.xsys.model.XsysUser;
import ext.module.xsys.stub.XsysUserStub;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class XsysUserPane
extends FxDecoratePane {
    FxFlowPane centerPane = new FxFlowPane(11);
    FxTextField userNameField = new FxTextField();
    FxPasswordField passwordField = new FxPasswordField();
    FxDateField expirationDateField = new FxDateField();
    FxTextArea permissionIdsTextArea = new FxTextArea();
    XsysUser user;
    Button completionButton;
    Button cancelButton;
    Stage stage;
    BcEventHandlerList eventHandlerList = new BcEventHandlerList();

    public XsysUserPane() throws Exception {
        this.setComponent();
    }

    protected void setComponent() throws Exception {
        this.completionButton = this.createButton(BcWords.getInstance().completion);
        this.cancelButton = this.createButton(BcWords.getInstance().close);
        this.userNameField.setPrefColumnCount(40);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().userName), new Node[]{this.userNameField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.passwordField.setPrefColumnCount(40);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().password), new Node[]{this.passwordField});
        this.centerPane.addNodeUnit(nodeUnit);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().passwordExpirationDate), new Node[]{this.expirationDateField});
        this.centerPane.addNodeUnit(nodeUnit);
        this.permissionIdsTextArea.setPrefColumnCount(80);
        this.permissionIdsTextArea.setPrefRowCount(2);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().permission), new Node[]{this.permissionIdsTextArea});
        this.centerPane.addNodeUnit(nodeUnit);
        this.setCenter((Node)this.centerPane);
        FxUtil.defaultInitialize((Node)this);
    }

    public void setUser(XsysUser user) throws Exception {
        this.user = user;
        this.userNameField.setText(user.userName);
        this.passwordField.setText(user.password);
        this.expirationDateField.setYyyyMMdd(user.passwordExpirationDate);
        this.permissionIdsTextArea.setText(user.permissionIds);
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.completionButton) {
            if (this.user == null) {
                this.user = new XsysUser();
            }
            this.user.userName = this.userNameField.getText();
            this.user.password = this.passwordField.getText();
            this.user.passwordExpirationDate = this.expirationDateField.getYyyyMMdd();
            this.user.permissionIds = this.permissionIdsTextArea.getText();
            BcResult result = new BcResult();
            BcInputValidator.getInstance().notNullable(this.user.userName, BcWords.getInstance().userName, result.getErrorList());
            if (result.hasError()) {
                String message = BcMessageCreator.getInstance().createMessage(result.getErrorList()).toString();
                FxOptionPane.showMessageDialog((Window)this.stage, (Object)message, BcWords.getInstance().warning, 2);
                return;
            }
            this.user = XsysUserStub.getInstance().putUser(this.user);
            this.eventHandlerList.fireEvent(new BcProgressEvent(this.user));
            this.close();
        } else if (ev.getSource() == this.cancelButton) {
            this.close();
        }
    }

    public void close() throws Exception {
        this.stage.close();
        BcInstanceManager.getInstance().remove(((Object)((Object)this)).getClass(), this.user.getDataId());
    }

    public void show(Window ownerWindow) throws Exception {
        this.stage = new FxStage();
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                try {
                    XsysUserPane.this.userNameField.requestFocus();
                }
                catch (Exception ex) {
                    XsysUserPane.this.handleException(ex);
                }
            }
        });
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                ev.consume();
                try {
                    XsysUserPane.this.close();
                }
                catch (Exception ex) {
                    XsysUserPane.this.handleException(ex);
                }
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(920.0);
        this.stage.setHeight(640.0);
        this.stage.setResizable(true);
        this.stage.setTitle(BcWords.getInstance().user);
        this.stage.showAndWait();
    }

    public static void show2(int profileId, int userId, BcEventHandler eventHandler) throws Exception {
        XsysUserPane userPane = (XsysUserPane)((Object)BcInstanceManager.getInstance().get(XsysUserPane.class, userId));
        if (userPane != null) {
            userPane.stage.toFront();
            return;
        }
        userPane = new XsysUserPane();
        userPane.eventHandlerList.addEventHandler(eventHandler);
        XsysUser user = null;
        if (userId <= 0) {
            user = new XsysUser();
        } else {
            if (user == null) {
                throw new BcObjectNotFoundException();
            }
            BcInstanceManager.getInstance().put(user.getDataId(), (Object)userPane);
        }
        userPane.setUser(user);
        userPane.show(null);
    }
}

