/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xsys.client;

import ext.appfw.common.AfbApplication;
import ext.appfw.common.AfbConstants;
import ext.appfw.common.AfbLogUtil;
import ext.base.core.BcTimeUtil;
import ext.base.io.BcFileUtil;
import ext.base.log.BcLogUtil;
import ext.base.reflect.BcReflectUtil;
import ext.base.runtime.BcRuntimeUtil;
import ext.base.thread.BcMonitor;
import ext.base.util.BcEncoder;
import ext.base.util.BcWords;
import ext.lib.awt.AwtImageHelper;
import ext.lib.fx.FxPlatform;
import ext.lib.fx.util.FxOptionPane;
import ext.lib.swg.SwgUtil;
import ext.module.advm.client.AdvmAdvertisementManager;
import ext.module.advm.client.AdvmAdvertisementTask;
import ext.module.xdts.common.XdtsConstants;
import ext.module.xsys.common.XsysConstants;
import ext.module.xsys.fx.XdtsLicensePane;
import ext.module.xsys.fx.XsysDesktop;
import ext.module.xupd.client.XupdChacker;
import ext.scf.client.ScfAbstractClientModule;
import ext.scf5.swg.IswgTablePanel;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Properties;
import javafx.application.Platform;
import javax.imageio.ImageIO;

public class XsysClientModule
extends ScfAbstractClientModule {
    public BcMonitor monitor = new BcMonitor();
    boolean licenseAgreement;
    public static Properties properties;

    @Override
    public void init() throws Exception {
        String javaVersion = System.getProperties().getProperty("java.version");
        if (!BcRuntimeUtil.isJava_1_8()) {
            String msg = "\u672c\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u306f Java 8 \u4ee5\u5916\u3067\u306f\u7a3c\u52d5\u3057\u307e\u305b\u3093\u3002\u63a1\u7528\u3055\u308c\u305f\u74b0\u5883\u306f " + javaVersion + " \u3067\u3059\u3002";
            FxOptionPane.showMessageDialog(msg, BcWords.getInstance().error, 0);
            System.exit(AfbConstants.ExitCode.NG.code);
        }
        properties = this.getProperties();
    }

    @Override
    public void start() throws Exception {
        BufferedImage iconImage = ImageIO.read(XsysConstants.class.getResourceAsStream("resource/rydeen_32x32.png"));
        AwtImageHelper.setWindowIconImage(iconImage);
        boolean isAgreement = this.licenseAgreement();
        if (!isAgreement) {
            AfbApplication.getInstance().exit(AfbConstants.ExitCode.OK.code);
            return;
        }
        int exitCode = this.chackUpdate();
        if (exitCode == 21) {
            AfbApplication.getInstance().exit(exitCode);
            return;
        }
        this.advertisement();
        IswgTablePanel.printButtonEnabled = false;
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    BcReflectUtil.invokeMethod(XsysDesktop.class.getName(), "show2");
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
    }

    protected boolean licenseAgreement() throws Exception {
        String vPath = "${ROOT}data/license_agreement.log";
        String rPath = AfbApplication.getInstance().toReal(vPath);
        File agreementLogFile = new File(rPath);
        BcLogUtil.debug("agreementLogFile=" + agreementLogFile.getPath());
        if (agreementLogFile.exists()) {
            return true;
        }
        this.monitor.lock();
        vPath = "${ROOT}\u30bd\u30d5\u30c8\u30a6\u30a7\u30a2\u4f7f\u7528\u8a31\u8afe\u5951\u7d04\u66f8.txt";
        rPath = AfbApplication.getInstance().toReal(vPath);
        File licenseFile = new File(rPath);
        String charsetName = BcEncoder.detectEncoding(licenseFile);
        Charset charset = Charset.forName(charsetName);
        final StringBuilder licenseStrBuf = BcFileUtil.readAsStringBuilder(new File(rPath), charset);
        Platform.setImplicitExit((boolean)false);
        Platform.runLater(() -> System.out.println("Inside Platform.runLater()"));
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    XdtsLicensePane licensePane = new XdtsLicensePane();
                    licensePane.textArea.setText(licenseStrBuf.toString());
                    XsysClientModule.this.licenseAgreement = licensePane.show(null);
                    XsysClientModule.this.monitor.unLock();
                }
                catch (Exception ex) {
                    XsysClientModule.this.handleException(ex);
                }
            }
        });
        this.monitor.sync();
        if (this.licenseAgreement) {
            StringBuilder agreementLog = new StringBuilder();
            agreementLog.append(BcTimeUtil.toString(BcTimeUtil.createCalendar(), "yyyy/MM/dd HH:mm:ss.SSS"));
            agreementLog.append(AfbLogUtil.lineSeparator);
            agreementLog.append((CharSequence)AfbLogUtil.jvmInfoLog());
            BcFileUtil.makeParent(agreementLogFile);
            BcFileUtil.save(agreementLogFile, agreementLog.toString(), charset);
            return true;
        }
        return false;
    }

    protected int chackUpdate() throws Exception {
        XupdChacker xupdChacker = new XupdChacker();
        int exitCode = xupdChacker.check(this.monitor);
        this.monitor.sync();
        return exitCode;
    }

    protected void advertisement() throws Exception {
        AdvmAdvertisementManager advertisementManager = new AdvmAdvertisementManager();
        advertisementManager.setAdvertisementTask(new AdvmAdvertisementTask());
        try {
            advertisementManager.checkBootConfig(this.monitor);
            this.monitor.sync();
            XdtsConstants.LIMIT_tableCount = -1;
            XdtsConstants.LIMIT_recordCount = -1;
        }
        catch (Exception ex) {
            this.monitor.unLock();
            BcLogUtil.error(ex);
        }
    }

    protected void handleException(Throwable throwable) {
        SwgUtil.getExceptionHandler().handleException(throwable, this);
    }
}

