/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.fx;

import ext.base.util.BcWords;
import ext.lib.fx.control.FxButton;
import ext.lib.fx.control.FxLabel;
import ext.lib.fx.control.FxTextField;
import ext.lib.fx.layout.FxDecoratePane;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.scene.FxScene;
import ext.lib.fx.stage.FxStage;
import ext.lib.fx.util.FxUtil;
import ext.lib.html.common.HtmlBuilder;
import ext.module.xdts.model.XdtsProfile;
import ext.module.xfil.fx.XfilFileAnalyzeTask;
import ext.module.xfil.model.XfilAnalysisCondition;
import ext.module.xfil.model.XfilAnalysisResult;
import ext.module.xfil.model.XfilUriEntity;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.stage.DirectoryChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class XfilFileSettingPane
extends FxDecoratePane {
    FxFlowPane centerPane = new FxFlowPane(11);
    protected FxTextField filePathField = new FxTextField();
    protected FxButton fileChooseButton;
    protected DirectoryChooser directoryChooser;
    protected Button button1;
    protected Button button2;
    File targetDir;
    List<XfilUriEntity> uriEntityList;
    XfilAnalysisResult analysisResult;
    Stage stage;

    public XfilFileSettingPane() throws Exception {
        this.fileChooseButton = new FxButton(BcWords.getInstance().browse);
        this.directoryChooser = new DirectoryChooser();
        this.button1 = this.createButton(BcWords.getInstance().connection);
        this.button2 = this.createButton(BcWords.getInstance().cancel);
        this.setComponent();
    }

    protected void setComponent() throws Exception {
        HtmlBuilder htmlBuilder = new HtmlBuilder();
        String explanation = String.valueOf(htmlBuilder.html_start(true).toString()) + htmlBuilder.font_start(2) + "\u6761\u4ef6\u3092\u8a2d\u5b9a\u3057\u3066\u4e0b\u3055\u3044\u3002\u300c\u5b9f\u884c\u300d\u30dc\u30bf\u30f3\u62bc\u4e0b\u306b\u3088\u308a\u53d6\u308a\u8fbc\u307f\u3092\u958b\u59cb\u3057\u307e\u3059\u3002" + htmlBuilder.html_end();
        this.setDescription(explanation);
        this.setCenter((Node)this.centerPane);
        this.filePathField.setPrefColumnCount(80);
        this.fileChooseButton.setOnAction(this.actionEventHandler);
        FxNodeUnit controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().folder), new Node[]{this.filePathField, this.fileChooseButton});
        this.centerPane.addNodeUnit(controlUnit);
        FxUtil.defaultInitialize((Node)this);
    }

    public void setDatasourceProfile(XdtsProfile datasourceProfile) throws Exception {
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.button1) {
            Path path = Paths.get(this.filePathField.getText(), new String[0]);
            this.doAnalyze(path);
        } else if (ev.getSource() == this.fileChooseButton) {
            FxUtil.initDirectoryChooser(this.directoryChooser, this.filePathField.getText());
            File dir = this.directoryChooser.showDialog((Window)this.stage);
            if (dir != null) {
                this.filePathField.setText(dir.getPath());
            }
        } else if (ev.getSource() == this.button2) {
            this.close();
        }
    }

    public void close() {
        this.stage.close();
    }

    public XfilAnalysisResult show(Window ownerWindow) throws Exception {
        this.analysisResult = null;
        this.stage = new FxStage();
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(920.0);
        this.stage.setHeight(340.0);
        this.stage.setResizable(false);
        this.stage.showAndWait();
        return this.analysisResult;
    }

    public void doAnalyze(Path path) throws Exception {
        XfilAnalysisCondition analysisCondition = new XfilAnalysisCondition();
        analysisCondition.targerPath = path;
        analysisCondition.emptyDirdel = true;
        analysisCondition.minLenfth = 20480L;
        XfilFileAnalyzeTask fileAnalyzeTask = new XfilFileAnalyzeTask();
        fileAnalyzeTask.analysisCondition = analysisCondition;
        ExecutorService executorService = Executors.newCachedThreadPool();
        fileAnalyzeTask.taskProcess();
        this.analysisResult = fileAnalyzeTask.analysisResult;
        this.close();
    }
}

