/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.server;

import ext.base.core.BcStringUtil;
import ext.base.mmd.MmdModel;
import ext.base.util.BcThrowableUtil;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.context.SqlContext;
import ext.module.xdts.model.XdtsProcessCondition;
import ext.module.xdts.server.XsysTableRowTask;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;

public class XsysCreateInsertSqlTask
extends XsysTableRowTask {
    SqlContext sqlContext2;
    MmdModel mmdModel1;
    MmdModel mmdModel2;
    XdtsProcessCondition processCondition;
    String tableName1;
    String tableName2;
    String baseSql;
    Writer writer;

    public void setCondition(SqlContext sqlContext2, XdtsProcessCondition processCondition, String tableName1, String tableName2, Writer writer) {
        this.sqlContext2 = sqlContext2;
        this.processCondition = processCondition;
        this.tableName1 = tableName1;
        this.tableName2 = tableName2;
        this.writer = writer;
    }

    @Override
    protected void started() throws Exception {
        super.started();
        this.mmdModel1 = this.sqlContext.createModelMetaData(this.dtsSession.getConnection(), this.tableName1);
    }

    @Override
    protected String createSql() throws Exception {
        StringBuilder query = new StringBuilder();
        query.append(this.sqlContext.createSelectSql(this.mmdModel1));
        if (!BcStringUtil.isEmpty(this.processCondition.sql)) {
            query.append(" WHERE ");
            query.append(this.processCondition.sql);
        }
        return query.toString();
    }

    @Override
    protected void resultSetCreated(ResultSet rs) throws Exception {
        super.resultSetCreated(rs);
        this.baseSql = this.sqlContext2.createInsertSqlForPrepareStatement(this.mmdModel1, BcStringUtil.lineSeparator, true);
        this.getLogger().info("baseSql=" + this.baseSql);
    }

    @Override
    protected void selected(ResultSet rs, int rowNumber) throws Exception {
        block2: {
            try {
                super.selected(rs, rowNumber);
                this.createInsertSql(rs);
            }
            catch (Exception ex) {
                String stackTrace = BcThrowableUtil.getStackTrace(ex);
                this.getLogger().error(stackTrace);
                if (this.processCondition.iqnoreException) break block2;
                throw ex;
            }
        }
    }

    @Override
    protected void finied(int rowNumber) throws Exception {
        super.finied(rowNumber);
        this.writer.write(59);
        this.writer.write(BcStringUtil.lineSeparator);
        this.writer.close();
    }

    public void createInsertSql(ResultSet rs) throws Exception {
        ResultSetMetaData rsmd1 = rs.getMetaData();
        StringBuilder insertQuery = new StringBuilder(this.baseSql);
        int i = 0;
        while (i < rsmd1.getColumnCount()) {
            int colmunIndex = i + 1;
            insertQuery = this.createInsertSql_L2(rs, colmunIndex, insertQuery);
            ++i;
        }
        this.getLogger().debug("insertQuery=" + insertQuery);
        this.writer.write(insertQuery.toString());
        this.writer.write(59);
        this.writer.write(BcStringUtil.lineSeparator);
    }

    protected StringBuilder createInsertSql_L2(ResultSet rs, int colmunIndex, StringBuilder insertQuery) throws Exception {
        ResultSetMetaData rsmd = rs.getMetaData();
        int sqlType = rsmd.getColumnType(colmunIndex);
        String target = "?" + colmunIndex;
        switch (sqlType) {
            case -4: 
            case -1: 
            case 2004: {
                String columnName = rsmd.getColumnName(colmunIndex);
                String msg = String.format("Not supported SQL type '%s'. columnName='%s'", new Object[]{SqlConstants.SqlType.getById(sqlType), columnName});
                throw new Exception(msg);
            }
        }
        Object value = rs.getObject(colmunIndex);
        insertQuery = value == null ? BcStringUtil.replace((CharSequence)insertQuery, target, "null") : BcStringUtil.replace((CharSequence)insertQuery, target, this.sqlContext2.toSet(value));
        return insertQuery;
    }
}

