/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.base.core.BcTimeUtil;
import ext.base.event.BcEventHandler;
import ext.base.event.BcEventHandlerList;
import ext.base.event.BcProgressEvent;
import ext.base.util.BcInputValidator;
import ext.base.util.BcInstanceManager;
import ext.base.util.BcMessageCreator;
import ext.base.util.BcObjectNotFoundException;
import ext.base.util.BcResult;
import ext.base.util.BcWords;
import ext.lib.fx.layout.FxDecoratePane;
import ext.lib.fx.scene.FxScene;
import ext.lib.fx.stage.FxStage;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxOptionPane;
import ext.lib.fx.util.FxUtil;
import ext.module.xdts.common.XdtsWords;
import ext.module.xdts.fx.XdtsTaskPane;
import ext.module.xdts.fx.XdtsTimerPane;
import ext.module.xdts.model.XdtsTask;
import ext.module.xdts.model.XdtsTimer;
import ext.module.xdts.stub.XdtsTaskStub;
import ext.module.xdts.stub.XdtsTimerStub;
import java.util.ArrayList;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class XdtsTimerTaskPane
extends FxDecoratePane {
    XdtsTimerPane timerPane = new XdtsTimerPane();
    Pane taskBasePane = new Pane();
    ScrollPane taskScrollPane = new ScrollPane();
    XdtsTimer timer;
    List<XdtsTask> taskList;
    List<XdtsTaskPane> taskPaneList;
    Button completionButton;
    Button cancelButton;
    Stage stage;
    BcEventHandlerList eventHandlerList = new BcEventHandlerList();

    public XdtsTimerTaskPane() throws Exception {
        this.setComponent();
    }

    protected void setComponent() throws Exception {
        this.completionButton = this.createButton(BcWords.getInstance().completion);
        this.cancelButton = this.createButton(BcWords.getInstance().close);
        this.setTop((Node)this.timerPane);
        this.taskScrollPane.setContent((Node)this.taskBasePane);
        this.setCenter((Node)this.taskScrollPane);
        FxUtil.defaultInitialize((Node)this);
    }

    public void setData(XdtsTimer timer, List<XdtsTask> taskList) throws Exception {
        this.timer = timer;
        this.taskList = taskList;
        this.timerPane.setData(timer);
        double x = 4.0;
        double y = 4.0;
        double rowSpace = 6.0;
        this.taskPaneList = new ArrayList<XdtsTaskPane>();
        int i = 0;
        while (i < taskList.size()) {
            XdtsTask task = taskList.get(i);
            XdtsTaskPane taskPane = new XdtsTaskPane();
            taskPane.setData(taskList.get(0));
            FxUtil.setLocation(this.taskBasePane, (Region)taskPane, x, y, 860.0, 400.0);
            this.taskPaneList.add(taskPane);
            ++i;
        }
        this.taskBasePane.setPrefSize(860.0, 1600.0);
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.completionButton) {
            BcResult result = new BcResult();
            BcInputValidator.getInstance().notNullable(this.timer.name, BcWords.getInstance().name, result.getErrorList());
            result.addResult(this.timerPane.validation());
            if (result.hasError()) {
                String message = BcMessageCreator.getInstance().createMessage(result.getErrorList()).toString();
                FxOptionPane.showMessageDialog((Window)this.stage, (Object)message, BcWords.getInstance().warning, 2);
                return;
            }
            this.timerPane.storeData(this.timer);
            this.taskList = new ArrayList<XdtsTask>();
            int i = 0;
            while (i < this.taskPaneList.size()) {
                XdtsTaskPane taskPane = this.taskPaneList.get(i);
                taskPane.storeData(taskPane.task);
                this.taskList.add(taskPane.task);
                ++i;
            }
            this.timer = XdtsTimerStub.getInstance().putTimer(this.timer, this.taskList);
            this.eventHandlerList.fireEvent(new BcProgressEvent(this.timer));
            this.close();
        } else if (ev.getSource() == this.cancelButton) {
            this.close();
        }
    }

    public void close() throws Exception {
        this.stage.close();
        BcInstanceManager.getInstance().remove(((Object)((Object)this)).getClass(), this.timer.getDataId());
    }

    public void show(Window ownerWindow) throws Exception {
        this.stage = new FxStage();
        if (ownerWindow != null) {
            this.stage.initModality(Modality.WINDOW_MODAL);
            this.stage.initOwner(ownerWindow);
        }
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                try {
                    XdtsTimerTaskPane.this.timerPane.nameTextField.requestFocus();
                }
                catch (Exception ex) {
                    XdtsTimerTaskPane.this.handleException(ex);
                }
            }
        });
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                ev.consume();
                try {
                    XdtsTimerTaskPane.this.close();
                }
                catch (Exception ex) {
                    XdtsTimerTaskPane.this.handleException(ex);
                }
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(920.0);
        this.stage.setHeight(640.0);
        this.stage.setResizable(true);
        this.stage.setTitle(XdtsWords.getInstance().task);
        FxImageHelper.setStageIcon(this.stage);
        this.stage.showAndWait();
    }

    public static void show2(int timerId, BcEventHandler eventHandler) throws Exception {
        XdtsTimerTaskPane timerTaskPane = (XdtsTimerTaskPane)((Object)BcInstanceManager.getInstance().get(XdtsTimerTaskPane.class, timerId));
        if (timerTaskPane != null) {
            timerTaskPane.stage.toFront();
            return;
        }
        timerTaskPane = new XdtsTimerTaskPane();
        timerTaskPane.eventHandlerList.addEventHandler(eventHandler);
        XdtsTimer timer = null;
        List<XdtsTask> taskList = null;
        if (timerId <= 0) {
            timer = new XdtsTimer();
            timer.startTime = BcTimeUtil.createCalendar();
            timer.triggerId = 12;
            timer.value1 = "60";
            timer.value2 = "-1";
            taskList = new ArrayList<XdtsTask>();
            taskList.add(new XdtsTask());
        } else {
            timer = XdtsTimerStub.getInstance().getTimer(timerId);
            if (timer == null) {
                throw new BcObjectNotFoundException();
            }
            BcInstanceManager.getInstance().put(timer.getDataId(), (Object)timerTaskPane);
            taskList = XdtsTaskStub.getInstance().getTaskListByTimerId(timerId);
        }
        timerTaskPane.setData(timer, taskList);
        timerTaskPane.show(null);
    }

    public static void delete(Window ownerWindow, XdtsTimer timer) throws Exception {
        XdtsTimerTaskPane timerTaskPane = (XdtsTimerTaskPane)((Object)BcInstanceManager.getInstance().get(XdtsTimerTaskPane.class, timer.getDataId()));
        if (timerTaskPane != null) {
            timerTaskPane.stage.toFront();
            return;
        }
        String msg = "'" + timer.name + "' \u3092\u524a\u9664\u3057\u307e\u3059\u304b\uff1f";
        if (FxOptionPane.showConfirmDialog(ownerWindow, (Object)msg, BcWords.getInstance().confirm, 3) == 0) {
            XdtsTimerStub.getInstance().deleteTimer(timer.getDataId());
        }
    }
}

