/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.base.mmd.MmdModel;
import ext.base.mmd.MmdUtil;
import ext.base.table.BcTableColumnModel;
import ext.lib.datasource.util.DtsWordManager;
import ext.lib.fx.control.FxTabPane;
import ext.lib.fx.layout.FxBorderPane;
import ext.lib.fx.table.FxTableRowList;
import ext.lib.fx.table.FxTableUtil;
import ext.lib.fx.table.FxTableView;
import ext.lib.fx.util.FxUtil;
import ext.lib.sql.SqlWords;
import ext.module.xdts.common.XdtsUtil;
import ext.module.xdts.model.XdtsProfile;
import ext.module.xdts.stub.XdtsSchemaStub;
import ext.module.xmmd.common.XmmdUtil;
import ext.module.xmmd.fx.XmmdFieldListPane;
import ext.module.xmmd.fx.XmmdFieldTableModel;
import ext.module.xmmd.model.XmmdIndex;
import ext.module.xmmd.model.XmmdModel;
import ext.scf4.fx.HfxLoadableTablePane;
import java.util.List;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Tab;

public class XdtsTableInfoPane
extends FxBorderPane {
    XdtsProfile profile;
    String tableName;
    FxTabPane tabPane1 = new FxTabPane();
    FxTabPane tabPane2 = new FxTabPane();
    DtsWordManager wordManager;

    public XdtsTableInfoPane(XdtsProfile profile, String tableName, DtsWordManager wordManager) throws Exception {
        this.profile = profile;
        this.tableName = tableName;
        this.wordManager = wordManager;
        MmdModel mmdModel = XdtsSchemaStub.getInstance().getModelMetaData(profile.getDataId(), tableName);
        XmmdModel xmmdModel = XmmdUtil.toXmmdModel(mmdModel);
        XmmdFieldListPane columnDefinePane = new XmmdFieldListPane();
        columnDefinePane.setData(xmmdModel, wordManager);
        this.setCenter((Node)columnDefinePane);
        this.tabPane1.setSide(Side.LEFT);
        this.setCenter((Node)this.tabPane1);
        Tab columnTab = new Tab();
        columnTab.setText(SqlWords.getInstance().columnDefine);
        columnTab.setContent((Node)columnDefinePane);
        columnTab.closableProperty().set(false);
        this.tabPane1.getTabs().add((Object)columnTab);
        this.tabPane2.setSide(Side.TOP);
        Tab indexTab = new Tab();
        indexTab.setText(SqlWords.getInstance().index);
        indexTab.setContent((Node)this.tabPane2);
        indexTab.closableProperty().set(false);
        this.tabPane1.getTabs().add((Object)indexTab);
        for (XmmdIndex xmmdIndex : xmmdModel.indexNameMap.values()) {
            List<String> columnNameList = MmdUtil.toColumnNameList(xmmdIndex.indexElementList);
            BcTableColumnModel tableColumnModel = XdtsUtil.createColumnDefineTableColumnModel();
            XmmdFieldTableModel fieldTableModel = new XmmdFieldTableModel(tableName, columnNameList, xmmdModel.fieldNameMap, wordManager);
            FxTableView tableView = new FxTableView();
            FxTableUtil.createColumn(tableColumnModel, tableView, null);
            FxTableRowList tableRowList = new FxTableRowList(fieldTableModel);
            tableView.setItems(tableRowList);
            HfxLoadableTablePane loadableTablePane = new HfxLoadableTablePane();
            loadableTablePane.setTableView(tableView);
            loadableTablePane.setMainContent((Node)tableView);
            boolean isPrimaryKey = false;
            isPrimaryKey = xmmdIndex.indexName.equalsIgnoreCase(xmmdModel.primaryIndexName);
            Tab keyTab = new Tab();
            if (isPrimaryKey) {
                keyTab.setText("[PK]" + xmmdIndex.indexName);
            } else {
                keyTab.setText(xmmdIndex.indexName);
            }
            keyTab.setContent((Node)loadableTablePane);
            keyTab.closableProperty().set(false);
            this.tabPane2.getTabs().add((Object)keyTab);
        }
        FxUtil.defaultInitialize((Node)this);
    }
}

