/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.fx;

import ext.lib.awt.AwtImageHelper;
import ext.lib.awt.AwtImageUtil;
import ext.lib.sql.SqlConstants;
import ext.module.xdts.swg.XdtsImageUtil;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.Map;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.ImageView;

public class XdtsFxImageUtil {
    static Map<String, javafx.scene.image.Image> imageMap = new HashMap<String, javafx.scene.image.Image>();
    static final float productImageSize = 48.0f;
    static Map<String, javafx.scene.image.Image> productImageMap = new HashMap<String, javafx.scene.image.Image>();

    private XdtsFxImageUtil() throws Exception {
    }

    public static javafx.scene.image.Image getImage(String name) throws Exception {
        javafx.scene.image.Image image = imageMap.get(name);
        if (image == null) {
            Image awtImage = AwtImageHelper.getImage(name);
            image = SwingFXUtils.toFXImage((BufferedImage)AwtImageUtil.toBufferedImage(awtImage), null);
        }
        return image;
    }

    public static ImageView createImageView_icon(String name) throws Exception {
        javafx.scene.image.Image image = XdtsFxImageUtil.getImage(name);
        ImageView imageView = new ImageView(image);
        imageView.setPreserveRatio(true);
        imageView.setSmooth(true);
        imageView.setFitWidth(16.0);
        return imageView;
    }

    public static ImageView createProductImageView(SqlConstants.DatabaseProduct databaseProduct) throws Exception {
        Image awtImage;
        javafx.scene.image.Image image = productImageMap.get(databaseProduct.productName);
        if (image == null && (awtImage = XdtsImageUtil.getProductImage(databaseProduct)) != null) {
            image = SwingFXUtils.toFXImage((BufferedImage)AwtImageUtil.toBufferedImage(awtImage), null);
            productImageMap.put(databaseProduct.productName, image);
        }
        if (image == null) {
            return null;
        }
        ImageView imageView = new ImageView(image);
        imageView.setPreserveRatio(true);
        imageView.setSmooth(true);
        imageView.setFitWidth(48.0);
        return imageView;
    }
}

