/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.dao;

import ext.base.core.BcStringUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlConditionParser;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectSql;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.xdts.model.XdtsTimer;
import java.util.List;

public class XdtsTimerDAO
extends OrmAbstractDAO<XdtsTimer> {
    private XdtsTimerDAO() {
        super(new XdtsTimer[0]);
        this.setTableName("xdts_timer");
        this.setViewName(String.valueOf(this.tableName) + "__v1");
    }

    public static XdtsTimerDAO getInstance() {
        return SingletonHolder.instance;
    }

    public List<XdtsTimer> getTimerList(DtsSession dtsSession, Integer timerId, String timerName) throws Exception {
        SqlWhereElement whereElement;
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlSelectSql selectSql = new SqlSelectSql();
        selectSql.getSelectColumnList().addAll(this.getColumnNameList(null));
        selectSql.setFromClause(String.valueOf(this.viewName) + " AS " + this.tableName);
        if (timerId != null) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("id = " + timerId);
            selectSql.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(timerName)) {
            whereElement = SqlConditionParser.getInstance().parseCondition1(sqlContext, "name", timerName, null, false);
            selectSql.addWhereElement(whereElement);
        }
        selectSql.getOrderByList().add("name");
        String query = sqlContext.buildSelectSql(selectSql);
        return this.getEntityList(dtsSession, query);
    }

    public List<XdtsTimer> getTimerList(DtsSession dtsSession) throws Exception {
        return this.getTimerList(dtsSession, null, null);
    }

    public XdtsTimer getTimerFirst(DtsSession dtsSession, Integer timerId, String timerName) throws Exception {
        XdtsTimer timer = null;
        List<XdtsTimer> timerList = this.getTimerList(dtsSession, timerId, timerName);
        if (timerList.size() > 0) {
            timer = timerList.get(0);
        }
        return timer;
    }

    public XdtsTimer getTimer(DtsSession dtsSession, int timerId) throws Exception {
        return this.getTimerFirst(dtsSession, timerId, null);
    }

    public XdtsTimer getTimerByName(DtsSession dtsSession, String timerName) throws Exception {
        return this.getTimerFirst(dtsSession, -1, timerName);
    }

    /* synthetic */ XdtsTimerDAO(XdtsTimerDAO xdtsTimerDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final XdtsTimerDAO instance = new XdtsTimerDAO(null);

        private SingletonHolder() {
        }
    }
}

