/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.common;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.log.BcLogger;
import ext.base.mmd.MmdField;
import ext.base.mmd.MmdUtil;
import ext.base.util.BcSortUtil;
import ext.lib.html.util.EtcHtmlUtil;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.SqlWords;
import ext.module.xdts.common.MyExpressionVisitor;
import ext.module.xdts.common.XdtsConstants;
import ext.module.xdts.common.XdtsWords;
import ext.module.xdts.model.XdtsControlContext;
import ext.module.xdts.model.v0001.XdtsExtractionCondition;
import ext.module.xdts.model.v0001.XdtsSelectContext;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.jsqlparser.Model;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.relational.ComparisonOperator;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.GroupByElement;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.select.WithItem;
import net.sf.jsqlparser.util.TablesNamesFinder;

public final class XdtsSqlParserUtil {
    private XdtsSqlParserUtil() {
    }

    public static String toPlaceholder(String src) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("${");
        sb.append(src);
        sb.append("}");
        return sb.toString();
    }

    public static String toSubSelectName(int selectContextId) throws Exception {
        return "SubSelect-" + selectContextId;
    }

    public static String toPlaceholderSubSelect(int selectContextId) throws Exception {
        return XdtsSqlParserUtil.toPlaceholder(XdtsSqlParserUtil.toSubSelectName(selectContextId));
    }

    public static String tempLog(String perfix, String name, String expression) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(perfix);
        sb.append("]");
        sb.append(" class=" + name);
        sb.append(" expression=" + expression);
        return sb.toString();
    }

    public static String expressionLog(String perfix, Model selectBody) throws Exception {
        return XdtsSqlParserUtil.tempLog(perfix, XdtsSqlParserUtil.getClassSimpleName(selectBody), BcStringUtil.toString(selectBody));
    }

    public static String expressionLog(String perfix, SelectItem selectItem) throws Exception {
        return XdtsSqlParserUtil.tempLog(perfix, XdtsSqlParserUtil.getClassSimpleName(selectItem), BcStringUtil.toString(selectItem));
    }

    public static String getClassSimpleName(Object object) throws Exception {
        if (object == null) {
            return null;
        }
        return object.getClass().getSimpleName();
    }

    public static void createExtractionCondition(XdtsExtractionCondition extractionCondition, Collection<MmdField> mmdFieldCollection, BcLogger logger) throws Exception {
        int i = 0;
        while (i < extractionCondition.selectContextList.size()) {
            XdtsSelectContext selectContext = extractionCondition.selectContextList.get(i);
            List<XdtsControlContext> controlContextList = XdtsSqlParserUtil.createControlContextList(mmdFieldCollection);
            selectContext.controlContextList.addAll(controlContextList);
            ++i;
        }
    }

    public static List<XdtsControlContext> createControlContextList(Collection<MmdField> mmdFieldCollection) throws Exception {
        ArrayList<XdtsControlContext> controlContextList = new ArrayList<XdtsControlContext>();
        int displayOrder = XdtsConstants.ContextType.General.displayOrderStart;
        for (MmdField mmdField : mmdFieldCollection) {
            XdtsControlContext controlContext = XdtsSqlParserUtil.createControlContext(mmdField);
            controlContext.displayOrder = displayOrder++;
            controlContextList.add(controlContext);
        }
        return controlContextList;
    }

    public static XdtsControlContext createControlContext(MmdField mmdField) throws Exception {
        XdtsControlContext controlContext = new XdtsControlContext();
        controlContext.contextType = XdtsConstants.ContextType.General;
        controlContext.tableColumnName = mmdField.tableColumnName;
        controlContext.sqlTypeId = mmdField.sqlTypeId;
        List<String> strList = EtcHtmlUtil.toStringList(MmdUtil.getProvisionalHeaderValue(mmdField));
        BcLogUtil.debug("createControlContext:strList=" + strList);
        controlContext.name = controlContext.itemName = BcStringUtil.marge(strList, String.valueOf('.')).toString();
        controlContext.columnCount = 24;
        controlContext.rowCount = 1;
        controlContext.description = mmdField.note;
        controlContext.isAnd = true;
        if (XdtsSqlParserUtil.isTextType(mmdField.dataClass)) {
            controlContext.controlType = XdtsConstants.ControlType.Text;
            controlContext.patternMatch = SqlConstants.PatternMatch.partialMatch;
        } else if (XdtsSqlParserUtil.isNumberType(mmdField.dataClass)) {
            controlContext.controlType = XdtsConstants.ControlType.Text;
        } else if (Timestamp.class.isAssignableFrom(mmdField.dataClass)) {
            controlContext.controlType = XdtsConstants.ControlType.DateTime;
        } else if (!Time.class.isAssignableFrom(mmdField.dataClass)) {
            if (Date.class.isAssignableFrom(mmdField.dataClass)) {
                controlContext.controlType = XdtsConstants.ControlType.Date;
            } else if (mmdField.dataClass == Boolean.class) {
                controlContext.controlType = XdtsConstants.ControlType.Boolean;
            } else {
                throw new Exception("mmdField.javaClassType=" + mmdField.dataClass.getName());
            }
        }
        return controlContext;
    }

    public static void toTemplate(PlainSelect plainSelect, BcLogger logger) throws Exception {
        Column column = new Column("column1");
        SelectExpressionItem selectExpressionItem = new SelectExpressionItem((Expression)column);
        ArrayList<SelectExpressionItem> selectExpressionItemList = new ArrayList<SelectExpressionItem>();
        selectExpressionItemList.add(selectExpressionItem);
        plainSelect.setSelectItems(selectExpressionItemList);
        Table table = new Table("table1");
        plainSelect.setFromItem((FromItem)table);
        plainSelect.setWhere(null);
        plainSelect.setOrderByElements(null);
        plainSelect.setLimit(null);
        plainSelect.setOffset(null);
    }

    public static boolean isTextType(int sqlTypeId) throws Exception {
        Class valueClass2 = MmdUtil.toJavaType(sqlTypeId);
        return CharSequence.class.isAssignableFrom(valueClass2);
    }

    public static boolean isTextType(Class sqlTypeClass) throws Exception {
        int sqlTypeId = MmdUtil.toSqlTypeId(sqlTypeClass);
        return XdtsSqlParserUtil.isTextType(sqlTypeId);
    }

    public static boolean isNumberType(int sqlTypeId) throws Exception {
        Class valueClass2 = MmdUtil.toJavaType(sqlTypeId);
        return Number.class.isAssignableFrom(valueClass2);
    }

    public static boolean isNumberType(Class sqlTypeClass) throws Exception {
        int sqlTypeId = MmdUtil.toSqlTypeId(sqlTypeClass);
        return XdtsSqlParserUtil.isNumberType(sqlTypeId);
    }

    public static XdtsControlContext createSelectContext() throws Exception {
        XdtsControlContext controlContext = new XdtsControlContext();
        controlContext.contextType = XdtsConstants.ContextType.Select;
        controlContext.name = controlContext.contextType.name();
        controlContext.itemName = "\u62bd\u51fa\u5217";
        controlContext.displayOrder = controlContext.contextType.displayOrderStart;
        return controlContext;
    }

    public static XdtsControlContext createFromContext() throws Exception {
        XdtsControlContext controlContext = new XdtsControlContext();
        controlContext.contextType = XdtsConstants.ContextType.From;
        controlContext.name = controlContext.contextType.name();
        controlContext.itemName = SqlWords.getInstance().fromClause;
        controlContext.columnCount = 80;
        controlContext.rowCount = 3;
        controlContext.displayOrder = controlContext.contextType.displayOrderStart;
        return controlContext;
    }

    public static XdtsControlContext createWhereContext() throws Exception {
        XdtsControlContext controlContext = new XdtsControlContext();
        controlContext.contextType = XdtsConstants.ContextType.Where;
        controlContext.name = controlContext.contextType.name();
        controlContext.itemName = SqlWords.getInstance().whereClause;
        controlContext.columnCount = 80;
        controlContext.rowCount = 3;
        controlContext.displayOrder = controlContext.contextType.displayOrderStart;
        return controlContext;
    }

    public static XdtsControlContext orderByContext() throws Exception {
        XdtsControlContext controlContext = new XdtsControlContext();
        controlContext.contextType = XdtsConstants.ContextType.OrderBy;
        controlContext.name = controlContext.contextType.name();
        controlContext.itemName = SqlWords.getInstance().orderByClause;
        controlContext.columnCount = 80;
        controlContext.rowCount = 3;
        controlContext.displayOrder = controlContext.contextType.displayOrderStart;
        return controlContext;
    }

    public static XdtsControlContext rowLimitContext() throws Exception {
        XdtsControlContext controlContext = new XdtsControlContext();
        controlContext.contextType = XdtsConstants.ContextType.RowLimit;
        controlContext.name = controlContext.contextType.name();
        controlContext.itemName = XdtsWords.getInstance().rowLimit;
        controlContext.columnCount = 10;
        controlContext.displayOrder = controlContext.contextType.displayOrderStart;
        return controlContext;
    }

    public static void parse(String sql, BcLogger logger) throws Exception {
        logger.debug("sql=" + sql);
        Statement statement = CCJSqlParserUtil.parse((String)sql);
        logger.debug("statement=" + statement + " class=" + statement.getClass().getSimpleName());
        if (statement instanceof Select) {
            Select select = (Select)statement;
            XdtsSqlParserUtil.parse(select, logger);
        }
    }

    public static void parse(Select select, BcLogger logger) throws Exception {
        SelectBody selectBody = select.getSelectBody();
        XdtsSqlParserUtil.parse(selectBody, logger);
        List withItemList = select.getWithItemsList();
        if (withItemList != null) {
            for (WithItem withItem : withItemList) {
                logger.debug("#withItem=" + withItem);
            }
        }
        TablesNamesFinder tablesNamesFinder = new TablesNamesFinder();
        List tableNames = tablesNamesFinder.getTableList((Statement)select);
        for (String tableName : tableNames) {
            logger.debug("#tableName=" + tableName);
        }
    }

    public static void parse(SelectBody selectBody, BcLogger logger) throws Exception {
        logger.debug("selectBody=" + selectBody + " class=" + selectBody.getClass().getSimpleName());
        if (selectBody instanceof PlainSelect) {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            XdtsSqlParserUtil.parse(plainSelect, logger);
        } else if (selectBody instanceof SetOperationList) {
            SetOperationList setOperationList = (SetOperationList)selectBody;
            List selectBodyList = setOperationList.getSelects();
            logger.debug("selectBodyList.size()=" + selectBodyList.size());
            XdtsSqlParserUtil.parse(setOperationList, logger);
        }
    }

    public static void parse(SetOperationList setOperationList, BcLogger logger) throws Exception {
        List selectBodyList = setOperationList.getSelects();
        for (SelectBody selectBody : selectBodyList) {
            XdtsSqlParserUtil.parse(selectBody, logger);
        }
        List bracketList = setOperationList.getBrackets();
        logger.debug("bracketList=" + bracketList);
        logger.debug("setOperationList.getFetch()=" + setOperationList.getFetch());
        logger.debug("setOperationList.getLimit()=" + setOperationList.getLimit());
        logger.debug("setOperationList.getOffset()=" + setOperationList.getOffset());
        List operationList = setOperationList.getOperations();
        logger.debug("operationList=" + operationList);
        List orderByElement = setOperationList.getOrderByElements();
        logger.debug("orderByElement=" + orderByElement);
    }

    public static void parse(PlainSelect plainSelect, BcLogger logger) throws Exception {
        block10: {
            List joinList;
            int i = 0;
            while (i < plainSelect.getSelectItems().size()) {
                SelectItem selectItem = (SelectItem)plainSelect.getSelectItems().get(i);
                logger.debug("selectItem=" + selectItem);
                ++i;
            }
            FromItem fromItem = plainSelect.getFromItem();
            logger.debug("fromItem=" + fromItem);
            if (fromItem != null) {
                XdtsSqlParserUtil.parse(fromItem, logger);
            }
            if ((joinList = plainSelect.getJoins()) != null) {
                int i2 = 0;
                while (i2 < joinList.size()) {
                    Join join = (Join)joinList.get(i2);
                    logger.debug("join=" + join);
                    ++i2;
                }
            }
            Expression whereExpression = plainSelect.getWhere();
            logger.debug("where=" + whereExpression);
            if (whereExpression != null) {
                logger.debug("whereExpression.class=" + whereExpression.getClass().getSimpleName());
                MyExpressionVisitor expressionVisitor = new MyExpressionVisitor();
                Expression expressionWk = whereExpression;
                while (true) {
                    Expression rightExpression;
                    Expression leftExpression;
                    if (expressionWk instanceof ComparisonOperator) {
                        ComparisonOperator comparisonOperator = (ComparisonOperator)expressionWk;
                        leftExpression = comparisonOperator.getLeftExpression();
                        rightExpression = comparisonOperator.getRightExpression();
                        logger.debug("  leftExpression=" + leftExpression + " class=" + leftExpression.getClass().getSimpleName());
                        logger.debug("  rightExpression=" + rightExpression + " class=" + rightExpression.getClass().getSimpleName());
                        logger.debug("  getStringExpression=" + comparisonOperator.getStringExpression());
                        break block10;
                    }
                    if (!(expressionWk instanceof BinaryExpression)) break;
                    BinaryExpression binaryExpression = (BinaryExpression)expressionWk;
                    leftExpression = binaryExpression.getLeftExpression();
                    rightExpression = binaryExpression.getRightExpression();
                    logger.debug("  leftExpression=" + leftExpression + " class=" + leftExpression.getClass().getSimpleName());
                    logger.debug("  rightExpression=" + rightExpression + " class=" + rightExpression.getClass().getSimpleName());
                    expressionWk = leftExpression;
                }
                logger.debug("?");
            }
        }
        GroupByElement groupByElement = plainSelect.getGroupBy();
        logger.debug("groupByElement=" + groupByElement);
        Expression having = plainSelect.getHaving();
        logger.debug("having=" + having);
        List orderByElementList = plainSelect.getOrderByElements();
        logger.debug("orderByElementList=" + orderByElementList);
        if (orderByElementList != null) {
            int i = 0;
            while (i < orderByElementList.size()) {
                OrderByElement orderByElement = (OrderByElement)orderByElementList.get(i);
                logger.debug("orderByElement.getExpression()=" + orderByElement.getExpression());
                logger.debug("orderByElement.isAsc()=" + orderByElement.isAsc());
                ++i;
            }
        }
        Limit limit = plainSelect.getLimit();
        logger.debug("limit=" + limit);
        if (limit != null) {
            Expression rowCount = limit.getRowCount();
            Expression offset = limit.getOffset();
            logger.debug("rowCount=" + rowCount + " offset=" + offset);
        }
    }

    public static void parse(FromItem fromItem, BcLogger logger) throws Exception {
        logger.debug("fromItem.getClass=" + fromItem.getClass().getSimpleName());
        if (fromItem instanceof SubSelect) {
            SubSelect subSelect = (SubSelect)fromItem;
            XdtsSqlParserUtil.parse(subSelect, logger);
        } else {
            logger.debug("????????????????");
        }
    }

    public static void parse(SubSelect subSelect, BcLogger logger) throws Exception {
        logger.debug("subSelect.getAlias()=" + subSelect.getAlias());
        logger.debug("subSelect.getPivot()=" + subSelect.getPivot());
        logger.debug("subSelect.getUnPivot()=" + subSelect.getUnPivot());
        SelectBody selectBody = subSelect.getSelectBody();
        XdtsSqlParserUtil.parse(selectBody, logger);
        List withItemsList = subSelect.getWithItemsList();
        logger.debug("withItemsList=" + withItemsList);
    }

    public static List<XdtsControlContext> sortControlContext(Collection<XdtsControlContext> controlContextCollection) throws Exception {
        ArrayList<XdtsControlContext> controlContextList = new ArrayList<XdtsControlContext>();
        controlContextList.addAll(controlContextCollection);
        BcSortUtil.sort(controlContextList, true, new Object[]{"displayOrder"});
        return controlContextList;
    }
}

