/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xdts.common;

import ext.base.mmd.MmdUtil;
import ext.lib.sql.SqlConstants;

public final class XdtsConstants {
    public static final int OBJ_TYPE_null = -1;
    public static final int OBJ_TYPE_table = 1;
    public static final int OBJ_TYPE_view = 2;
    public static final String SYMBOL_tableName = "${tableName}";
    public static final String SYMBOL_viewName = "${viewName}";
    public static final int PROPITID_destFile = 1011;
    public static final int PROPITID_destDir = 1012;
    public static final int PROPITID_errorFile = 1031;
    public static final int[] triggerIds = new int[]{11, 12, 21};
    public static final String DIR_resource = "${ROOT}resource/";
    public static final String DIR_template = "${ROOT}resource/template/";
    public static final String SQL_DROP_TABLE = "DROP TABLE ${tableName}";
    public static final String SQL_TRUNCATE = "TRUNCATE ${tableName}";
    public static final String SQL_DELETE = "DELETE FROM ${tableName}";
    public static final String SQL_GRANT_ALL = "GRANT ALL ON TABLE ${tableName} TO role";
    public static final String SQL_GRANT_SELECT = "GRANT SELECT, UPDATE, INSERT ON ${tableName} TO role";
    public static final String SQL_REVOKE_ALL = "REVOKE ALL ON ${tableName} FROM role";
    public static final String SQL_REVOKE_SELECT = "REVOKE SELECT, UPDATE, INSERT ON ${tableName} FROM role";
    public static final String SQL_DROP_VIEW = "DROP VIEW ${viewName}";
    public static final String FN_sql_output = "rydeen_sql.txt";
    public static final String FN_error = "rydeen_error.txt";
    public static int LIMIT_tableCount = -1;
    public static int LIMIT_recordCount = -1;
    public static SqlConstants.DatabaseProduct[] databaseProducts = new SqlConstants.DatabaseProduct[]{SqlConstants.DatabaseProduct.H2, SqlConstants.DatabaseProduct.PostgreSQL, SqlConstants.DatabaseProduct.MySQL, SqlConstants.DatabaseProduct.SQLServer, SqlConstants.DatabaseProduct.DB2, SqlConstants.DatabaseProduct.Oracle, SqlConstants.DatabaseProduct.ACCESS};
    public static final int ROW_LIMIT_DEFAULT = 100;

    private XdtsConstants() {
    }

    public static int triggerIdToIndex(int triggerId) {
        int i = 0;
        while (i < triggerIds.length) {
            if (triggerIds[i] == triggerId) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int getIndex(SqlConstants.DatabaseProduct databaseProduct) {
        int i = 0;
        while (i < databaseProducts.length) {
            if (databaseProduct == databaseProducts[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean isTableDefinition() throws Exception {
        return true;
    }

    public static enum Category {
        dev(null),
        search(null);

        public final String description;

        private Category(String description) {
            this.description = description;
        }
    }

    public static enum CommitMode {
        NULL(null),
        TABLE("\u30c6\u30fc\u30d6\u30eb\u6bce"),
        FINAL("\u6700\u5f8c"),
        AUTO("\u81ea\u52d5"),
        OFF("\u7121\u52b9");

        public final String description;

        private CommitMode(String description) {
            this.description = description;
        }
    }

    public static enum ContextType {
        Select(-1, "SELECT"),
        From(-1, "FROM"),
        Where(-1, "WHERE"),
        OrderBy(-1, "ORDER BY"),
        RowLimit(200, "LIMIT"),
        General(100, null);

        public final int displayOrderStart;
        public final String description;

        private ContextType(int displayOrderStart, String description) {
            this.displayOrderStart = displayOrderStart;
            this.description = description;
        }
    }

    public static enum ControlType {
        Text(null),
        CheckBox(null),
        RadioButton(null),
        DateTime(null),
        Date(null),
        Boolean(null);

        public final String description;

        private ControlType(String description) {
            this.description = description;
        }
    }

    public static enum FileType {
        def(null),
        user(null);

        public final String description;

        private FileType(String description) {
            this.description = description;
        }
    }

    public static enum SchemaObjectType {
        table(1, "T"),
        view(2, "V"),
        sql(91, "S"),
        condition(92, "C");

        public final int id;
        public final String symbol;

        private SchemaObjectType(int id, String symbol) {
            this.id = id;
            this.symbol = symbol;
        }
    }

    public static interface TableColumnName {
        public String tableName();

        public String columnName();

        public String tableColumnName();
    }

    public static enum TableName {
        xdts_profile,
        xdts_property;

    }

    public static enum xdts_profile implements TableColumnName
    {
        id,
        name,
        group_;

        private final String tableName = TableName.xdts_profile.name();
        private final String tableColumnName = MmdUtil.createTableColumnName(this.tableName, this.name());

        @Override
        public String tableName() {
            return this.tableName;
        }

        @Override
        public String columnName() {
            return this.name();
        }

        @Override
        public String tableColumnName() {
            return this.tableColumnName;
        }
    }
}

