/*
 * Decompiled with CFR 0.152.
 */
package ext.module.wbs1.dao;

import ext.base.util.BcCollectionUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectSql;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.wbs1.model.Wbs1Attendance;
import java.util.List;

public class Wbs1AttendanceDAO
extends OrmAbstractDAO<Wbs1Attendance> {
    public static final int MODE_default = 1;
    public static final int MODE_personId = 2;
    public static final int MODE_startDate = 3;

    private Wbs1AttendanceDAO() {
        super(new Wbs1Attendance[0]);
        this.setTableName("wbs1_attendance");
    }

    public static Wbs1AttendanceDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectSql createSelectSql(SqlContext sqlContext, int mode, String alias, long attendanceId, long personId, long workspaceId, int startDate, int endDate) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectSql selectSql = new SqlSelectSql();
        if (attendanceId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "id =" + attendanceId);
            selectSql.addWhereElement(whereElement);
        }
        if (personId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "person_id = " + personId);
            selectSql.addWhereElement(whereElement);
        }
        if (workspaceId > 0L) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "workspace_id = " + workspaceId);
            selectSql.addWhereElement(whereElement);
        }
        if (startDate > 0 || endDate > 0) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(sqlContext.toCondition_period_yyyyMMdd(String.valueOf(aliasWk) + "start_date", startDate, endDate));
            selectSql.addWhereElement(whereElement);
        }
        selectSql.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        if (mode == 1) {
            selectSql.getOrderByList().add(String.valueOf(aliasWk) + "id");
        } else if (mode == 2) {
            selectSql.getOrderByList().add(String.valueOf(aliasWk) + "person_id");
            selectSql.getOrderByList().add(String.valueOf(aliasWk) + "start_date");
            selectSql.getOrderByList().add(String.valueOf(aliasWk) + "start_time");
            selectSql.getOrderByList().add(String.valueOf(aliasWk) + "end_date");
            selectSql.getOrderByList().add(String.valueOf(aliasWk) + "end_time");
        } else if (mode == 3) {
            selectSql.getOrderByList().add(String.valueOf(aliasWk) + "workspace_id");
            selectSql.getOrderByList().add(String.valueOf(aliasWk) + "start_date");
            selectSql.getOrderByList().add(String.valueOf(aliasWk) + "start_time");
            selectSql.getOrderByList().add(String.valueOf(aliasWk) + "end_date");
            selectSql.getOrderByList().add(String.valueOf(aliasWk) + "end_time");
        }
        selectSql.getSelectColumnList().addAll(this.getColumnNameList(alias));
        return selectSql;
    }

    public List<Wbs1Attendance> getList(DtsSession dtsSession, int mode, long attendanceId, long personId, long workspaceId, int startDate, int endDate) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "a";
        SqlSelectSql selectSql = this.createSelectSql(sqlContext, mode, alias, attendanceId, personId, workspaceId, startDate, endDate);
        String query = sqlContext.buildSelectSql(selectSql);
        return this.getEntityList(dtsSession, query);
    }

    public Wbs1Attendance getById(DtsSession dtsSession, long attendanceId) throws Exception {
        if (attendanceId <= 0L) {
            return null;
        }
        long personId = -1L;
        long workspaceId = -1L;
        List<Wbs1Attendance> entityList = this.getList(dtsSession, 1, attendanceId, personId, workspaceId, -1, -1);
        return BcCollectionUtil.getFirst(entityList);
    }

    public List<Wbs1Attendance> getListByPersonId(DtsSession dtsSession, long personId, long workspaceId, int startDate, int endDate) throws Exception {
        if (personId <= 0L) {
            return null;
        }
        long attendanceId = -1L;
        return this.getList(dtsSession, 2, attendanceId, personId, workspaceId, startDate, endDate);
    }

    public List<Wbs1Attendance> getListByPeriod(DtsSession dtsSession, long workspaceId, int startDate, int endDate) throws Exception {
        long attendanceId = -1L;
        long personId = -1L;
        return this.getList(dtsSession, 3, attendanceId, personId, workspaceId, startDate, endDate);
    }

    /* synthetic */ Wbs1AttendanceDAO(Wbs1AttendanceDAO wbs1AttendanceDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final Wbs1AttendanceDAO instance = new Wbs1AttendanceDAO(null);

        private SingletonHolder() {
        }
    }
}

