/*
 * Decompiled with CFR 0.152.
 */
package ext.module.impt.swg;

import ext.base.log.BcLogUtil;
import ext.base.thread.BcMonitor;
import ext.base.util.BcWords;
import ext.lib.rmi.model.RmiRequest;
import ext.lib.rmi.model.RmiRespons;
import ext.module.impt.common.ImptWords;
import ext.module.impt.model.ImptImportContext;
import ext.module.impt.rmo.ImptGeneralRMO;
import ext.module.impt.rmo.ImptImportProcessRMO;
import ext.module.impt.swg.ImptImportPanel;
import ext.scf.client.ScfClientContainer;
import ext.scf2.client.ScfFileUploader;
import ext.scf4.swg.HswgProcessingPane;
import java.io.File;
import javax.swing.JOptionPane;

public class ImptImportExecuteThread
extends Thread {
    ScfFileUploader fileUpoader;
    ImptImportPanel pa;

    public ImptImportExecuteThread(ImptImportPanel pa) throws Exception {
        this.pa = pa;
        this.fileUpoader = new ScfFileUploader(ScfClientContainer.getInstance().getAgent());
    }

    @Override
    public void run() {
        try {
            int i = 0;
            while (i < this.pa.sourceFileList.size()) {
                File file = this.pa.sourceFileList.get(i);
                this.fileUpload(file);
                ++i;
            }
            this.executeImport();
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            JOptionPane.showMessageDialog(this.pa, ex.getMessage(), BcWords.getInstance().exception, 0);
        }
        this.pa.close();
    }

    protected void fileUpload(File dataSourceFile) throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(ImptGeneralRMO.class.getName());
        rmiReq.setMethodName("getSourceRegistDirectry");
        rmiReq.addData(this.pa.defineIndex.getDataId());
        RmiRespons rmiRes = ScfClientContainer.getInstance().getAgent().invoke(rmiReq);
        ImptImportContext importContext = (ImptImportContext)rmiRes.getData();
        this.pa.importCondition.importContextdList.add(importContext.getDataId());
        this.pa.importCondition.souceFileList.add(dataSourceFile);
        String svFilePath = rmiRes.getDataAsString();
        BcMonitor mon = new BcMonitor();
        BcLogUtil.debug("\u30c7\u30fc\u30bf\u30bd\u30fc\u30b9\u3092\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u4e2d...");
        this.fileUpoader.upload(dataSourceFile, svFilePath, mon, null);
        mon.sync();
    }

    protected void executeImport() throws Exception {
        RmiRequest rmiReq = new RmiRequest();
        rmiReq.setClassName(ImptImportProcessRMO.class.getName());
        rmiReq.setMethodName("doImport");
        rmiReq.addData(this.pa.importCondition);
        rmiReq.addData(this.pa.importDefine);
        HswgProcessingPane processingPane = new HswgProcessingPane();
        processingPane.setRequest(rmiReq);
        processingPane.showAsFrame(String.valueOf(ImptWords.getInstance().\u30c7\u30fc\u30bf\u53d6\u8fbc) + "\u3092\u5b9f\u884c\u4e2d");
    }
}

