/*
 * Decompiled with CFR 0.152.
 */
package ext.module.impt.swg;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.thread.BcMonitor;
import ext.base.util.BcDataCheckUtil;
import ext.base.util.BcWords;
import ext.lib.awt.AwtImageHelper;
import ext.lib.swg.SwgButton;
import ext.lib.swg.SwgDecoratePanel;
import ext.lib.swg.SwgDialog;
import ext.lib.swg.SwgFileChooser;
import ext.lib.swg.SwgNumberField;
import ext.lib.swg.SwgTextField;
import ext.lib.swg.SwgUtil;
import ext.module.impt.common.ImptWords;
import ext.module.impt.model.ImptDefineIndex;
import ext.module.impt.stub.ImptGeneralStub;
import ext.scf.client.ScfClientContainer;
import ext.scf2.client.ScfFileUploader;
import ext.scf2.stub.ScfFileStub;
import ext.scf5.model.ScfFileResource;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class ImptDefineIndexPanel
extends SwgDecoratePanel {
    private static final long serialVersionUID = 6362726440747051428L;
    protected SwgNumberField idField = new SwgNumberField(-1, 0, false, "-1");
    protected SwgTextField codeField = new SwgTextField();
    protected SwgTextField nameField = new SwgTextField();
    protected SwgNumberField classIdField = new SwgNumberField(-1, 0, false, "-1");
    protected SwgNumberField displayNoField = new SwgNumberField(-1, 0, false, "-1");
    protected SwgTextField noteField = new SwgTextField();
    protected SwgNumberField fileResourceIdField = new SwgNumberField(-1, 0, false, "-1");
    protected SwgTextField fileResourceNameField = new SwgTextField();
    protected SwgTextField defFilePathField = new SwgTextField();
    protected SwgButton defFileBrowsButton = new SwgButton("\u53c2\u7167");
    protected SwgFileChooser fileChooser = new SwgFileChooser();
    protected ScfFileUploader fileUploader;
    protected ImptDefineIndex defineIndex;
    protected boolean resBool;
    protected Window window;
    protected Component thisComp;

    public ImptDefineIndexPanel() throws Exception {
        this.setBorderSize(20, 40, 10, 10);
        this.setLine();
        this.setOkButton(BcWords.getInstance().completion);
        this.setCancelButton(BcWords.getInstance().cancel);
        this.thisComp = this;
        this.defFileBrowsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ImptDefineIndexPanel.this.fileChooser.resetChoosableFileFilters();
                if (!BcStringUtil.isEmpty(ImptDefineIndexPanel.this.defFilePathField.getText())) {
                    ImptDefineIndexPanel.this.fileChooser.setSelectedFile(new File(ImptDefineIndexPanel.this.defFilePathField.getText()));
                }
                switch (ImptDefineIndexPanel.this.fileChooser.showDialog(ImptDefineIndexPanel.this.thisComp, "\u9078\u629e")) {
                    case 0: {
                        ImptDefineIndexPanel.this.defFilePathField.setText(ImptDefineIndexPanel.this.fileChooser.getSelectedFile().getPath());
                        break;
                    }
                }
            }
        });
        this.idField.setEditable(false);
        this.fileResourceIdField.setEditable(false);
        this.fileResourceNameField.setEditable(false);
        this.fileUploader = new ScfFileUploader(ScfClientContainer.getInstance().getAgent());
        this.setComponent();
    }

    protected void setComponent() {
        int rowHeight = SwgUtil.getTextFieldHeight(this.getFont(), null);
        int rowGap = SwgUtil.getRowDiff(this.getFont());
        int colGap = SwgUtil.getColDiff(this.getFont());
        int c1x = 0;
        int c1w = 80;
        int c2x = c1x + c1w + colGap;
        int ly = rowHeight;
        SwgUtil.setLocation(this.centerPanel, new JLabel("ID", 4), (double)c1x, (double)ly, (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.idField, (double)c2x, (double)ly, 60.0, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, new JLabel("\u30b3\u30fc\u30c9", 4), (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.codeField, (double)c2x, (double)ly, 120.0, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, new JLabel("\u540d\u79f0", 4), (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.nameField, (double)c2x, (double)ly, 400.0, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, new JLabel("\u533a\u5206ID", 4), (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.classIdField, (double)c2x, (double)ly, 60.0, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, new JLabel("\u8868\u793a\u9806\u4f4d", 4), (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.displayNoField, (double)c2x, (double)ly, 60.0, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, new JLabel("\u5099\u8003", 4), (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.noteField, (double)c2x, (double)ly, 300.0, (double)rowHeight);
        ly += rowHeight + rowGap;
        SwgUtil.setLocation(this.centerPanel, new JLabel("\u30ea\u30bd\u30fc\u30b9ID", 4), (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.fileResourceIdField, (double)c2x, (double)ly, 60.0, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, new JLabel("\u30ea\u30bd\u30fc\u30b9\u540d", 4), (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.fileResourceNameField, (double)c2x, (double)ly, 400.0, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, new JLabel("\u5b9a\u7fa9\u30d5\u30a1\u30a4\u30eb", 4), (double)c1x, (double)(ly += rowHeight + rowGap), (double)c1w, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.defFilePathField, (double)c2x, (double)ly, 520.0, (double)rowHeight);
        SwgUtil.setLocation(this.centerPanel, this.defFileBrowsButton, (double)(c2x + 520), (double)ly, -1.0, (double)rowHeight);
        ly += rowHeight + rowGap;
    }

    protected void setDataId(int defineIndexId) throws Exception {
        this.resBool = false;
        if (defineIndexId <= 0) {
            this.defineIndex = new ImptDefineIndex();
            this.idField.setText(Integer.toString(this.defineIndex.getDataId()));
        } else {
            this.defineIndex = ImptGeneralStub.getInstance().getDefineIndex(defineIndexId);
            this.idField.setText(Integer.toString(this.defineIndex.getDataId()));
            this.codeField.setText(this.defineIndex.code);
            this.nameField.setText(this.defineIndex.name);
            this.classIdField.setText(Integer.toString(this.defineIndex.classId));
            this.displayNoField.setText(Integer.toString(this.defineIndex.displayNo));
            this.noteField.setText(this.defineIndex.note);
            ScfFileResource fileResource = ImptGeneralStub.getInstance().getFileResource(this.defineIndex.fileResourceId);
            this.fileResourceIdField.setText(Integer.toString(fileResource.getDataId()));
            this.fileResourceNameField.setText(fileResource.fileName);
        }
    }

    @Override
    protected void okButtonAction() throws Exception {
        ArrayList<String> msgList = new ArrayList<String>();
        BcDataCheckUtil.textNotNullable(this.codeField.getText(), "\u30b3\u30fc\u30c9", msgList);
        BcDataCheckUtil.textNotNullable(this.nameField.getText(), "\u540d\u79f0", msgList);
        File defFile = null;
        if (!BcStringUtil.isEmpty(this.defFilePathField.getText()) && !(defFile = new File(this.defFilePathField.getText())).exists()) {
            msgList.add("\u5b9a\u7fa9\u30d5\u30a1\u30a4\u30eb\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
        }
        if (msgList.size() > 0) {
            JOptionPane.showMessageDialog(this, SwgUtil.createMessageComponent(null, msgList), BcWords.getInstance().warning, 2);
            return;
        }
        if (defFile != null) {
            String svDirPath = ScfFileStub.getInstance().getTemporaryDirPath();
            BcMonitor mon = new BcMonitor();
            this.fileUploader.upload(defFile, svDirPath, mon, null);
            mon.sync();
        }
        this.defineIndex.code = this.codeField.getText();
        this.defineIndex.name = this.nameField.getText();
        this.defineIndex.classId = this.classIdField.getBigDecimal().intValue();
        this.defineIndex.displayNo = this.displayNoField.getBigDecimal().intValue();
        this.defineIndex.note = this.noteField.getText();
        if (defFile != null) {
            ImptGeneralStub.getInstance().putDefineIndex(this.defineIndex, defFile.getName());
        } else {
            ImptGeneralStub.getInstance().putDefineIndex(this.defineIndex, null);
        }
        this.resBool = true;
        this.close();
    }

    @Override
    protected void cancelButtonAction() throws Exception {
        this.defineIndex = null;
        this.close();
    }

    @Override
    public void close() {
        this.window.dispose();
    }

    public boolean showAsDialog(int defineIndexId, Component ownerCompo) throws Exception {
        this.setDataId(defineIndexId);
        SwgDialog dialog = SwgUtil.createDialog(ownerCompo);
        dialog.getContentPane().add((Component)this, "Center");
        dialog.setModal(true);
        dialog.setResizable(false);
        dialog.setDefaultCloseOperation(0);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                try {
                    ImptDefineIndexPanel.this.cancelButtonAction();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        });
        this.window = dialog;
        dialog.setTitle(ImptWords.getInstance().\u30c7\u30fc\u30bf\u53d6\u8fbc\u5b9a\u7fa9);
        dialog.setIconImage(AwtImageHelper.getWindowIconImage());
        SwgUtil.setCenter(dialog, 700.0, 420.0);
        dialog.setVisible(true);
        return this.resBool;
    }
}

