/*
 * Decompiled with CFR 0.152.
 */
package ext.libx.business.address;

import ext.base.table.BcTableModel;
import ext.base.util.BcCsvUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class BsnAddressUtil {
    public static Map<String, List<String>> prefectureMap;

    private BsnAddressUtil() {
    }

    public static BcTableModel createMunicipalityTable() throws Exception {
        String fileName = "\u90fd\u9053\u5e9c\u770c\u30b3\u30fc\u30c9\u53ca\u3073\u5e02\u533a\u753a\u6751\u30b3\u30fc\u30c9_\u4ee4\u548c6\u5e741\u67081\u65e5\u66f4\u65b0_000925835.csv";
        InputStream inputStream = BsnAddressUtil.class.getResourceAsStream(fileName);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        BcTableModel tableModel = BcCsvUtil.csvToTable(inputStreamReader, 1);
        return tableModel;
    }

    public static Map<String, List<String>> createPrefectureMap() throws Exception {
        BcTableModel tableModel = BsnAddressUtil.createMunicipalityTable();
        LinkedHashMap<String, List<String>> prefectureMap = new LinkedHashMap<String, List<String>>();
        int i = 0;
        while (i < tableModel.getRowCount()) {
            String prefecture = (String)tableModel.getValueAt(i, 1);
            String municipality = (String)tableModel.getValueAt(i, 2);
            ArrayList<String> municipalityList = (ArrayList<String>)prefectureMap.get(prefecture);
            if (municipalityList == null) {
                municipalityList = new ArrayList<String>();
                prefectureMap.put(prefecture, municipalityList);
            }
            municipalityList.add(municipality);
            ++i;
        }
        return prefectureMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, List<String>> getPrefectureMap() throws Exception {
        if (prefectureMap != null) return prefectureMap;
        Class<BsnAddressUtil> clazz = BsnAddressUtil.class;
        synchronized (BsnAddressUtil.class) {
            if (prefectureMap != null) return prefectureMap;
            prefectureMap = BsnAddressUtil.createPrefectureMap();
            // ** MonitorExit[var0] (shouldn't be in output)
            return prefectureMap;
        }
    }
}

