/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.tree;

import ext.base.core.BcInteger;
import ext.lib.tree.BcTreeNode;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public final class BcTreeUtil {
    private BcTreeUtil() {
    }

    public static Hashtable toHashtable(TreeModel treeModel, String delimiter) {
        Hashtable hashtable = new Hashtable();
        TreeNode rootTreeNode = (TreeNode)treeModel.getRoot();
        BcTreeUtil.toHashtable2(rootTreeNode, hashtable, delimiter);
        return hashtable;
    }

    protected static void toHashtable2(TreeNode parentTreeNode, Map map, String delimiter) {
        int i = 0;
        while (i < parentTreeNode.getChildCount()) {
            TreeNode treeNode = parentTreeNode.getChildAt(i);
            map.put(BcTreeUtil.getPath(treeNode, delimiter), treeNode);
            BcTreeUtil.toHashtable2(treeNode, map, delimiter);
            ++i;
        }
    }

    protected static String getPath(TreeNode reefTreeNode, String delimiter) {
        String retStr = reefTreeNode.toString();
        TreeNode treeNode = reefTreeNode;
        while ((treeNode = treeNode.getParent()) != null) {
            retStr = String.valueOf(treeNode.toString()) + delimiter + retStr;
        }
        return retStr;
    }

    public static void expandAll(JTree treeView) {
        int rowCount = treeView.getRowCount();
        int i = 0;
        while (i < rowCount) {
            treeView.expandRow(rowCount - i - 1);
            ++i;
        }
    }

    public static void collapseAll(JTree treeView) {
        int rowCount = treeView.getRowCount();
        int i = 0;
        while (i < rowCount) {
            treeView.collapseRow(rowCount - i - 1);
            ++i;
        }
    }

    public static int getChiledCountAll(BcTreeNode treeNode) {
        BcInteger count = new BcInteger(0);
        ++count.value;
        int i = 0;
        while (i < treeNode.getChildCount()) {
            BcTreeNode childNode = (BcTreeNode)treeNode.getChildAt(i);
            BcTreeUtil.getChiledCountAll(childNode, count);
            ++i;
        }
        return count.value;
    }

    protected static void getChiledCountAll(BcTreeNode treeNode, BcInteger count) {
        ++count.value;
        int i = 0;
        while (i < treeNode.getChildCount()) {
            BcTreeNode childNode = (BcTreeNode)treeNode.getChildAt(i);
            BcTreeUtil.getChiledCountAll(childNode, count);
            ++i;
        }
    }

    public static TreeNode getNodeByHashCode(TreeNode baseTreeNode, int hashcode) {
        if (baseTreeNode.hashCode() == hashcode) {
            return baseTreeNode;
        }
        int i = 0;
        while (i < baseTreeNode.getChildCount()) {
            TreeNode childNode = baseTreeNode.getChildAt(i);
            TreeNode tmpTreeNode = BcTreeUtil.getNodeByHashCode(childNode, hashcode);
            if (tmpTreeNode != null) {
                return tmpTreeNode;
            }
            ++i;
        }
        return null;
    }

    public static BcTreeNode getNodeById(BcTreeNode treeNode, int dataId) {
        if (treeNode.transId == dataId) {
            return treeNode;
        }
        int i = 0;
        while (i < treeNode.getChildCount()) {
            BcTreeNode childNode = (BcTreeNode)treeNode.getChildAt(i);
            BcTreeNode tmpTreeNode = BcTreeUtil.getNodeById(childNode, dataId);
            if (tmpTreeNode != null) {
                return tmpTreeNode;
            }
            ++i;
        }
        return null;
    }

    public static void setSequenceNumber(BcTreeNode treeNode) {
        BcInteger intNum = new BcInteger(0);
        ++intNum.value;
        treeNode.transId = intNum.value;
        int i = 0;
        while (i < treeNode.getChildCount()) {
            BcTreeNode childNode = (BcTreeNode)treeNode.getChildAt(i);
            BcTreeUtil.setNumber(childNode, intNum);
            ++i;
        }
    }

    protected static void setNumber(BcTreeNode treeNode, BcInteger intNum) {
        ++intNum.value;
        treeNode.transId = intNum.value;
        int i = 0;
        while (i < treeNode.getChildCount()) {
            BcTreeNode childNode = (BcTreeNode)treeNode.getChildAt(i);
            BcTreeUtil.setNumber(childNode, intNum);
            ++i;
        }
    }
}

