/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.swg.lookAndFeel;

import com.nilo.plaf.nimrod.NimRODTheme;
import ext.base.core.BcConstants;
import ext.base.log.BcLogUtil;
import ext.base.runtime.BcRuntimeUtil;
import ext.lib.swg.SwgMenu;
import ext.lib.swg.SwgMenuItem;
import ext.lib.swg.lookAndFeel.SwgLafConstants;
import ext.lib.swg.lookAndFeel.SwgLafManager;
import ext.lib.swg.lookAndFeel.SwgLafNimrodUtil;
import ext.lib.swg.lookAndFeel.SwgLafUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileInputStream;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;

public class SwgLafMenu {
    File themaDir = new File("C:/ext_develop/ews_ext_g31/2221_swing/src/com/nilo/plaf/nimrod/theme/");
    protected ItemListener itemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent ev) {
            if (ev.getStateChange() == 1) {
                try {
                    SwgLafMenu.this.itemSelected(ev);
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        }
    };
    protected ButtonGroup buttonGroup = new ButtonGroup();
    protected Component rootComp;
    SwgMenuItem testMenu = new SwgMenuItem("TEST");
    public final ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            try {
                SwgLafMenu.this.actionEvent(ev);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
    };

    public SwgMenu createMenu(JMenu parentMenu, Component rootComp) {
        this.rootComp = rootComp;
        SwgMenu lookAndFeelMenu = new SwgMenu("Look and Feel");
        parentMenu.add(lookAndFeelMenu);
        int osType = BcRuntimeUtil.getOsType();
        int i = 0;
        while (i < SwgLafConstants.themeNames.length) {
            String themeName = SwgLafConstants.themeNames[i];
            JRadioButtonMenuItem menuItem = new JRadioButtonMenuItem(themeName);
            menuItem.addItemListener(this.itemListener);
            this.buttonGroup.add(menuItem);
            lookAndFeelMenu.add(menuItem);
            if (themeName.equals("GTK")) {
                menuItem.setEnabled(osType == 11);
            }
            if (themeName.equals("Macintosh")) {
                menuItem.setEnabled(osType == 21);
            }
            if (themeName.equals("Windows")) {
                menuItem.setEnabled(osType == 31);
            }
            ++i;
        }
        lookAndFeelMenu.addSeparator();
        SwgLafNimrodUtil.ThemeNames[] themeNamesArray = SwgLafNimrodUtil.ThemeNames.values();
        int menuItem = themeNamesArray.length;
        int themeName = 0;
        while (themeName < menuItem) {
            SwgLafNimrodUtil.ThemeNames themeName2 = themeNamesArray[themeName];
            JRadioButtonMenuItem menuItem2 = new JRadioButtonMenuItem(themeName2.name());
            menuItem2.addItemListener(this.itemListener);
            this.buttonGroup.add(menuItem2);
            lookAndFeelMenu.add(menuItem2);
            ++themeName;
        }
        lookAndFeelMenu.addSeparator();
        i = 0;
        while (i < SwgLafConstants.metalThemeNames.length) {
            String themeName3 = SwgLafConstants.metalThemeNames[i];
            JRadioButtonMenuItem menuItem3 = new JRadioButtonMenuItem(themeName3);
            menuItem3.addItemListener(this.itemListener);
            this.buttonGroup.add(menuItem3);
            lookAndFeelMenu.add(menuItem3);
            ++i;
        }
        if (BcConstants.DEVELOPMENT) {
            JRadioButtonMenuItem menuItem4 = new JRadioButtonMenuItem("TEST");
            menuItem4.addItemListener(this.itemListener);
            this.buttonGroup.add(menuItem4);
            this.testMenu.addActionListener(this.actionListener);
            lookAndFeelMenu.add(this.testMenu);
        }
        return lookAndFeelMenu;
    }

    protected void itemSelected(ItemEvent ev) throws Exception {
        AbstractButton button = (AbstractButton)ev.getSource();
        try {
            String themeName = button.getText();
            SwgLafManager.getInstance().setTheme(this.rootComp, themeName);
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
            String themeName = SwgLafUtil.getDefaultThemeName();
            SwgLafManager.getInstance().setTheme(this.rootComp, themeName);
        }
    }

    protected void actionEvent(ActionEvent ev) throws Exception {
        if (ev.getSource().hashCode() == this.testMenu.hashCode()) {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setCurrentDirectory(this.themaDir);
            switch (fileChooser.showDialog(this.rootComp, "\u9078\u629e")) {
                case 0: {
                    File file = fileChooser.getSelectedFile();
                    FileInputStream io = new FileInputStream(file);
                    NimRODTheme nimRODTheme = SwgLafNimrodUtil.createTheme(io);
                    SwgLafNimrodUtil.setTheme(nimRODTheme);
                    SwingUtilities.updateComponentTreeUI(this.rootComp);
                }
            }
        }
    }
}

