/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.sql;

import ext.base.log.BcLoggableObject;
import ext.lib.sql.SqlConnection;
import ext.lib.sql.SqlConstants;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlStatementTimeoutException;
import ext.lib.sql.SqlStatementTimeoutMonitor;
import ext.lib.sql.context.SqlContext;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class SqlStatement
extends BcLoggableObject
implements Statement {
    private SqlConnection dbCon;
    private Statement stmt;
    private SqlContext sqlContext;
    private long stStartTime;
    private long stEndTime;
    private long queryStartTime;
    private long timeout;
    private long timeoutTime;
    private String sqlOrign;
    private String sqlNew;
    private SqlResultSet resultSet;
    private long responseLogTime;

    public SqlStatement(SqlConnection dbCon, Statement stmt, SqlContext sqlContext) {
        this.dbCon = dbCon;
        this.stmt = stmt;
        this.sqlContext = sqlContext;
        this.stStartTime = System.currentTimeMillis();
    }

    public SqlContext getSqlContext() {
        return this.sqlContext;
    }

    public Statement getStatement() {
        return this.stmt;
    }

    public String getSql() {
        return this.sqlNew;
    }

    public long getStartTime() {
        return this.stStartTime;
    }

    public long getEndTime() {
        return this.stEndTime;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public long getTimeoutTime() {
        return this.timeoutTime;
    }

    public void setTimeoutTime(long timeoutTime) {
        this.timeoutTime = timeoutTime;
    }

    public long getResponseLogTime() {
        return this.responseLogTime;
    }

    public void setResponseLogTime(long responseLogTime) {
        this.responseLogTime = responseLogTime;
    }

    protected String beforeProcess(String sqlOrign) throws SQLException {
        if (SqlConstants.getDebug()) {
            this.getLogger().info("sqlOrign=" + sqlOrign);
        }
        if (this.queryStartTime > 0L) {
            throw new SQLException("Statement is processing.");
        }
        this.queryStartTime = System.currentTimeMillis();
        this.timeoutTime = 0L;
        this.sqlOrign = sqlOrign;
        this.sqlNew = this.convertSql(sqlOrign);
        if (this.timeout > 0L) {
            try {
                SqlStatementTimeoutMonitor.getInstance().addStatement(this);
            }
            catch (Exception ex) {
                throw new SQLException(ex.getMessage());
            }
        }
        return this.sqlNew;
    }

    protected void afterProcess() throws SQLException {
        this.queryStartTime = 0L;
        this.timeoutTime = 0L;
        if (this.timeout > 0L) {
            try {
                SqlStatementTimeoutMonitor.getInstance().removeStatement(this);
            }
            catch (Exception ex) {
                throw new SQLException(ex.getMessage());
            }
        }
    }

    @Override
    public SqlResultSet executeQuery(String sql) throws SQLException {
        this.beforeProcess(sql);
        try {
            long startTimeMillis = System.currentTimeMillis();
            ResultSet rs1 = this.stmt.executeQuery(sql);
            SqlResultSet rs2 = this.setResultSet(rs1, startTimeMillis);
            this.elapsedTimeLog(rs2);
            SqlResultSet sqlResultSet = rs2;
            return sqlResultSet;
        }
        catch (SQLException ex) {
            SQLException ex2 = this.statementTimeoutCheck(ex, sql);
            throw ex2;
        }
        finally {
            this.afterProcess();
        }
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.beforeProcess(sql);
        try {
            int n = this.stmt.executeUpdate(sql);
            return n;
        }
        catch (SQLException ex) {
            SQLException ex2 = this.statementTimeoutCheck(ex, sql);
            throw ex2;
        }
        finally {
            this.afterProcess();
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.stmt.close();
            this.stEndTime = System.currentTimeMillis();
            this.dbCon.removeStatement(this);
        }
        finally {
            try {
                SqlStatementTimeoutMonitor.getInstance().removeStatement(this);
            }
            catch (Exception ex) {
                throw new SQLException(ex.getMessage());
            }
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.stmt.getMaxFieldSize();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.stmt.setMaxFieldSize(max);
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.stmt.getMaxRows();
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.stmt.setMaxRows(max);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.stmt.setEscapeProcessing(enable);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.stmt.getQueryTimeout();
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.stmt.setQueryTimeout(seconds);
    }

    @Override
    public void cancel() throws SQLException {
        this.stmt.cancel();
        this.afterProcess();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.stmt.getWarnings();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.stmt.clearWarnings();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.stmt.setCursorName(name);
    }

    @Override
    public boolean execute(String sqlOrign) throws SQLException {
        String sqlNew = this.beforeProcess(sqlOrign);
        boolean isResultSet = false;
        try {
            try {
                long startTimeMillis = System.currentTimeMillis();
                isResultSet = this.stmt.execute(sqlNew);
                if (isResultSet) {
                    ResultSet rs1 = this.stmt.getResultSet();
                    SqlResultSet rs2 = this.setResultSet(rs1, this.queryStartTime);
                    this.elapsedTimeLog(rs2);
                }
            }
            catch (SQLException ex) {
                this.getLogger().error("sqlNew=" + sqlNew);
                if (this.timeoutTime > 0L) {
                    throw new SqlStatementTimeoutException(this.timeout, this.queryStartTime, this.timeoutTime);
                }
                throw ex;
            }
        }
        finally {
            this.afterProcess();
        }
        return isResultSet;
    }

    public boolean execute(CharSequence sqlOrign) throws SQLException {
        return this.execute(sqlOrign.toString());
    }

    @Override
    public SqlResultSet getResultSet() throws SQLException {
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.stmt.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.stmt.getMoreResults();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.stmt.setFetchDirection(direction);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.stmt.getFetchDirection();
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.stmt.setFetchSize(rows);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.stmt.getFetchSize();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.stmt.getResultSetConcurrency();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.stmt.getResultSetType();
    }

    @Override
    public void addBatch(String query) throws SQLException {
        this.stmt.addBatch(this.convertSql(query));
    }

    @Override
    public void clearBatch() throws SQLException {
        this.stmt.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.stmt.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.dbCon;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.stmt.getMoreResults(current);
    }

    @Override
    public SqlResultSet getGeneratedKeys() throws SQLException {
        SqlResultSet rs = this.sqlContext.convToSqlResultSet(this.stmt.getGeneratedKeys());
        return rs;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.beforeProcess(sql);
        return this.stmt.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.beforeProcess(sql);
        return this.stmt.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.beforeProcess(sql);
        return this.stmt.executeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.beforeProcess(sql);
        return this.stmt.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.beforeProcess(sql);
        return this.stmt.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.beforeProcess(sql);
        return this.stmt.execute(sql, columnNames);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.stmt.getResultSetHoldability();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.stmt.isClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.stmt.isPoolable();
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.stmt.setPoolable(poolable);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.stmt.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.stmt.unwrap(iface);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.stmt.closeOnCompletion();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.stmt.isCloseOnCompletion();
    }

    private SqlResultSet setResultSet(ResultSet rs1, long queryStartTime) throws SQLException {
        SqlResultSet rs2 = this.sqlContext.convToSqlResultSet(rs1);
        rs2.startTime = queryStartTime;
        rs2.endTime = System.currentTimeMillis();
        this.resultSet = rs2;
        return rs2;
    }

    private void elapsedTimeLog(SqlResultSet rs) throws SQLException {
        if (this.responseLogTime <= 0L) {
            return;
        }
        long elapsedTime = rs.endTime - rs.startTime;
        if (elapsedTime >= this.responseLogTime) {
            this.getLogger().info("\u6240\u8981\u6642\u9593\uff08\u30df\u30ea\u79d2\uff09=" + elapsedTime + " sql=\n" + this.sqlNew);
        }
    }

    protected SQLException statementTimeoutCheck(SQLException ex1, String sql) throws SQLException {
        this.getLogger().error("error sql=" + sql);
        SQLException ex2 = ex1;
        if (this.timeoutTime > 0L) {
            ex2 = new SqlStatementTimeoutException(this.timeout, this.getStartTime(), this.timeoutTime);
        }
        return ex2;
    }

    protected String convertSql(String sql) throws SQLException {
        return sql;
    }
}

