/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.poi;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLoggableObject;
import ext.base.mmd.MmdDefaultRenderingConverter;
import ext.base.mmd.MmdField;
import ext.base.mmd.MmdRenderingConverter;
import ext.base.reflect.BcReflectUtil;
import ext.lib.poi.PoiConstants;
import ext.lib.poi.PoiExportCondition;
import ext.lib.poi.PoiExportEventHandler;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PoiAbstractCsvWriter
extends BcLoggableObject {
    protected PoiExportCondition exportCondition;
    protected Locale locale;
    protected List<PoiExportEventHandler> exportEventHandlerList = new ArrayList<PoiExportEventHandler>();

    public PoiAbstractCsvWriter() throws Exception {
        this.setCondition(new PoiExportCondition());
    }

    public PoiExportCondition getCondition() throws Exception {
        return this.exportCondition;
    }

    public void setCondition(PoiExportCondition exportCondition) throws Exception {
        this.exportCondition = exportCondition;
    }

    public Locale getLocale() throws Exception {
        if (this.locale != null) {
            return this.locale;
        }
        this.locale = this.exportCondition.locale != null ? this.exportCondition.locale : Locale.getDefault();
        return this.locale;
    }

    public String escapEncode(String text) throws Exception {
        Pattern pattern = Pattern.compile(BcStringUtil.DOUBLE_QUOTATION_STR);
        Matcher matcher = pattern.matcher(text);
        return matcher.replaceAll(String.valueOf(BcStringUtil.DOUBLE_QUOTATION_STR) + BcStringUtil.DOUBLE_QUOTATION_STR);
    }

    public boolean hasSpecialCharacter(String text) throws Exception {
        int i = 0;
        while (i < PoiConstants.ESCAPE_SEQENCE_CHARS.length) {
            char aChar = PoiConstants.ESCAPE_SEQENCE_CHARS[i];
            if (text.indexOf(aChar) >= 0) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void output(Writer writer, CharSequence charSequence) throws Exception {
        if (BcStringUtil.isEmpty(charSequence)) {
            return;
        }
        writer.write(charSequence.toString());
    }

    public void outputValue(Writer writer, Object value, MmdField mmdField) throws Exception {
        String textValue = null;
        if (value != null) {
            if (this.exportCondition.codeMapEnabled) {
                MmdRenderingConverter renderingConverter = MmdDefaultRenderingConverter.getInstance();
                if (mmdField != null && !BcStringUtil.isEmpty(mmdField.renderingConverterClassName)) {
                    Class<?> clazz = Class.forName(mmdField.renderingConverterClassName);
                    renderingConverter = (MmdRenderingConverter)BcReflectUtil.getInstance(clazz);
                }
                textValue = renderingConverter.toString(mmdField, value);
            } else {
                textValue = BcStringUtil.toString(value);
            }
        }
        boolean quotationMarkEnabled = false;
        if (this.exportCondition.quotationMarkPolicy == PoiConstants.QuotationMarkPolicy.necessary) {
            if (!BcStringUtil.isEmpty(textValue)) {
                quotationMarkEnabled = this.hasSpecialCharacter(textValue);
            }
        } else if (this.exportCondition.quotationMarkPolicy == PoiConstants.QuotationMarkPolicy.always) {
            quotationMarkEnabled = true;
        } else {
            String msg = "Not Spported Quotation Mark Policy.'" + (Object)((Object)this.exportCondition.quotationMarkPolicy) + "'";
            throw new Exception(msg);
        }
        if (quotationMarkEnabled) {
            this.output(writer, PoiConstants.quotationMark);
        }
        if (!BcStringUtil.isEmpty(textValue)) {
            this.output(writer, this.escapEncode(textValue));
        }
        if (quotationMarkEnabled) {
            this.output(writer, PoiConstants.quotationMark);
        }
    }

    public void outputCollection(Writer writer, Collection<Object> collection) throws Exception {
        Object[] objects = collection.toArray();
        int i = 0;
        while (i < objects.length) {
            this.outputValue(writer, objects[i], null);
            this.output(writer, this.exportCondition.fieldSeparator);
            ++i;
        }
    }

    public void addExportEventHandler(PoiExportEventHandler exportEventHandler) {
        this.exportEventHandlerList.add(exportEventHandler);
    }

    public boolean removeExportEventHandler(PoiExportEventHandler exportEventHandler) {
        return this.exportEventHandlerList.remove(exportEventHandler);
    }
}

