/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.pdf.object;

import ext.lib.pdf.PdfProducer;
import java.io.ByteArrayOutputStream;
import java.io.Serializable;

public abstract class PdfObject
implements Serializable {
    private static final long serialVersionUID = 2056106177726339588L;
    protected int objectId;
    protected PdfProducer pdfProducer;

    public int getObjectId() {
        return this.objectId;
    }

    public void setObjectId(int objectId) {
        this.objectId = objectId;
    }

    public byte[] getObjectHeader() {
        StringBuilder buf = new StringBuilder();
        buf.append(Integer.toString(this.getObjectId()));
        buf.append(" 0 obj\r\n");
        return buf.toString().getBytes();
    }

    public byte[] getObjectByteArray() throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(this.getObjectHeader());
        byteArrayOutputStream.write(this.getObjectDetail());
        byteArrayOutputStream.write("endobj\r\n".getBytes());
        return byteArrayOutputStream.toByteArray();
    }

    protected PdfProducer getOwner() {
        return this.pdfProducer;
    }

    public void setOwner(PdfProducer pdfProducer) {
        pdfProducer.registerObject(this);
        this.pdfProducer = pdfProducer;
    }

    protected abstract byte[] getObjectDetail() throws Exception;
}

