/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.pdf;

import ext.base.log.BcLogUtil;
import ext.lib.pdf.PdfHeader;
import ext.lib.pdf.PdfObjectList;
import ext.lib.pdf.PdfOutlineTree;
import ext.lib.pdf.PdfTrailer;
import ext.lib.pdf.Xref;
import ext.lib.pdf.object.PdfCatalog;
import ext.lib.pdf.object.PdfContents;
import ext.lib.pdf.object.PdfFont;
import ext.lib.pdf.object.PdfInformation;
import ext.lib.pdf.object.PdfObject;
import ext.lib.pdf.object.PdfPage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PdfProducer {
    protected PdfObjectList pdfObjectList = new PdfObjectList();
    protected PdfObjectList pdfFontList = new PdfObjectList();
    protected int objectId;
    protected int fontId;
    protected PdfCatalog catalog = new PdfCatalog();
    protected PdfInformation info = new PdfInformation();
    protected OutputStream os;
    protected PdfPage currentPage;
    protected PdfOutlineTree oslineTree;
    protected Xref xref = new Xref();
    protected boolean isInternalStream;

    public PdfProducer() {
        this.catalog.setOwner(this);
        this.info.setOwner(this);
    }

    protected PdfObjectList getFonts() {
        return this.pdfFontList;
    }

    public String getFontArrayString() {
        StringBuilder sb = new StringBuilder("");
        int i = 0;
        while (i < this.pdfFontList.size()) {
            sb.append("/F" + new Integer(i).toString() + " " + new Integer(this.pdfFontList.get(i).getObjectId()).toString() + " 0 R\r\n");
            ++i;
        }
        return sb.toString();
    }

    public void registerObject(PdfObject pdfObject) {
        ++this.objectId;
        pdfObject.setObjectId(this.objectId);
        this.pdfObjectList.add(pdfObject);
        this.xref.addEntry(pdfObject);
    }

    public void registerFontx(PdfFont value) {
        value.setName(this.fontId);
        this.pdfFontList.add(value);
        ++this.fontId;
        value.setOwner(this);
    }

    public PdfFont getFont(String fontName) {
        PdfFont font = null;
        int i = 0;
        while (i < this.pdfFontList.size()) {
            font = (PdfFont)this.pdfFontList.get(i);
            if (font.getClass().getName().equals(fontName)) break;
            font = null;
            ++i;
        }
        if (font == null) {
            try {
                font = (PdfFont)Class.forName(fontName).newInstance();
                this.registerFontx(font);
            }
            catch (Exception ex) {
                System.err.println("not found font '" + fontName + "'\n");
                BcLogUtil.error(ex);
            }
        }
        return font;
    }

    public int getObjectCount() {
        return this.pdfObjectList.size();
    }

    public PdfCatalog getCatalog() {
        return this.catalog;
    }

    protected PdfInformation getInfo() {
        return this.info;
    }

    protected Xref getXref() {
        return this.xref;
    }

    public void beginDoc(OutputStream os) {
        this.os = os;
        this.newPage();
    }

    public void beginDoc(File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        this.beginDoc(os);
        this.isInternalStream = true;
    }

    public int endDoc() throws IOException {
        int osln = this.writeObjects();
        this.currentPage = null;
        if (this.isInternalStream) {
            this.os.close();
            this.isInternalStream = false;
        }
        this.os = null;
        return osln;
    }

    public PdfPage newPage() {
        this.currentPage = new PdfPage();
        this.getCatalog().getPages().addPage(this.currentPage);
        return this.currentPage;
    }

    public PdfPage getCurrentPage() {
        return this.currentPage;
    }

    public PdfContents getContents() {
        return this.currentPage.getContents();
    }

    public int getPageWidth() {
        return this.catalog.getPages().getWidth();
    }

    public int getPageHeight() {
        return this.catalog.getPages().getHeight();
    }

    public void setPageWidth(int width) {
        this.catalog.getPages().setWidth(width);
    }

    public void setPageHeight(int height) {
        this.catalog.getPages().setHeight(height);
    }

    public void setCreator(String creater) {
        this.getInfo().setCreator(creater);
    }

    public void setAuthor(String creater) {
        this.getInfo().setAuthor(creater);
    }

    public void setTitle(String creater) {
        this.getInfo().setTitle(creater);
    }

    public PdfOutlineTree getOutlines() {
        if (this.oslineTree == null) {
            this.oslineTree = new PdfOutlineTree(this);
        }
        return this.oslineTree;
    }

    public boolean useOutline() {
        return this.oslineTree != null;
    }

    protected int writeObjects() {
        int osln = 0;
        try {
            PdfHeader pdfHeader = new PdfHeader();
            byte[] objBytes = pdfHeader.getObjectByteArray();
            this.os.write(objBytes);
            osln = objBytes.length;
            int i = 0;
            while (i < this.pdfObjectList.size()) {
                PdfObject pdfObject = this.pdfObjectList.get(i);
                this.xref.getEntry(pdfObject.getObjectId()).setByteOffset(osln);
                objBytes = pdfObject.getObjectByteArray();
                this.os.write(objBytes);
                int objLength = objBytes.length;
                osln += objLength;
                ++i;
            }
            this.xref.setPos(osln);
            this.os.write(this.xref.getObjectString().getBytes());
            int objLength = this.xref.getObjectString().getBytes().length;
            osln += objLength;
            PdfTrailer pdfTrailer = new PdfTrailer();
            pdfTrailer.setOwner(this);
            this.os.write(pdfTrailer.getObjectString().getBytes());
            objLength = pdfTrailer.getObjectString().getBytes().length;
            osln += objLength;
            this.os.flush();
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
        return osln;
    }
}

