/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.fx.control;

import ext.base.core.BcStringUtil;
import ext.lib.fx.skin.FxCssUtil;
import ext.lib.fx.util.FxUtil;
import ext.lib.swg.SwgUtil;
import java.util.regex.Pattern;
import javafx.beans.Observable;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Scene;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextInputControl;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class FxTextArea
extends TextArea {
    private IntegerProperty maxLength;
    private ObjectProperty<Pattern> patternProperty;
    private boolean doTrim = true;
    private boolean isFullWidth;
    private boolean textChanged;
    private boolean isEditing;
    protected String firstStyle;
    protected boolean styleChangeFlag;
    protected EventHandler<KeyEvent> keyEventHandler = new EventHandler<KeyEvent>(){

        public void handle(KeyEvent ev) {
            try {
                FxTextArea.this.keyEvent(ev);
            }
            catch (Exception ex) {
                FxTextArea.this.handleException(ex);
            }
        }
    };
    protected EventHandler<MouseEvent> mouseEventHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent ev) {
            try {
                FxTextArea.this.mouseEvent(ev);
            }
            catch (Exception ex) {
                FxTextArea.this.handleException(ex);
            }
        }
    };
    private ChangeListener<Scene> sceneChangeListener = new ChangeListener<Scene>(){

        public void changed(ObservableValue observable, Scene oldScene, Scene newScene) {
            try {
                FxTextArea.this.sceneChanged(observable, oldScene, newScene);
            }
            catch (Exception ex) {
                FxTextArea.this.handleException(ex);
            }
        }
    };
    private ChangeListener<Window> windowChangeListener = new ChangeListener<Window>(){

        public void changed(ObservableValue observable, Window oldWindow, Window newWindow) {
            try {
                FxTextArea.this.windowChanged((Observable)observable, oldWindow, newWindow);
            }
            catch (Exception ex) {
                FxTextArea.this.handleException(ex);
            }
        }
    };
    private EventHandler<WindowEvent> windowShowntEventHandler = new EventHandler<WindowEvent>(){

        public void handle(WindowEvent ev) {
            try {
                FxTextArea.this.windowEvent(ev);
            }
            catch (Exception ex) {
                FxTextArea.this.handleException(ex);
            }
        }
    };
    private String contentStyle;

    public void setMaxLength(int value) {
        this.maxLengthProperty().set(value);
    }

    public int getMaxLength() {
        return this.maxLengthProperty().get();
    }

    public IntegerProperty maxLengthProperty() {
        if (this.maxLength == null) {
            this.maxLength = new SimpleIntegerProperty((Object)this, "Maximum Length", -1);
        }
        return this.maxLength;
    }

    public void setPattern(Pattern value) {
        this.patternPropertyProperty().set((Object)value);
    }

    public Pattern getPattern() {
        return (Pattern)this.patternPropertyProperty().get();
    }

    public ObjectProperty<Pattern> patternPropertyProperty() {
        if (this.patternProperty == null) {
            this.patternProperty = new SimpleObjectProperty((Object)this, "Pattern");
        }
        return this.patternProperty;
    }

    public boolean doTrim() {
        return this.doTrim;
    }

    public void setDoTrim(boolean doTrim) {
        this.doTrim = doTrim;
    }

    public boolean isFullWidth() {
        return this.isFullWidth;
    }

    public void setFullWidth(boolean isFullWidth) {
        this.isFullWidth = isFullWidth;
    }

    public String getContentStyle() {
        return this.contentStyle;
    }

    public void setContentStyle(String contentStyle) {
        this.contentStyle = contentStyle;
    }

    public FxTextArea() {
        this.init();
    }

    protected void init() {
        this.setOnKeyPressed(this.keyEventHandler);
        this.setOnKeyReleased(this.keyEventHandler);
        this.setOnKeyTyped(this.keyEventHandler);
        this.setOnMouseClicked(this.mouseEventHandler);
        this.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                FxTextArea.this.textChanged = true;
                if (!FxTextArea.this.isEditing) {
                    try {
                        FxTextArea.this.textEdited();
                        FxTextArea.this.textChanged = false;
                    }
                    catch (Exception ex) {
                        FxTextArea.this.handleException(ex);
                    }
                }
            }
        });
        this.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                try {
                    if (newValue.booleanValue()) {
                        FxTextArea.this.focusIn();
                    } else {
                        FxTextArea.this.focusOut();
                    }
                }
                catch (Exception ex) {
                    FxTextArea.this.handleException(ex);
                }
            }
        });
        this.prefColumnCountProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                try {
                    FxTextArea.this.prefColumnCountChanged(oldValue, newValue);
                }
                catch (Exception ex) {
                    FxTextArea.this.handleException(ex);
                }
            }
        });
        this.prefRowCountProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                try {
                    FxTextArea.this.prefRowCountChanged(oldValue, newValue);
                }
                catch (Exception ex) {
                    FxTextArea.this.handleException(ex);
                }
            }
        });
        this.styleProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                try {
                    FxTextArea.this.styleChanged(oldValue, newValue);
                }
                catch (Exception ex) {
                    FxTextArea.this.handleException(ex);
                }
            }
        });
        this.sceneProperty().addListener(this.sceneChangeListener);
    }

    public void replaceText(int start, int end, String text) {
        if (BcStringUtil.isEmpty(text)) {
            super.replaceText(start, end, text);
        } else if (this.getMaxLength() > 0) {
            if (this.getLength() < this.getMaxLength() && this.isPatternMatchiFind(text)) {
                super.replaceText(start, end, text);
            }
        } else if (this.isPatternMatchiFind(text)) {
            super.replaceText(start, end, text);
        }
    }

    public void replaceSelection(String text) {
        if (BcStringUtil.isEmpty(text)) {
            super.replaceSelection(text);
        } else if (this.getMaxLength() > 0 && this.getLength() < this.getMaxLength()) {
            if (this.isPatternMatchiFind(text)) {
                super.replaceSelection(text);
            }
        } else {
            super.replaceSelection(text);
        }
    }

    protected void keyEvent(KeyEvent ev) throws Exception {
        if (ev.getEventType() == KeyEvent.KEY_PRESSED) {
            if (KeyCode.ENTER.equals((Object)ev.getCode())) {
                Event.fireEvent((EventTarget)this, (Event)new KeyEvent(KeyEvent.KEY_PRESSED, KeyEvent.CHAR_UNDEFINED, "", KeyCode.TAB, false, false, false, false));
            }
        } else if (ev.getEventType() == KeyEvent.KEY_TYPED) {
            this.isEditing = true;
        }
    }

    public void focusIn() throws Exception {
    }

    public void focusOut() throws Exception {
        if (this.textChanged) {
            this.textEdited();
        }
        this.textChanged = false;
        this.isEditing = false;
    }

    public void textEdited() throws Exception {
        if (this.doTrim()) {
            this.setText(BcStringUtil.trim(this.getText(), true));
        }
    }

    protected void mouseEvent(MouseEvent ev) throws Exception {
    }

    public boolean isPatternMatchiFind(String text) {
        if (this.getPattern() != null) {
            return this.getPattern().matcher(text).find();
        }
        return true;
    }

    public void prefColumnCountChanged(Number oldValue, Number newValue) throws Exception {
        FxUtil.setPrefSize_TextArea(this);
    }

    public void prefRowCountChanged(Number oldValue, Number newValue) throws Exception {
        FxUtil.setPrefSize_TextArea(this);
    }

    public void styleChanged(String oldValue, String newValue) throws Exception {
        if (BcStringUtil.isEmpty(this.firstStyle)) {
            this.firstStyle = newValue;
        }
        if (this.styleChangeFlag) {
            this.styleChangeFlag = false;
            return;
        }
        if (!this.isEditable()) {
            this.styleChangeFlag = true;
            FxCssUtil.setStyle_form_01((TextInputControl)this);
        }
        FxUtil.setPrefSize_TextArea(this);
    }

    public void sceneChanged(ObservableValue observable, Scene oldScene, Scene newScene) {
        if (oldScene != null) {
            oldScene.windowProperty().removeListener(this.windowChangeListener);
        }
        if (newScene != null) {
            newScene.windowProperty().addListener(this.windowChangeListener);
        }
    }

    public void windowChanged(Observable observable, Window oldWindow, Window newWindow) {
        if (oldWindow != null) {
            oldWindow.removeEventHandler(WindowEvent.ANY, this.windowShowntEventHandler);
        }
        if (newWindow != null) {
            newWindow.addEventFilter(WindowEvent.ANY, this.windowShowntEventHandler);
        }
    }

    protected void windowEvent(WindowEvent ev) throws Exception {
        if (ev.getEventType() == WindowEvent.WINDOW_SHOWN) {
            Region content = (Region)this.lookup(".content");
            this.setupContent(content);
        }
    }

    protected void setupContent(Region content) throws Exception {
        content.setStyle(this.getContentStyle());
    }

    protected void handleException(Throwable throwable) {
        SwgUtil.getExceptionHandler().handleException(throwable, (Object)this);
    }
}

