/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.fx.control;

import ext.base.core.BcStringUtil;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class FxComboBox<T>
extends ComboBox<T> {
    protected StringConverter<T> stringConverter = new StringConverter<T>(){

        public String toString(Object item) {
            return FxComboBox.this.toString(item);
        }

        public T fromString(String value) {
            return FxComboBox.this.fromString(value);
        }
    };
    public IntegerProperty columnCount = new SimpleIntegerProperty();

    public FxComboBox() throws Exception {
        this.init();
    }

    public FxComboBox(ObservableList<T> items) throws Exception {
        super(items);
        this.init();
    }

    protected void init() throws Exception {
        this.setConverter(this.stringConverter);
        this.valueProperty().addListener(new ChangeListener<T>(){

            public void changed(ObservableValue ov, T oldValue, T newValue) {
                FxComboBox.this.valueChanged(ov, oldValue, newValue);
            }
        });
        Callback<ListView<T>, ListCell<T>> cellFactory = this.createCellFactory();
        this.setCellFactory(cellFactory);
    }

    protected void valueChanged(ObservableValue ov, T oldValue, T newValue) {
    }

    public String toString(Object item) {
        return BcStringUtil.toString(item);
    }

    protected T fromString(String value) {
        return (T)value;
    }

    protected Callback<ListView<T>, ListCell<T>> createCellFactory() {
        InnerCellFactory cellFactory = new InnerCellFactory();
        return cellFactory;
    }

    class InnerCellFactory<T>
    implements Callback<ListView<T>, ListCell<T>> {
        InnerCellFactory() {
        }

        public ListCell<T> call(ListView<T> listView) {
            return new InnerListCell();
        }
    }

    class InnerListCell<T>
    extends ListCell<T> {
        protected void updateItem(T item, boolean isEmpty) {
            super.updateItem(item, isEmpty);
            if (item == null || isEmpty) {
                this.setGraphic(null);
            } else {
                this.setText(item.toString());
            }
        }
    }
}

