/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.comm.swg;

import ext.lib.comm.CommSerialConstants;
import ext.lib.comm.CommSerialParameters;
import ext.lib.comm.common.CommWords;
import ext.lib.swg.SwgComboBox;
import ext.lib.swg.SwgPanel;
import ext.lib.swg.SwgUtil;
import gnu.io.CommPortIdentifier;
import java.util.Enumeration;
import javax.swing.JLabel;

public class CommSerialPortPanel
extends SwgPanel {
    private static final long serialVersionUID = -7670391020521197877L;
    protected SwgComboBox portNameCombo = new SwgComboBox();
    protected SwgComboBox baudCombo = new SwgComboBox();
    protected SwgComboBox dataBitCombo = new SwgComboBox();
    protected SwgComboBox stopBitCombo = new SwgComboBox();
    protected SwgComboBox parityCombo = new SwgComboBox();
    protected SwgComboBox flowInCombo = new SwgComboBox();
    protected SwgComboBox flowOutCombo = new SwgComboBox();

    public CommSerialPortPanel() throws Exception {
        this.setComponent();
    }

    protected void setComponent() {
        int rowHeight = 20;
        int rowGap = 4;
        int labelWidth = 100;
        int x1 = 4;
        int x2 = x1 + labelWidth + 8;
        int lY = 16;
        JLabel portNameLabel = new JLabel(CommWords.getInstance().Port_Name, 4);
        this.listPortChoices();
        this.portNameCombo.setEditable(true);
        SwgUtil.setLocation(this, portNameLabel, (double)x1, (double)lY, (double)labelWidth, (double)rowHeight);
        SwgUtil.setLocation(this, this.portNameCombo, (double)x2, (double)lY, (double)labelWidth, (double)rowHeight);
        lY += rowHeight + rowGap;
        JLabel baudLabel = new JLabel(CommWords.getInstance().Baud_Rate, 4);
        int i = 0;
        while (i < CommSerialConstants.baudRates.length) {
            this.baudCombo.addItem(Integer.toString(CommSerialConstants.baudRates[i]));
            ++i;
        }
        SwgUtil.setLocation(this, baudLabel, (double)x1, (double)lY, (double)labelWidth, (double)rowHeight);
        SwgUtil.setLocation(this, this.baudCombo, (double)x2, (double)lY, (double)labelWidth, (double)rowHeight);
        lY += rowHeight + rowGap;
        JLabel databitsLabel = new JLabel(CommWords.getInstance().Data_Bits, 4);
        int i2 = 0;
        while (i2 < CommSerialConstants.dataBits.length) {
            this.dataBitCombo.addItem(Integer.toString(CommSerialConstants.dataBits[i2]));
            ++i2;
        }
        SwgUtil.setLocation(this, databitsLabel, (double)x1, (double)lY, (double)labelWidth, (double)rowHeight);
        SwgUtil.setLocation(this, this.dataBitCombo, (double)x2, (double)lY, (double)labelWidth, (double)rowHeight);
        lY += rowHeight + rowGap;
        JLabel stopbitsLabel = new JLabel(CommWords.getInstance().Stop_Bits, 4);
        int i3 = 0;
        while (i3 < CommSerialConstants.stopBits.length) {
            this.stopBitCombo.addItem(Float.toString(CommSerialConstants.stopBits[i3]));
            ++i3;
        }
        SwgUtil.setLocation(this, stopbitsLabel, (double)x1, (double)lY, (double)labelWidth, (double)rowHeight);
        SwgUtil.setLocation(this, this.stopBitCombo, (double)x2, (double)lY, (double)labelWidth, (double)rowHeight);
        lY += rowHeight + rowGap;
        JLabel parityLabel = new JLabel(CommWords.getInstance().Parity, 4);
        int i4 = 0;
        while (i4 < CommSerialConstants.paritys.length) {
            this.parityCombo.addItem(CommSerialConstants.paritys[i4]);
            ++i4;
        }
        SwgUtil.setLocation(this, parityLabel, (double)x1, (double)lY, (double)labelWidth, (double)rowHeight);
        SwgUtil.setLocation(this, this.parityCombo, (double)x2, (double)lY, (double)labelWidth, (double)rowHeight);
        lY += rowHeight + rowGap;
        JLabel flowControlInLabel = new JLabel(CommWords.getInstance().Flow_Control_In, 4);
        int i5 = 0;
        while (i5 < CommSerialConstants.flowIns.length) {
            this.flowInCombo.addItem(CommSerialConstants.flowIns[i5]);
            ++i5;
        }
        SwgUtil.setLocation(this, flowControlInLabel, (double)x1, (double)lY, (double)labelWidth, (double)rowHeight);
        SwgUtil.setLocation(this, this.flowInCombo, (double)x2, (double)lY, (double)labelWidth, (double)rowHeight);
        lY += rowHeight + rowGap;
        JLabel flowControlOutLabel = new JLabel(CommWords.getInstance().Flow_Control_Out, 4);
        int i6 = 0;
        while (i6 < CommSerialConstants.flowOuts.length) {
            this.flowOutCombo.addItem(CommSerialConstants.flowOuts[i6]);
            ++i6;
        }
        SwgUtil.setLocation(this, flowControlOutLabel, (double)x1, (double)lY, (double)labelWidth, (double)rowHeight);
        SwgUtil.setLocation(this, this.flowOutCombo, (double)x2, (double)lY, (double)labelWidth, (double)rowHeight);
        lY += rowHeight + rowGap;
    }

    protected void listPortChoices() {
        CommPortIdentifier portId = null;
        Enumeration en = CommPortIdentifier.getPortIdentifiers();
        while (en.hasMoreElements()) {
            portId = (CommPortIdentifier)en.nextElement();
            if (portId.getPortType() != 1) continue;
            this.portNameCombo.addItem(portId.getName());
        }
    }

    public void setSerialParameters(CommSerialParameters serialParameters) {
        this.portNameCombo.setSelectedItem(serialParameters.getPortName());
        this.baudCombo.setSelectedItem(Integer.toString(serialParameters.getBaudRate()));
        this.dataBitCombo.setSelectedItem(serialParameters.getDataBitsString());
        this.stopBitCombo.setSelectedItem(serialParameters.getStopBitsString());
        this.parityCombo.setSelectedItem(serialParameters.getParityString());
        this.flowInCombo.setSelectedItem(serialParameters.getFlowControlInString());
        this.flowOutCombo.setSelectedItem(serialParameters.getFlowControlOutString());
    }

    public CommSerialParameters getSerialParameters(CommSerialParameters serialParameters) throws Exception {
        if (serialParameters == null) {
            serialParameters = new CommSerialParameters();
        }
        serialParameters.setPortName((String)this.portNameCombo.getSelectedItem());
        serialParameters.setBaudRate((String)this.baudCombo.getSelectedItem());
        serialParameters.setDataBits((String)this.dataBitCombo.getSelectedItem());
        serialParameters.setStopBits((String)this.stopBitCombo.getSelectedItem());
        serialParameters.setParity((String)this.parityCombo.getSelectedItem());
        serialParameters.setFlowControlIn((String)this.flowInCombo.getSelectedItem());
        serialParameters.setFlowControlOut((String)this.flowOutCombo.getSelectedItem());
        return serialParameters;
    }
}

