/*
 * Decompiled with CFR 0.152.
 */
package ext.lib.barcode.renderer;

import ext.lib.barcode.renderer.DcfAbstractBarcodeRenderer;
import ext.lib.doc.util.DcfDocumentUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import nlc.lib.barcode.DcfNw7Context;

public class DcfNw7Renderer
extends DcfAbstractBarcodeRenderer {
    protected DcfNw7Context nw7Context;

    public DcfNw7Renderer(DcfNw7Context nw7Context) {
        this.nw7Context = nw7Context;
    }

    public String getPattern(char aChar) throws Exception {
        String pattern = null;
        switch (aChar) {
            case '0': {
                pattern = "0000011";
                break;
            }
            case '1': {
                pattern = "0000110";
                break;
            }
            case '2': {
                pattern = "0001001";
                break;
            }
            case '3': {
                pattern = "1100000";
                break;
            }
            case '4': {
                pattern = "0010010";
                break;
            }
            case '5': {
                pattern = "1000010";
                break;
            }
            case '6': {
                pattern = "0100001";
                break;
            }
            case '7': {
                pattern = "0100100";
                break;
            }
            case '8': {
                pattern = "0110000";
                break;
            }
            case '9': {
                pattern = "1001000";
                break;
            }
            case '-': {
                pattern = "0001100";
                break;
            }
            case '$': {
                pattern = "0011000";
                break;
            }
            case '/': {
                pattern = "1010001";
                break;
            }
            case ':': {
                pattern = "1000101";
                break;
            }
            case '+': {
                pattern = "0010101";
                break;
            }
            case '.': {
                pattern = "1010100";
                break;
            }
            case 'a': {
                pattern = "0011010";
                break;
            }
            case 'b': {
                pattern = "0101001";
                break;
            }
            case 'c': {
                pattern = "0001011";
                break;
            }
            case 'd': {
                pattern = "0001110";
                break;
            }
            default: {
                String msg = "\u6587\u5b57 '" + String.valueOf(aChar) + "' \u306fNW-7\u3067\u306f\u4f7f\u7528\u3067\u304d\u307e\u305b\u3093\u3002";
                throw new Exception(msg);
            }
        }
        return pattern;
    }

    @Override
    public double[] getSize(String value) throws Exception {
        double[] dim = this.drawBarcodeL2(null, 0.0, 0.0, value);
        return dim;
    }

    @Override
    public void drawBarcode(Graphics2D g2d, double bx, double by, String value) throws Exception {
        double[] dim = this.drawBarcodeL2(null, bx, by, value);
        this.drawBarcodeL2(g2d, bx, by, value);
    }

    protected double[] drawBarcodeL2(Graphics2D g2d, double bx, double by, String value) throws Exception {
        double narowBarWidth = DcfDocumentUtil.mmToPixel(this.nw7Context.narowBarWidth);
        double wideBarWidth = DcfDocumentUtil.mmToPixel(this.nw7Context.widwBarWidth);
        double barHeight = DcfDocumentUtil.mmToPixel(this.nw7Context.barHeight);
        Font font = new Font("Dialog", 0, this.nw7Context.fontSize);
        double strGap1 = 2.0;
        double strGap2 = this.nw7Context.fontSize + 2;
        double tmpX = bx;
        Rectangle2D.Double rectangle = new Rectangle2D.Double(tmpX, by, 0.0, 0.0);
        if (g2d != null) {
            g2d.setClip((int)((RectangularShape)rectangle).getX(), (int)((RectangularShape)rectangle).getY(), 1000, 1000);
            g2d.setFont(font);
            g2d.setColor(Color.black);
        }
        String barcodeData = this.nw7Context.createBarcodeData(value, this.nw7Context.startCode);
        int i = 0;
        while (i < barcodeData.length()) {
            char char_ = barcodeData.charAt(i);
            if (g2d != null) {
                g2d.drawString(Character.toString(char_), (float)(tmpX + strGap1), (float)(by + barHeight + strGap2));
            }
            String pattern = this.getPattern(char_);
            int j = 0;
            while (j < pattern.length()) {
                double barWidth = 0.0;
                int num = Integer.parseInt(pattern.substring(j, j + 1));
                barWidth = num == 0 ? narowBarWidth : wideBarWidth;
                if (g2d != null && j % 2 == 0) {
                    Rectangle2D.Double barRectangle = new Rectangle2D.Double(tmpX, by, barWidth, barHeight);
                    g2d.fill(barRectangle);
                }
                tmpX += barWidth;
                ++j;
            }
            tmpX += this.nw7Context.characterGap;
            ++i;
        }
        double[] dim = new double[]{tmpX, barHeight};
        return dim;
    }
}

