/*
 * Decompiled with CFR 0.152.
 */
package ext.base.util;

import ext.base.core.BcBooleanUtil;
import ext.base.core.BcLangUtil;
import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.base.io.BcStreamUtil;
import ext.base.log.BcLogUtil;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Calendar;
import java.util.Locale;

public class BcObjectConvertor {
    private BcObjectConvertor() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object objectConvert(Object value, Class toClass, String formatPattern, Locale locale) throws Exception {
        if (value == null) {
            if (!toClass.isPrimitive()) return null;
            return BcLangUtil.getDefaultValue(toClass);
        }
        Object newValue = null;
        Class<?> fromClass = value.getClass();
        if (fromClass.equals(toClass)) {
            return value;
        }
        if (java.util.Date.class.isAssignableFrom(fromClass)) {
            Calendar calendar = BcTimeUtil.createCalendar();
            calendar.setTime((java.util.Date)value);
            value = calendar;
            fromClass = value.getClass();
        }
        if (Boolean.class.isAssignableFrom(fromClass)) {
            if (!CharSequence.class.isAssignableFrom(toClass)) return value;
            return Boolean.toString((Boolean)value);
        }
        if (BigDecimal.class.isAssignableFrom(fromClass)) {
            if (!BigDecimal.class.isAssignableFrom(toClass)) return BcObjectConvertor.numberToObject((Number)value, toClass, formatPattern, locale);
            return value;
        }
        if (Number.class.isAssignableFrom(fromClass)) {
            return BcObjectConvertor.numberToObject((Number)value, toClass, formatPattern, locale);
        }
        if (CharSequence.class.isAssignableFrom(fromClass)) {
            return BcObjectConvertor.stringToObject(value.toString(), toClass, formatPattern, locale);
        }
        if (Calendar.class.isAssignableFrom(fromClass)) {
            return BcObjectConvertor.calendarToObject((Calendar)value, toClass, formatPattern, locale);
        }
        if (Blob.class.isAssignableFrom(fromClass)) {
            Blob blob = (Blob)value;
            if (!BcLangUtil.isByteArray(toClass)) throw new Exception(String.valueOf(fromClass.getName()) + " -> " + toClass.getName());
            byte[] bytes = BcStreamUtil.readWithClose(blob.getBinaryStream());
            return bytes;
        }
        if (Clob.class.isAssignableFrom(fromClass)) {
            Clob clob = (Clob)value;
            return clob.getSubString(1L, (int)clob.length());
        }
        if (!CharSequence.class.isAssignableFrom(toClass)) throw new Exception(String.valueOf(fromClass.getName()) + " -> " + toClass.getName());
        return BcObjectConvertor.stringToObject(value.toString(), toClass, formatPattern, locale);
    }

    public static Object objectConvert(Object srcObj, Class toClass) throws Exception {
        return BcObjectConvertor.objectConvert(srcObj, toClass, null, null);
    }

    public static Object numberToObject(Number number, Class toClass, String formatPattern, Locale locale) throws Exception {
        if (number == null) {
            if (toClass.isPrimitive()) {
                Class wrapperClass = BcLangUtil.toWrapperClass(toClass);
                return BcLangUtil.getDefaultValue(wrapperClass);
            }
            return null;
        }
        if (toClass.equals(Long.class) || toClass.equals(Long.TYPE)) {
            return number.longValue();
        }
        if (toClass.equals(Integer.class) || toClass.equals(Integer.TYPE)) {
            return number.intValue();
        }
        if (toClass.equals(Short.class) || toClass.equals(Short.TYPE)) {
            return number.shortValue();
        }
        if (toClass.equals(Byte.class) || toClass.equals(Byte.TYPE)) {
            return number.byteValue();
        }
        if (toClass.equals(Double.class) || toClass.equals(Double.TYPE)) {
            return number.doubleValue();
        }
        if (toClass.equals(Float.class) || toClass.equals(Float.TYPE)) {
            return Float.valueOf(number.floatValue());
        }
        if (toClass.equals(String.class)) {
            formatPattern = null;
            if (formatPattern != null) {
                DecimalFormat decimalFormat = new DecimalFormat(formatPattern);
                return decimalFormat.format(number);
            }
            if (locale != null) {
                NumberFormat numberFormat = NumberFormat.getInstance(locale);
                return numberFormat.format(number);
            }
            return number.toString();
        }
        if (toClass.equals(Boolean.class) || toClass.equals(Boolean.TYPE)) {
            return BcBooleanUtil.toBoolean(number.intValue());
        }
        throw new Exception("Can not convert." + Number.class.getName() + " -> " + toClass.getName());
    }

    public static Object stringToObject(String src, Class toClass, String formatPattern, Locale locale) throws Exception {
        if (BcStringUtil.isEmpty(src)) {
            if (toClass.isPrimitive()) {
                Class wrapperClass = BcLangUtil.toWrapperClass(toClass);
                return BcLangUtil.getDefaultValue(wrapperClass);
            }
            return null;
        }
        Object convValue = null;
        if (toClass.equals(Integer.class) || toClass.equals(Integer.TYPE)) {
            convValue = new Integer(src);
        } else if (toClass.equals(Short.class) || toClass.equals(Short.TYPE)) {
            convValue = new Short(src);
        } else if (toClass.equals(Long.class) || toClass.equals(Long.TYPE)) {
            convValue = new Long(src);
        } else if (toClass.equals(Character.class) || toClass.equals(Character.TYPE)) {
            convValue = new Character(src.charAt(0));
        } else if (toClass.equals(Byte.class) || toClass.equals(Byte.TYPE)) {
            convValue = new Byte(src);
        } else if (toClass.equals(Float.class) || toClass.equals(Float.TYPE)) {
            convValue = new Float(src);
        } else if (toClass.equals(Double.class) || toClass.equals(Double.TYPE)) {
            convValue = new Double(src);
        } else if (toClass.equals(BigDecimal.class)) {
            convValue = new BigDecimal(src);
        } else if (toClass.equals(Boolean.TYPE)) {
            convValue = new Boolean(src);
        } else if (toClass.equals(String.class)) {
            convValue = src.toString();
        } else if (toClass.equals(StringBuilder.class)) {
            convValue = new StringBuilder(src);
        } else if (toClass.equals(StringBuffer.class)) {
            convValue = new StringBuffer(src);
        } else if (Enum.class.isAssignableFrom(toClass)) {
            BcLogUtil.debug("#### toClass=" + toClass.getName());
            convValue = BcLangUtil.getEnumByName(toClass, src);
        } else if (toClass.equals(Calendar.class)) {
            if (!BcStringUtil.isEmpty(src)) {
                convValue = BcTimeUtil.toCalendar(src, formatPattern);
            }
        } else if (toClass.equals(java.util.Date.class)) {
            if (!BcStringUtil.isEmpty(src)) {
                Calendar calendar = BcTimeUtil.toCalendar(src, formatPattern);
                convValue = new java.util.Date(calendar.getTimeInMillis());
            }
        } else if (toClass.equals(Timestamp.class)) {
            if (!BcStringUtil.isEmpty(src)) {
                Calendar calendar = BcTimeUtil.toCalendar(src, formatPattern);
                convValue = new Timestamp(calendar.getTimeInMillis());
            }
        } else if (toClass.equals(Date.class)) {
            if (!BcStringUtil.isEmpty(src)) {
                Calendar calendar = BcTimeUtil.toCalendar(src, formatPattern);
                convValue = new Date(calendar.getTimeInMillis());
            }
        } else if (toClass.equals(Time.class)) {
            if (!BcStringUtil.isEmpty(src)) {
                Calendar calendar = BcTimeUtil.toCalendar(src, formatPattern);
                convValue = new Time(calendar.getTimeInMillis());
            }
        } else {
            throw new Exception(String.valueOf(String.class.getName()) + " -> " + toClass.getName());
        }
        return convValue;
    }

    public static Object calendarToObject(Calendar calendar, Class toClass, String formatPattern, Locale locale) throws Exception {
        if (toClass.equals(Calendar.class)) {
            return (Calendar)calendar.clone();
        }
        if (toClass.equals(String.class)) {
            return BcTimeUtil.toString(calendar, formatPattern, locale);
        }
        if (toClass.equals(java.util.Date.class)) {
            return new java.util.Date(calendar.getTimeInMillis());
        }
        if (toClass.equals(Timestamp.class)) {
            return new Timestamp(calendar.getTimeInMillis());
        }
        if (toClass.equals(Date.class)) {
            return new Date(calendar.getTimeInMillis());
        }
        if (toClass.equals(Time.class)) {
            return new Time(calendar.getTimeInMillis());
        }
        throw new Exception(String.valueOf(Calendar.class.getName()) + " -> " + toClass.getName());
    }
}

