/*
 * Decompiled with CFR 0.152.
 */
package ext.base.io;

import ext.base.event.BcEventHandler;
import ext.base.event.BcProgressEvent;
import ext.base.io.BcStreamFilter;
import ext.base.io.BcStreamTransmitter;
import ext.base.log.BcLogUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

public final class BcStreamUtil {
    public static int bufferSizeDefault = 1024;

    private BcStreamUtil() {
    }

    public static long transmit(InputStream is, OutputStream os, boolean checkAavailable, int bufSize, BcStreamFilter streamFilter) throws Exception {
        int available = 0;
        if (checkAavailable) {
            if (is.available() <= 0) {
                return 0L;
            }
            available = is.available();
        }
        if (bufSize <= 0) {
            bufSize = 4096;
        }
        byte[] byteBuf = new byte[bufSize];
        int cnt = 0;
        long totalCnt = 0L;
        while ((cnt = is.read(byteBuf, 0, byteBuf.length)) >= 0) {
            totalCnt += (long)cnt;
            if (streamFilter != null) {
                int i = 0;
                while (i < cnt) {
                    byteBuf[i] = (byte)(byteBuf[i] ^ streamFilter.getNextByte());
                    ++i;
                }
            }
            os.write(byteBuf, 0, cnt);
            if (!checkAavailable || totalCnt < (long)available) continue;
        }
        os.flush();
        return totalCnt;
    }

    public static long transmit(InputStream is, OutputStream os, boolean checkAavailable, int bufSize) throws Exception {
        return BcStreamUtil.transmit(is, os, checkAavailable, bufSize, null);
    }

    public static long transmit(InputStream is, OutputStream os, int bufSize) throws Exception {
        return BcStreamUtil.transmit(is, os, true, bufSize, null);
    }

    public static long transmit(Reader reader, Writer writer, int bufSize, BcStreamFilter streamFilter, BcEventHandler<BcProgressEvent> eventHandler) throws Exception {
        if (bufSize <= 0) {
            bufSize = 4096;
        }
        char[] byteBuf = new char[bufSize];
        int cnt = 0;
        long totalCnt = 0L;
        while ((cnt = reader.read(byteBuf, 0, byteBuf.length)) >= 0) {
            totalCnt += (long)cnt;
            if (streamFilter != null) {
                int i = 0;
                while (i < cnt) {
                    byteBuf[i] = (char)(byteBuf[i] ^ streamFilter.getNextByte());
                    ++i;
                }
            }
            writer.write(byteBuf, 0, cnt);
            if (eventHandler == null) continue;
            BcProgressEvent updateEvent = new BcProgressEvent(reader);
            updateEvent.max = -1L;
            updateEvent.value = totalCnt;
            eventHandler.handle(updateEvent);
        }
        writer.flush();
        return totalCnt;
    }

    public static long transmit(Reader reader, Writer writer, int bufSize) throws Exception {
        return BcStreamUtil.transmit(reader, writer, bufSize, null, null);
    }

    public static byte[] read(InputStream is, int bufferSize, boolean checkAavailable) throws Exception {
        if (checkAavailable && is.available() <= 0) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BcStreamTransmitter streamTransmitter = new BcStreamTransmitter();
        streamTransmitter.setBufferSize(bufferSize);
        streamTransmitter.transmit(is, baos);
        return baos.toByteArray();
    }

    public static byte[] read(InputStream is, int bufferSize) throws Exception {
        return BcStreamUtil.read(is, bufferSize, true);
    }

    public static byte[] read(InputStream is, boolean checkAavailable) throws Exception {
        return BcStreamUtil.read(is, bufferSizeDefault, checkAavailable);
    }

    public static byte[] read(InputStream is) throws Exception {
        return BcStreamUtil.read(is, bufferSizeDefault, true);
    }

    public static byte[] readWithClose(InputStream is) throws Exception {
        byte[] bytes = null;
        try {
            bytes = BcStreamUtil.read(is);
        }
        finally {
            is.close();
        }
        return bytes;
    }

    public static int read(InputStream is, byte[] bytes) throws Exception {
        int readCnt = 0;
        int offset = 0;
        while ((readCnt = is.read(bytes, offset, bytes.length - offset)) >= 0 && (offset += readCnt) < bytes.length) {
        }
        return offset;
    }

    public static ByteArrayOutputStream toBaos(InputStream is, int bufferSize) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BcStreamTransmitter streamTransmitter = new BcStreamTransmitter();
        streamTransmitter.setBufferSize(bufferSize);
        streamTransmitter.transmit(is, baos);
        is.close();
        return baos;
    }

    public static ByteArrayOutputStream toBaos(InputStream is) throws Exception {
        return BcStreamUtil.toBaos(is, bufferSizeDefault);
    }

    public static void skip(InputStream is, long skipSize) throws Exception {
        long readCnt = 0L;
        while ((readCnt += is.skip(skipSize - readCnt)) != skipSize) {
            if (readCnt <= skipSize) continue;
            throw new Exception("skip:readCnt=" + readCnt + "skipSize=" + skipSize);
        }
    }

    public static InputStream skipBom(InputStream is) throws Exception {
        if (is.available() < 3) {
            return is;
        }
        if (!is.markSupported()) {
            is = new BufferedInputStream(is);
        }
        is.mark(3);
        byte[] bytes = new byte[3];
        is.read(bytes, 0, 3);
        if (bytes[0] != -17 || bytes[1] != -69 || bytes[2] != -65) {
            is.reset();
        }
        return is;
    }

    public static boolean hasBom(InputStream is) throws Exception {
        if (is.available() < 3) {
            return false;
        }
        if (!is.markSupported()) {
            is = new BufferedInputStream(is);
        }
        is.mark(3);
        byte[] bytes = new byte[3];
        is.read(bytes, 0, 3);
        if (bytes[0] != -17 || bytes[1] != -69 || bytes[2] != -65) {
            is.reset();
            return false;
        }
        return true;
    }

    public static void close(Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof AutoCloseable) {
            AutoCloseable autoCloseable = (AutoCloseable)obj;
            try {
                autoCloseable.close();
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
    }

    public static String readAsString(InputStream is, boolean checkAavailable, Charset charset) throws Exception {
        String resStr = null;
        try {
            byte[] bytes = BcStreamUtil.read(is, checkAavailable);
            resStr = charset != null ? new String(bytes, charset) : new String(bytes);
        }
        finally {
            is.close();
        }
        return resStr;
    }

    public static String readAsString(InputStream is, boolean checkAavailable, String charsetName) throws Exception {
        Charset charset = null;
        if (charsetName != null) {
            charset = Charset.forName(charsetName);
        }
        return BcStreamUtil.readAsString(is, checkAavailable, charset);
    }

    public static String readAsString(InputStream is, Charset charset) throws Exception {
        return BcStreamUtil.readAsString(is, true, charset);
    }

    public static String readAsString(InputStream is, boolean checkAavailable) throws Exception {
        Charset charset = null;
        return BcStreamUtil.readAsString(is, checkAavailable, charset);
    }

    public static String readAsString(InputStream is, String charsetName) throws Exception {
        return BcStreamUtil.readAsString(is, true, charsetName);
    }

    public static String readAsString(InputStream is) throws Exception {
        Charset charset = null;
        return BcStreamUtil.readAsString(is, true, charset);
    }

    public static long compare(InputStream is1, InputStream is2) throws Exception {
        int cnt1 = 0;
        int cnt2 = 0;
        int totalCnt = 0;
        long pos = -1L;
        byte[] buf1 = new byte[1];
        byte[] buf2 = new byte[1];
        while ((cnt1 = is1.read(buf1, 0, buf1.length)) >= 0) {
            cnt2 = is2.read(buf2, 0, buf2.length);
            if (cnt2 < 0) {
                pos = totalCnt;
                break;
            }
            if (buf1[0] != buf2[0]) {
                pos = totalCnt;
                break;
            }
            totalCnt += cnt1;
        }
        return pos;
    }
}

