/*
 * Decompiled with CFR 0.152.
 */
package ext.base.io;

import ext.base.core.BcConstants;
import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.base.io.BcFileCopier;
import ext.base.io.BcFileNameComparator;
import ext.base.io.BcFileSearch;
import ext.base.io.BcStreamTransmitter;
import ext.base.io.BcStreamUtil;
import ext.base.log.BcLogUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public final class BcFileUtil {
    public static String fileSep;
    public static char[] lineSepWin;
    public static final BcFileSearch fileSerch;

    static {
        try {
            fileSep = System.getProperty("file.separator");
            lineSepWin = new char[]{'\r', '\n'};
        }
        catch (Exception ex) {
            BcLogUtil.error(ex);
        }
        fileSerch = new BcFileSearch();
    }

    private BcFileUtil() {
    }

    public static void createDirectories(Path dirPath, FileAttribute<?> ... attrs) throws Exception {
        try {
            Files.createDirectories(dirPath, attrs);
        }
        catch (FileAlreadyExistsException ex) {
            throw new IOException("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3001\u307e\u305f\u306f\u30d5\u30a1\u30a4\u30eb " + dirPath.toRealPath(new LinkOption[0]) + " \u306f\u65e2\u306b\u5b58\u5728\u3057\u3066\u3044\u307e\u3059\u3002");
        }
    }

    public static void createDirectoriesIfNotExists(Path dirPath, FileAttribute<?> ... attrs) throws Exception {
        if (Files.exists(dirPath, new LinkOption[0])) {
            if (!Files.isDirectory(dirPath, new LinkOption[0])) {
                throw new IOException(dirPath.toRealPath(new LinkOption[0]) + " \u306f\u5b58\u5728\u3057\u307e\u3059\u304c\u3001\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
            }
        } else {
            BcFileUtil.createDirectories(dirPath, attrs);
        }
    }

    public static void mkdirs(File dir, FileAttribute<?> ... attrs) throws Exception {
        Path dirPath = Paths.get(dir.getPath(), new String[0]);
        BcFileUtil.createDirectoriesIfNotExists(dirPath, attrs);
    }

    public static Path createParentIfNotExists(Path path) throws Exception {
        Path parentPath = path.getParent();
        BcFileUtil.createDirectoriesIfNotExists(parentPath, new FileAttribute[0]);
        return parentPath;
    }

    public static File makeParent(File file) throws Exception {
        Path path = Paths.get(file.getPath(), new String[0]);
        Path parentPath = BcFileUtil.createParentIfNotExists(path);
        return parentPath.toFile();
    }

    public static void move(Path sourcePath, Path targetPath, boolean createParent, CopyOption ... copyOptions) throws Exception {
        if (createParent) {
            Path path = BcFileUtil.createParentIfNotExists(targetPath);
        }
        Files.move(sourcePath, targetPath, copyOptions);
    }

    public static void move(Path sourcePath, Path targetPath, CopyOption ... copyOptions) throws Exception {
        BcFileUtil.move(sourcePath, targetPath, true, copyOptions);
    }

    public static void rename(File fromFile, File toFile) throws Exception {
        BcFileUtil.makeParent(toFile);
        if (toFile.exists()) {
            Locale locale = null;
            String msg = String.format(locale, "\u30ea\u30cd\u30fc\u30e0\u5148\u306e\u30d5\u30a1\u30a4\u30eb\u304c\u65e2\u306b\u5b58\u5728\u3057\u307e\u3059\u3002\u30ea\u30cd\u30fc\u30e0\u5143=%s \u30ea\u30cd\u30fc\u30e0\u5148=%s", fromFile.getPath(), toFile.getPath());
            throw new IOException(msg);
        }
        if (!fromFile.renameTo(toFile)) {
            Locale locale = null;
            String msg = String.format(locale, "%s \u3092 %s \u306b\u30ea\u30cd\u30fc\u30e0\u51fa\u6765\u307e\u305b\u3093\u3002", fromFile.getPath(), toFile.getPath());
            throw new IOException(msg);
        }
    }

    public static boolean deleteFile(File file, FileFilter fileFilter) throws Exception {
        boolean resValue = false;
        if (!file.exists()) {
            return resValue;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                BcFileUtil.deleteFile(files[i], fileFilter);
                ++i;
            }
        }
        if (fileFilter != null) {
            if (fileFilter.accept(file)) {
                resValue = file.delete();
            }
        } else {
            resValue = file.delete();
        }
        BcLogUtil.debug("deleteFile:file=" + file.getPath() + " resValue=" + resValue);
        return resValue;
    }

    public static boolean deleteFile(File file) throws Exception {
        return BcFileUtil.deleteFile(file, null);
    }

    public static void deleteIfExists(File file) throws Exception {
        if (!file.exists()) {
            return;
        }
        if (!BcFileUtil.deleteFile(file)) {
            String msg = "\u30d5\u30a1\u30a4\u30eb\u306e\u524a\u9664\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002" + file.getPath();
            throw new IOException(msg);
        }
    }

    public static boolean isRoot(File file) {
        boolean bool = false;
        if (BcStringUtil.isEmpty(file.getName())) {
            int pos = file.getPath().indexOf(58);
            if (pos >= 0) {
                bool = true;
            } else if (BcStringUtil.equals(file.getPath(), BcStringUtil.SLASH_STR)) {
                bool = true;
            }
        }
        return bool;
    }

    public static String getRootName(Path path) {
        int pos = path.toString().indexOf(58);
        return path.toString().substring(0, pos + 1);
    }

    public static String getExtention(String fileName) {
        int pos = fileName.lastIndexOf(46);
        if (pos >= 0) {
            return fileName.substring(pos + 1);
        }
        return null;
    }

    public static String getExtention(File file) {
        return BcFileUtil.getExtention(file.getName());
    }

    public static String getBaseName(String fileName) {
        int pos = fileName.lastIndexOf(46);
        if (pos >= 0) {
            return fileName.substring(0, pos);
        }
        return fileName;
    }

    public static String getBaseName(File file) {
        return BcFileUtil.getBaseName(file.getName());
    }

    public static String toCommonPath(String path) {
        String commonPath = BcStringUtil.replace((CharSequence)path, BcStringUtil.BACKSLASH_STR, BcStringUtil.SLASH_STR).toString();
        return commonPath;
    }

    public static File relativize(File dir, File file) throws Exception {
        URI fru = dir.toURI().relativize(file.toURI());
        File relativFile = new File(fru.toString());
        return relativFile;
    }

    public static String createFileName(String baseName, String extention) {
        StringBuilder sb = new StringBuilder();
        sb.append(baseName);
        if (!BcStringUtil.isEmpty(extention)) {
            sb.append(BcStringUtil.DOT_STR);
            sb.append(extention);
        }
        return sb.toString();
    }

    public static String replaceExtention(String fileName, String newExtention) {
        String extention = BcFileUtil.getExtention(fileName);
        if (BcStringUtil.isEmpty(extention)) {
            return fileName;
        }
        String baseName = BcFileUtil.getBaseName(fileName);
        return String.valueOf(baseName) + BcStringUtil.DOT_STR + newExtention;
    }

    public static File replaceExtention(File file, String newExtention) {
        String newFileName = BcFileUtil.replaceExtention(file.getName(), newExtention);
        File newFile = new File(file.getParentFile(), newFileName);
        return newFile;
    }

    public static List<URL> toUrlList(Collection<? extends File> fileCollection) throws MalformedURLException {
        ArrayList<URL> urlList = new ArrayList<URL>();
        for (File file : fileCollection) {
            urlList.add(file.toURI().toURL());
        }
        return urlList;
    }

    public static URL[] toUrls(File[] files) throws MalformedURLException {
        List<File> fileList = Arrays.asList(files);
        List<URL> urlList = BcFileUtil.toUrlList(fileList);
        URL[] urls = fileList.toArray(new URL[urlList.size()]);
        return urls;
    }

    public static File findFile(File file) throws Exception {
        File fileWk = file;
        do {
            if (!fileWk.exists()) continue;
            return fileWk;
        } while ((fileWk = fileWk.getParentFile()) != null);
        return null;
    }

    public static String toDirectoryPath(File dir) {
        StringBuilder str = new StringBuilder();
        str.append(dir.getPath());
        if (dir.isDirectory() && !str.toString().endsWith(BcStringUtil.SLASH_STR)) {
            str.append(BcStringUtil.SLASH_STR);
        }
        return str.toString();
    }

    public static List<File> getDirectoryList(File dir) {
        ArrayList<File> dirList = new ArrayList<File>();
        File[] files = dir.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.isDirectory()) {
                    dirList.add(file);
                }
                ++i;
            }
        }
        return dirList;
    }

    public static List<Path> toPathList(Path path) throws Exception {
        ArrayList<Path> pathList = new ArrayList<Path>();
        Path wk1Path = path;
        while (true) {
            pathList.add(wk1Path);
            if (wk1Path.getParent() == null) break;
            wk1Path = wk1Path.getParent();
        }
        Collections.reverse(pathList);
        return pathList;
    }

    public static String deleteTopSlash(String src) {
        if (BcStringUtil.isEmpty(src)) {
            return src;
        }
        if (src.startsWith(BcStringUtil.SLASH_STR)) {
            return src.substring(1);
        }
        return src;
    }

    public static boolean isEndSlash(CharSequence src) {
        if (BcStringUtil.isEmpty(src)) {
            return false;
        }
        char aChar = src.charAt(src.length() - 1);
        return aChar == '/';
    }

    public static String appendEndSlash(CharSequence src) {
        String res = null;
        res = BcFileUtil.isEndSlash(src) ? src.toString() : String.valueOf(BcStringUtil.toStringNotNull(src)) + BcStringUtil.SLASH_STR;
        return res;
    }

    public static void deleteEndSlash(StringBuilder src) {
        if (BcFileUtil.isEndSlash(src)) {
            src.deleteCharAt(src.length() - 1);
        }
    }

    public static String deleteEndSlash(String src) {
        if (BcStringUtil.isEmpty(src)) {
            return src;
        }
        StringBuilder sb = new StringBuilder(src);
        BcFileUtil.deleteEndSlash(sb);
        return sb.toString();
    }

    public static String toDirectoryPath(CharSequence src) {
        if (src.toString().endsWith(BcStringUtil.SLASH_STR)) {
            return src.toString();
        }
        return src + BcStringUtil.SLASH_STR;
    }

    public static void sortByName(File[] files) throws Exception {
        BcFileNameComparator fileComparator = new BcFileNameComparator();
        Arrays.sort(files, fileComparator);
    }

    public static List sortByName(Collection<File> filesCollection) throws Exception {
        File[] files = filesCollection.toArray(new File[0]);
        BcFileUtil.sortByName(files);
        return Arrays.asList(files);
    }

    public static byte[] read(File file, int bufSize) throws Exception {
        byte[] bytes = null;
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            bytes = bufSize > 0 ? BcStreamUtil.read((InputStream)is, bufSize) : BcStreamUtil.read(is);
        }
        return bytes;
    }

    public static byte[] read(File file) throws Exception {
        return BcFileUtil.read(file, -1);
    }

    public static byte[] read(String filePath, int bufSize) throws Exception {
        return BcFileUtil.read(new File(filePath), bufSize);
    }

    public static StringBuilder readAsStringBuilder(File file, Charset charset) throws Exception {
        StringBuilder sb = new StringBuilder();
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
        sb.append(BcStreamUtil.readAsString((InputStream)is, charset));
        return sb;
    }

    public static StringBuilder readAsStringBuilder(File file) throws Exception {
        return BcFileUtil.readAsStringBuilder(file, BcConstants.baseCharset);
    }

    public static void save(File file, byte[] bytes, boolean isAppend) throws Exception {
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file, isAppend));){
            ((OutputStream)os).write(bytes);
            ((OutputStream)os).flush();
        }
    }

    public static void save(File file, byte[] bytes) throws Exception {
        BcFileUtil.save(file, bytes, false);
    }

    public static void save(File file, String str, Charset charset) throws Exception {
        byte[] bytes = str.getBytes(charset);
        BcFileUtil.save(file, bytes);
    }

    public static void save(File file, String str) throws Exception {
        BcFileUtil.save(file, str, BcConstants.baseCharset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFile(File fromFile, File toFile, BcStreamTransmitter streamTransmitter, File tmpFile) throws Exception {
        File tmpFile2;
        block16: {
            tmpFile2 = toFile;
            if (tmpFile != null) {
                tmpFile2 = tmpFile;
            }
            Throwable throwable = null;
            Object var6_8 = null;
            try {
                BufferedInputStream io = new BufferedInputStream(new FileInputStream(fromFile));
                try {
                    try (FileOutputStream os = new FileOutputStream(tmpFile2);){
                        streamTransmitter.transmit(io, os);
                    }
                    if (io == null) break block16;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (io == null) throw throwable;
                    io.close();
                    throw throwable;
                }
                io.close();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        tmpFile2.setLastModified(fromFile.lastModified());
        if (tmpFile == null) return;
        BcFileUtil.rename(tmpFile2, toFile);
    }

    public static void copyFile(File fromFile, File toFile, BcStreamTransmitter streamTransmitter) throws Exception {
        File tmpFile = BcFileUtil.createTempFile(toFile.getName(), null, toFile.getParentFile());
        BcFileUtil.copyFile(fromFile, toFile, streamTransmitter, tmpFile);
    }

    public static void copyFile(File fromFile, File toFile, int bufferSize) throws Exception {
        BcStreamTransmitter streamTransmitter = new BcStreamTransmitter();
        if (bufferSize > 0) {
            streamTransmitter.setBufferSize(bufferSize);
        }
        BcFileUtil.copyFile(fromFile, toFile, streamTransmitter);
    }

    public static void copyFile(File fromFile, File toFile) throws Exception {
        BcFileUtil.copyFile(fromFile, toFile, -1);
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws Exception {
        String prefix2 = BcStringUtil.toNotNull(suffix);
        int gap = 3 - prefix2.length();
        if (gap >= 3) {
            prefix2 = String.valueOf(prefix2) + BcStringUtil.fill('~', gap);
        }
        File tmpFile = File.createTempFile(prefix2, suffix, directory);
        return tmpFile;
    }

    public static File createTempFile(File directory) throws Exception {
        return BcFileUtil.createTempFile("java", null, directory);
    }

    public static boolean hasBom(File file) throws Exception {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream is = new FileInputStream(file);){
            return BcStreamUtil.hasBom(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static long fileCompare(File file1, File file2) throws Exception {
        BufferedInputStream is1 = null;
        BufferedInputStream is2 = null;
        long pos = -1L;
        try {
            is1 = new BufferedInputStream(new FileInputStream(file1));
            is2 = new BufferedInputStream(new FileInputStream(file2));
            pos = BcStreamUtil.compare(is1, is2);
        }
        finally {
            if (is1 != null) {
                try {
                    is1.close();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
            if (is2 != null) {
                try {
                    is2.close();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        }
        return pos;
    }

    public static void collation(File file1, File file2, FileFilter fileFilter, Collection<File> sameFileCollection, Collection<File> differentFileCollection) throws Exception {
        if (file1.isDirectory()) {
            File[] files = null;
            files = fileFilter != null ? file1.listFiles(fileFilter) : file1.listFiles();
            int i = 0;
            while (i < files.length) {
                File file2x = new File(file2, files[i].getName());
                BcFileUtil.collation(files[i], file2x, fileFilter, sameFileCollection, differentFileCollection);
                ++i;
            }
        } else {
            if (fileFilter != null && !fileFilter.accept(file1)) {
                return;
            }
            if (!file2.exists()) {
                BcLogUtil.info("\u30d5\u30a1\u30a4\u30eb " + file2.getPath() + " \u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
                differentFileCollection.add(file1);
                return;
            }
            long mark = BcFileUtil.fileCompare(file1, file2);
            if (mark < 0L) {
                sameFileCollection.add(file1);
            } else {
                BcLogUtil.info("\u30d5\u30a1\u30a4\u30eb " + file1.getPath() + " \u306e " + mark + "\u30d0\u30a4\u30c8\u76ee\u304c\u7570\u306a\u308a\u307e\u3059\u3002");
                differentFileCollection.add(file1);
            }
        }
    }

    public static void copyDifferedFile(File file1, File file2, FileFilter fileFilter) throws Exception {
        BcLogUtil.info("file1.getPath()=" + file1.getPath());
        BcLogUtil.info("file2.getPath()=" + file2.getPath());
        ArrayList<File> sameFileList = new ArrayList<File>();
        ArrayList<File> differentFileList = new ArrayList<File>();
        BcFileUtil.collation(file1, file2, fileFilter, sameFileList, differentFileList);
        BcFileCopier fileCopier = new BcFileCopier();
        fileCopier.doOverwrite = true;
        int i = 0;
        while (i < differentFileList.size()) {
            File tmpFile1 = (File)differentFileList.get(i);
            StringBuilder tmpStr = BcStringUtil.replace((CharSequence)tmpFile1.getPath(), file1.getPath(), file2.getPath());
            BcLogUtil.info("tmpStr=" + tmpStr);
            fileCopier.doCopy(tmpFile1, new File(tmpStr.toString()));
            ++i;
        }
    }

    public static List<File> getFileList(File dir) throws Exception {
        ArrayList<File> fileList = new ArrayList<File>();
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new Exception(String.valueOf(dir.getPath()) + " is not directory.");
            }
            File[] files = dir.listFiles();
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                fileList.add(file);
                ++i;
            }
        }
        return fileList;
    }

    public static Exception[] close(FileOutputStream ... foses) {
        Exception[] exceptions = new Exception[foses.length];
        int i = 0;
        while (i < foses.length) {
            FileOutputStream fos = foses[i];
            if (fos == null) {
                BcLogUtil.warning("fises[" + i + "]=" + fos);
            } else {
                try {
                    fos.close();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                    exceptions[i] = ex;
                }
            }
            ++i;
        }
        return exceptions;
    }

    public static Exception[] close(FileInputStream ... fises) {
        Exception[] exceptions = new Exception[fises.length];
        int i = 0;
        while (i < fises.length) {
            FileInputStream fis = fises[i];
            if (fis == null) {
                BcLogUtil.warning("fises[" + i + "]=" + fis);
            } else {
                try {
                    fis.close();
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                    exceptions[i] = ex;
                }
            }
            ++i;
        }
        return exceptions;
    }

    public static FileOutputStream[] createFileOutputStream(File ... files) throws Exception {
        FileOutputStream[] foses = new FileOutputStream[files.length];
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            try {
                FileOutputStream fos;
                foses[i] = fos = new FileOutputStream(file, true);
            }
            catch (Exception ex) {
                BcStringUtil.appendExceptEmpty(sb, '\n', ex.getMessage());
            }
            ++i;
        }
        if (!BcStringUtil.isEmpty(sb)) {
            BcFileUtil.close(foses);
            throw new IOException(sb.toString());
        }
        return foses;
    }

    public static void notEexistsException(File file) throws Exception {
        if (!file.exists()) {
            String msg = String.valueOf(file.getPath()) + "\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002";
            throw new FileNotFoundException(msg);
        }
    }

    public static String createFileLockFailureMessage(File file) {
        String msg = "\u30d5\u30a1\u30a4\u30eb\u30ed\u30c3\u30af\u304c\u53d6\u5f97\u51fa\u6765\u307e\u305b\u3093\u3002" + file.getPath();
        return msg;
    }

    public static IOException createFileLockFailureException(File file) {
        String msg = BcFileUtil.createFileLockFailureMessage(file);
        return new IOException(msg);
    }

    public static List<File> toList(File[] files, List<File> fileList) throws Exception {
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            fileList.add(file);
            ++i;
        }
        return fileList;
    }

    public static ArrayList<File> toArrayList(File[] files) throws Exception {
        ArrayList<File> fileList = new ArrayList<File>();
        BcFileUtil.toList(files, fileList);
        return fileList;
    }

    protected static void tempDelete(File file, String[] targrtFileNameList) throws Exception {
        if (file.isDirectory()) {
            System.out.println(String.valueOf(file.getPath()) + "/" + file.getName());
            String[] fileNameList = file.list();
            int i = 0;
            while (i < fileNameList.length) {
                BcFileUtil.tempDelete(new File(String.valueOf(file.getPath()) + "/" + fileNameList[i]), targrtFileNameList);
                ++i;
            }
        } else {
            int i = 0;
            while (i < targrtFileNameList.length) {
                if (targrtFileNameList[i].equals(file.getName())) {
                    file.delete();
                    System.out.println(String.valueOf(file.getPath()) + "/" + file.getName());
                }
                ++i;
            }
        }
    }

    public static String addSuffix(String fileName, String suffix) {
        StringBuilder sb = new StringBuilder(BcFileUtil.getBaseName(fileName));
        sb.append(suffix);
        BcStringUtil.appendCaseOfNotEmpty(sb, BcFileUtil.getExtention(fileName));
        return sb.toString();
    }

    public static String create_yyyyMMdd_HHmmssSSS() {
        Calendar calendar = BcTimeUtil.createCalendar();
        String suffix = String.valueOf(BcTimeUtil.toString(calendar, "yyyyMMdd")) + "_" + BcTimeUtil.toString(calendar, "HHmmss.SSS");
        return suffix;
    }

    public static String add_yyyyMMdd_HHmmssSSS(String fileName) {
        String suffix = "_" + BcFileUtil.create_yyyyMMdd_HHmmssSSS();
        return BcFileUtil.addSuffix(fileName, suffix);
    }

    public static boolean isSameSizeAndLastModified(File file1, File file2) throws Exception {
        boolean isSame = false;
        if (file1.length() != file2.length() || file1.lastModified() != file2.lastModified()) {
            isSame = true;
        }
        return isSame;
    }

    public static String createInfo(File file) {
        StringBuilder sb = new StringBuilder();
        if (file == null) {
            sb.append("File is null.");
            return sb.toString();
        }
        if (file.isDirectory()) {
            sb.append("\u30d1\u30b9=" + file.getPath());
            sb.append(BcStringUtil.lineSeparator);
            sb.append("\u66f4\u65b0\u65e5\u6642=" + BcTimeUtil.toString(file.lastModified(), "yyyy/MM/dd HH:mm:ss.SSS"));
            sb.append(BcStringUtil.lineSeparator);
            sb.append("\u30d5\u30a1\u30a4\u30eb\u6570=" + file.listFiles().length);
            return sb.toString();
        }
        sb.append("\u30c7\u30a3\u30ec\u30af\u30c8\u30ea=" + file.getParent());
        sb.append(BcStringUtil.lineSeparator);
        sb.append("\u540d\u524d=" + file.getName());
        sb.append(BcStringUtil.lineSeparator);
        sb.append("\u66f4\u65b0\u65e5\u6642=" + BcTimeUtil.toString(file.lastModified(), "yyyy/MM/dd HH:mm:ss.SSS"));
        sb.append(BcStringUtil.lineSeparator);
        sb.append("\u30b5\u30a4\u30ba=" + file.length());
        return sb.toString();
    }

    public static void writeableCheck(File file) throws Exception {
        if (file.exists() && !file.canWrite()) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u306b\u66f8\u304d\u8fbc\u307f\u3067\u304d\u307e\u305b\u3093\u3002\u30d5\u30a1\u30a4\u30eb=" + file.getPath());
        }
    }
}

