/*
 * Decompiled with CFR 0.152.
 */
package com.nilo.plaf.nimrod;

import com.nilo.plaf.nimrod.NimRODBorders;
import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import com.nilo.plaf.nimrod.NimRODUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.metal.MetalComboBoxButton;
import javax.swing.plaf.metal.MetalComboBoxEditor;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class NimRODComboBoxUI
extends MetalComboBoxUI {
    private boolean rollover = false;
    private boolean focus = false;
    private MiML miML;
    protected boolean oldOpaque;

    public static ComponentUI createUI(JComponent c) {
        return new NimRODComboBoxUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.oldOpaque = this.comboBox.isOpaque();
        this.comboBox.setOpaque(false);
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.comboBox.setOpaque(this.oldOpaque);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.miML = new MiML();
        this.comboBox.addMouseListener(this.miML);
        this.comboBox.addFocusListener(this.miML);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.comboBox.removeMouseListener(this.miML);
        this.comboBox.removeFocusListener(this.miML);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        Dimension dim = super.getMinimumSize(c);
        if (this.comboBox.isEditable()) {
            dim.height = this.editor.getPreferredSize().height;
        }
        dim.width += 20;
        return dim;
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new NimRODComboBoxEditor();
    }

    @Override
    protected JButton createArrowButton() {
        return new NimRODComboBoxButton(this.comboBox, UIManager.getIcon("ComboBox.buttonDownIcon"), this.comboBox.isEditable(), this.currentValuePane, this.listBox);
    }

    public class MiML
    extends MouseAdapter
    implements FocusListener {
        protected void refresh() {
            if (NimRODComboBoxUI.this.comboBox != null && NimRODComboBoxUI.this.comboBox.getParent() != null) {
                NimRODComboBoxUI.this.comboBox.getParent().repaint(NimRODComboBoxUI.this.comboBox.getX() - 5, NimRODComboBoxUI.this.comboBox.getY() - 5, NimRODComboBoxUI.this.comboBox.getWidth() + 10, NimRODComboBoxUI.this.comboBox.getHeight() + 10);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            NimRODComboBoxUI.this.rollover = false;
            this.refresh();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            NimRODComboBoxUI.this.rollover = true;
            this.refresh();
        }

        @Override
        public void focusGained(FocusEvent e) {
            NimRODComboBoxUI.this.focus = true;
            this.refresh();
        }

        @Override
        public void focusLost(FocusEvent e) {
            NimRODComboBoxUI.this.focus = false;
            this.refresh();
        }
    }

    private final class NimRODComboBoxButton
    extends MetalComboBoxButton {
        private static final long serialVersionUID = 1L;

        public NimRODComboBoxButton(JComboBox cb, Icon icon, boolean editable, CellRendererPane pane, JList list) {
            super(cb, icon, editable, pane, list);
            NimRODComboBoxUI.this.miML = new MiML();
            this.addMouseListener(NimRODComboBoxUI.this.miML);
            this.addFocusListener(NimRODComboBoxUI.this.miML);
        }

        @Override
        public boolean contains(int x, int y) {
            boolean res = super.contains(x, y);
            if (res && !this.iconOnly && x < this.getWidth() - this.comboIcon.getIconWidth() - this.getInsets().right - 5) {
                res = false;
            }
            return res;
        }

        @Override
        public void paintComponent(Graphics g) {
            Insets ins;
            Border bb;
            boolean canijo = false;
            if (this.iconOnly) {
                bb = NimRODBorders.getComboButtonBorder();
                ins = bb.getBorderInsets(this.comboBox);
                if (this.getSize().height < this.comboIcon.getIconHeight() + ins.top + ins.bottom || this.getSize().width < this.comboIcon.getIconWidth() + ins.left + ins.right) {
                    canijo = true;
                    bb = NimRODBorders.getThinGenBorder();
                }
                this.setBorder(bb);
                this.setMargin(new Insets(0, 5, 0, 7));
            } else {
                bb = NimRODBorders.getComboEditorBorder();
                ins = bb.getBorderInsets(this.comboBox);
                if (this.getSize().height < this.getFont().getSize() + ins.top + ins.bottom) {
                    canijo = true;
                    bb = NimRODBorders.getThinGenBorder();
                }
                this.setBorder(bb);
                this.setOpaque(false);
            }
            if (!this.iconOnly && this.comboBox != null) {
                try {
                    g.setColor(this.getBackground());
                    if (!canijo) {
                        g.fillRect(2, 3, this.getWidth() - 4, this.getHeight() - 6);
                    } else {
                        g.fillRect(0, 0, this.getWidth(), this.getHeight());
                    }
                    g.drawLine(3, 2, this.getWidth() - 4, 2);
                    g.drawLine(3, this.getHeight() - 3, this.getWidth() - 4, this.getHeight() - 3);
                    this.paintLeches(g);
                }
                catch (Exception bb2) {
                    // empty catch block
                }
            }
            if (this.iconOnly) {
                RoundRectangle2D.Float boton = new RoundRectangle2D.Float();
                if (canijo) {
                    boton.x = 0.0f;
                    boton.y = 0.0f;
                    boton.width = this.getWidth();
                    boton.height = this.getHeight();
                    boton.arcwidth = 1.0f;
                    boton.archeight = 1.0f;
                } else {
                    boton.x = 2.0f;
                    boton.y = 2.0f;
                    boton.width = this.getWidth() - 4;
                    boton.height = this.getHeight() - 4;
                    boton.arcwidth = 8.0f;
                    boton.archeight = 8.0f;
                }
                this.setOpaque(false);
                this.paintLeches(g);
                ButtonModel mod = this.getModel();
                Graphics2D g2D = (Graphics2D)g;
                g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                GradientPaint grad = null;
                if (mod.isPressed() || mod.isSelected()) {
                    grad = new GradientPaint(0.0f, 0.0f, NimRODUtils.getSombra(), 0.0f, this.getHeight(), NimRODUtils.getBrillo());
                    g2D.setPaint(grad);
                    g2D.fill(boton);
                } else {
                    grad = new GradientPaint(0.0f, 0.0f, NimRODUtils.getBrillo(), 0.0f, this.getHeight(), NimRODUtils.getSombra());
                    g2D.setPaint(grad);
                    g2D.fill(boton);
                }
                g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_DEFAULT);
            }
            if (this.isEnabled() && !canijo) {
                if (NimRODComboBoxUI.this.focus) {
                    NimRODUtils.paintFocus(g, 1, 1, this.getWidth() - 2, this.getHeight() - 2, 4, 4, 3.0f, NimRODLookAndFeel.getFocusColor());
                } else if (NimRODComboBoxUI.this.rollover) {
                    NimRODUtils.paintFocus(g, 1, 1, this.getWidth() - 2, this.getHeight() - 2, 4, 4, 3.0f, NimRODUtils.getColorAlfa(NimRODLookAndFeel.getFocusColor(), 150));
                }
            }
        }

        protected void paintLeches(Graphics g) {
            int iconLeft;
            boolean leftToRight = this.comboBox.getComponentOrientation().isLeftToRight();
            if (this.ui != null) {
                Graphics scratchGraphics = g == null ? null : g.create();
                try {
                    this.ui.update(scratchGraphics, this);
                }
                finally {
                    scratchGraphics.dispose();
                }
            }
            Insets insets = this.getInsets();
            int width = this.getWidth() - (insets.left + insets.right);
            int height = this.getHeight() - (insets.top + insets.bottom);
            if (height <= 0 || width <= 0) {
                return;
            }
            int left = insets.left;
            int top = insets.top;
            int right = left + (width - 1);
            int bottom = top + (height - 1);
            int iconWidth = 0;
            int n = iconLeft = leftToRight ? right : left;
            if (this.comboIcon != null) {
                iconWidth = this.comboIcon.getIconWidth();
                int iconHeight = this.comboIcon.getIconHeight();
                int iconTop = 0;
                if (this.iconOnly) {
                    iconLeft = this.getWidth() / 2 - iconWidth / 2;
                    iconTop = this.getHeight() / 2 - iconHeight / 2;
                } else {
                    iconLeft = leftToRight ? left + (width - 1) - iconWidth : left;
                    iconTop = top + (bottom - top) / 2 - iconHeight / 2;
                }
                this.comboIcon.paintIcon(this, g, iconLeft, iconTop);
                if (!this.iconOnly) {
                    g.setColor(NimRODUtils.getSombra());
                    g.drawLine(iconLeft - 5, 6, iconLeft - 5, this.getHeight() - 6);
                    g.setColor(NimRODUtils.getBrillo());
                    g.drawLine(iconLeft - 4, 6, iconLeft - 4, this.getHeight() - 6);
                }
            }
            if (!this.iconOnly && this.comboBox != null) {
                ListCellRenderer<Object> renderer = this.comboBox.getRenderer();
                boolean renderPressed = this.getModel().isPressed();
                Component c = renderer.getListCellRendererComponent(this.listBox, this.comboBox.getSelectedItem(), -1, renderPressed, false);
                c.setFont(this.rendererPane.getFont());
                if (this.model.isArmed() && this.model.isPressed()) {
                    c.setForeground(this.comboBox.getForeground());
                    c.setBackground(this.getBackground());
                } else if (!this.comboBox.isEnabled()) {
                    if (this.isOpaque()) {
                        c.setBackground(UIManager.getColor("ComboBox.disabledBackground"));
                    }
                    c.setForeground(UIManager.getColor("ComboBox.disabledForeground"));
                } else {
                    c.setForeground(this.comboBox.getForeground());
                    c.setBackground(this.comboBox.getBackground());
                }
                int cWidth = width - (insets.right + iconWidth);
                boolean shouldValidate = false;
                if (c instanceof JPanel) {
                    shouldValidate = true;
                }
                if (leftToRight) {
                    this.rendererPane.paintComponent(g, c, this, left, top, cWidth, height, shouldValidate);
                } else {
                    this.rendererPane.paintComponent(g, c, this, left + iconWidth, top, cWidth, height, shouldValidate);
                }
            }
        }
    }

    public class NimRODComboBoxEditor
    extends MetalComboBoxEditor {
        public NimRODComboBoxEditor() {
            this.editor.setBorder(NimRODBorders.getComboEditorBorder());
        }
    }
}

