/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import com.beust.jcommander.JCommander;
import com.google.zxing.client.j2se.DecodeWorker;
import com.google.zxing.client.j2se.DecoderConfig;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public final class CommandLineRunner {
    private CommandLineRunner() {
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws Exception {
        DecoderConfig config = new DecoderConfig();
        JCommander jCommander = new JCommander((Object)config);
        jCommander.parse(args);
        jCommander.setProgramName(CommandLineRunner.class.getSimpleName());
        if (config.help) {
            jCommander.usage();
            return;
        }
        List<URI> inputs = new ArrayList<URI>(config.inputPaths.size());
        for (String inputPath : config.inputPaths) {
            URI uri;
            try {
                uri = new URI(inputPath);
            }
            catch (URISyntaxException use) {
                if (!Files.exists(Paths.get(inputPath, new String[0]), new LinkOption[0])) {
                    throw use;
                }
                uri = new URI("file", inputPath, null);
            }
            inputs.add(uri);
        }
        do {
            inputs = CommandLineRunner.retainValid(CommandLineRunner.expand(inputs), config.recursive);
        } while (config.recursive && CommandLineRunner.isExpandable(inputs));
        int numInputs = inputs.size();
        if (numInputs == 0) {
            jCommander.usage();
            return;
        }
        ConcurrentLinkedQueue<URI> syncInputs = new ConcurrentLinkedQueue<URI>(inputs);
        int numThreads = Math.min(numInputs, Runtime.getRuntime().availableProcessors());
        int successful = 0;
        if (numThreads > 1) {
            void var10_14;
            ExecutorService executor = Executors.newFixedThreadPool(numThreads);
            ArrayList<Future<Integer>> futures = new ArrayList<Future<Integer>>(numThreads);
            boolean bl = false;
            while (var10_14 < numThreads) {
                futures.add(executor.submit(new DecodeWorker(config, syncInputs)));
                ++var10_14;
            }
            executor.shutdown();
            for (Future future : futures) {
                successful += ((Integer)future.get()).intValue();
            }
        } else {
            successful += new DecodeWorker(config, syncInputs).call().intValue();
        }
        if (!config.brief && numInputs > 1) {
            System.out.println("\nDecoded " + successful + " files out of " + numInputs + " successfully (" + successful * 100 / numInputs + "%)\n");
        }
    }

    private static List<URI> expand(Iterable<URI> inputs) throws IOException {
        ArrayList<URI> expanded = new ArrayList<URI>();
        for (URI input : inputs) {
            if (CommandLineRunner.isFileOrDir(input)) {
                Path inputPath = Paths.get(input);
                if (Files.isDirectory(inputPath, new LinkOption[0])) {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (DirectoryStream<Path> childPaths = Files.newDirectoryStream(inputPath);){
                        for (Path childPath : childPaths) {
                            expanded.add(childPath.toUri());
                        }
                        continue;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                expanded.add(input);
                continue;
            }
            expanded.add(input);
        }
        int i = 0;
        while (i < expanded.size()) {
            URI input = (URI)expanded.get(i);
            if (input.getScheme() == null) {
                expanded.set(i, Paths.get(input.getRawPath(), new String[0]).toUri());
            }
            ++i;
        }
        return expanded;
    }

    private static List<URI> retainValid(Iterable<URI> inputs, boolean recursive) {
        ArrayList<URI> retained = new ArrayList<URI>();
        for (URI input : inputs) {
            Path inputPath;
            boolean retain = CommandLineRunner.isFileOrDir(input) ? !(inputPath = Paths.get(input)).getFileName().toString().startsWith(".") && (recursive || !Files.isDirectory(inputPath, new LinkOption[0])) : true;
            if (!retain) continue;
            retained.add(input);
        }
        return retained;
    }

    private static boolean isExpandable(Iterable<URI> inputs) {
        for (URI input : inputs) {
            if (!CommandLineRunner.isFileOrDir(input) || !Files.isDirectory(Paths.get(input), new LinkOption[0])) continue;
            return true;
        }
        return false;
    }

    private static boolean isFileOrDir(URI uri) {
        return "file".equals(uri.getScheme());
    }
}

