/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.commons.io.output.UnsynchronizedByteArrayOutputStream;
import org.apache.poi.hslf.model.textproperties.HSLFTabStop;
import org.apache.poi.hslf.model.textproperties.HSLFTabStopPropCollection;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.GenericRecordUtil;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.LittleEndianByteArrayInputStream;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.LittleEndianOutput;
import org.apache.poi.util.LittleEndianOutputStream;

public final class TextRulerAtom
extends RecordAtom {
    private static final BitField DEFAULT_TAB_SIZE = BitFieldFactory.getInstance((int)1);
    private static final BitField C_LEVELS = BitFieldFactory.getInstance((int)2);
    private static final BitField TAB_STOPS = BitFieldFactory.getInstance((int)4);
    private static final BitField[] LEFT_MARGIN_LVL_MASK = new BitField[]{BitFieldFactory.getInstance((int)8), BitFieldFactory.getInstance((int)16), BitFieldFactory.getInstance((int)32), BitFieldFactory.getInstance((int)64), BitFieldFactory.getInstance((int)128)};
    private static final BitField[] INDENT_LVL_MASK = new BitField[]{BitFieldFactory.getInstance((int)256), BitFieldFactory.getInstance((int)512), BitFieldFactory.getInstance((int)1024), BitFieldFactory.getInstance((int)2048), BitFieldFactory.getInstance((int)4096)};
    private final byte[] _header = new byte[8];
    private Integer defaultTabSize;
    private Integer numLevels;
    private final List<HSLFTabStop> tabStops = new ArrayList<HSLFTabStop>();
    private final Integer[] leftMargin = new Integer[5];
    private final Integer[] indent = new Integer[5];

    public TextRulerAtom() {
        LittleEndian.putShort((byte[])this._header, (int)2, (short)((short)this.getRecordType()));
    }

    TextRulerAtom(byte[] source, int start, int len) {
        LittleEndianByteArrayInputStream leis = new LittleEndianByteArrayInputStream(source, start, Math.min(len, TextRulerAtom.getMaxRecordLength()));
        try {
            IOUtils.readFully((InputStream)leis, (byte[])this._header);
            this.read(leis);
        }
        catch (IOException e) {
            LOG.atError().withThrowable((Throwable)e).log("Failed to parse TextRulerAtom");
        }
    }

    @Override
    public long getRecordType() {
        return RecordTypes.TextRulerAtom.typeID;
    }

    @Override
    public void writeOut(OutputStream out) throws IOException {
        UnsynchronizedByteArrayOutputStream bos = new UnsynchronizedByteArrayOutputStream(200);
        LittleEndianOutputStream lbos = new LittleEndianOutputStream((OutputStream)bos);
        int mask = 0;
        mask |= TextRulerAtom.writeIf(lbos, this.numLevels, C_LEVELS);
        mask |= TextRulerAtom.writeIf(lbos, this.defaultTabSize, DEFAULT_TAB_SIZE);
        mask |= TextRulerAtom.writeIf(lbos, this.tabStops, TAB_STOPS);
        for (int i = 0; i < 5; ++i) {
            mask |= TextRulerAtom.writeIf(lbos, this.leftMargin[i], LEFT_MARGIN_LVL_MASK[i]);
            mask |= TextRulerAtom.writeIf(lbos, this.indent[i], INDENT_LVL_MASK[i]);
        }
        LittleEndian.putInt((byte[])this._header, (int)4, (int)(bos.size() + 4));
        out.write(this._header);
        LittleEndian.putUShort((int)mask, (OutputStream)out);
        LittleEndian.putUShort((int)0, (OutputStream)out);
        bos.writeTo(out);
    }

    private static int writeIf(LittleEndianOutputStream lbos, Integer value, BitField bit) {
        boolean isSet = false;
        if (value != null) {
            lbos.writeShort(value.intValue());
            isSet = true;
        }
        return bit.setBoolean(0, isSet);
    }

    private static int writeIf(LittleEndianOutputStream lbos, List<HSLFTabStop> value, BitField bit) {
        boolean isSet = false;
        if (value != null && !value.isEmpty()) {
            HSLFTabStopPropCollection.writeTabStops((LittleEndianOutput)lbos, value);
            isSet = true;
        }
        return bit.setBoolean(0, isSet);
    }

    private void read(LittleEndianByteArrayInputStream leis) {
        int mask = leis.readInt();
        this.numLevels = TextRulerAtom.readIf(leis, mask, C_LEVELS);
        this.defaultTabSize = TextRulerAtom.readIf(leis, mask, DEFAULT_TAB_SIZE);
        if (TAB_STOPS.isSet(mask)) {
            this.tabStops.addAll(HSLFTabStopPropCollection.readTabStops((LittleEndianInput)leis));
        }
        for (int i = 0; i < 5; ++i) {
            this.leftMargin[i] = TextRulerAtom.readIf(leis, mask, LEFT_MARGIN_LVL_MASK[i]);
            this.indent[i] = TextRulerAtom.readIf(leis, mask, INDENT_LVL_MASK[i]);
        }
    }

    private static Integer readIf(LittleEndianByteArrayInputStream leis, int mask, BitField bit) {
        return bit.isSet(mask) ? Integer.valueOf(leis.readShort()) : null;
    }

    public int getDefaultTabSize() {
        return this.defaultTabSize == null ? 0 : this.defaultTabSize;
    }

    public int getNumberOfLevels() {
        return this.numLevels == null ? 0 : this.numLevels;
    }

    public List<HSLFTabStop> getTabStops() {
        return this.tabStops;
    }

    public Integer[] getTextOffsets() {
        return this.leftMargin;
    }

    public Integer[] getBulletOffsets() {
        return this.indent;
    }

    public static TextRulerAtom getParagraphInstance() {
        TextRulerAtom tra = new TextRulerAtom();
        tra.indent[0] = 249;
        tra.indent[1] = tra.leftMargin[1] = Integer.valueOf(321);
        return tra;
    }

    public void setParagraphIndent(short leftMargin, short indent) {
        Arrays.fill((Object[])this.leftMargin, null);
        Arrays.fill((Object[])this.indent, null);
        this.leftMargin[0] = leftMargin;
        this.indent[0] = indent;
        this.indent[1] = indent;
    }

    public Map<String, Supplier<?>> getGenericProperties() {
        return GenericRecordUtil.getGenericProperties((String)"defaultTabSize", this::getDefaultTabSize, (String)"numLevels", this::getNumberOfLevels, (String)"tabStops", this::getTabStops, (String)"leftMargins", () -> this.leftMargin, (String)"indents", () -> this.indent);
    }
}

