/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.xpointer;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xinclude.XIncludeHandler;
import org.apache.xerces.xinclude.XIncludeNamespaceSupport;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xpointer.ElementSchemePointer;
import org.apache.xerces.xpointer.ShortHandPointer;
import org.apache.xerces.xpointer.XPointerErrorHandler;
import org.apache.xerces.xpointer.XPointerMessageFormatter;
import org.apache.xerces.xpointer.XPointerPart;
import org.apache.xerces.xpointer.XPointerProcessor;

public final class XPointerHandler
extends XIncludeHandler
implements XPointerProcessor {
    protected ArrayList fXPointerParts = new ArrayList();
    protected XPointerPart fXPointerPart = null;
    protected boolean fFoundMatchingPtrPart = false;
    protected XMLErrorReporter fXPointerErrorReporter;
    protected XMLErrorHandler fErrorHandler;
    protected SymbolTable fSymbolTable = null;
    private final String ELEMENT_SCHEME_NAME = "element";
    protected boolean fIsXPointerResolved = false;
    protected boolean fFixupBase = false;
    protected boolean fFixupLang = false;

    public XPointerHandler() {
        this.fSymbolTable = new SymbolTable();
    }

    public XPointerHandler(SymbolTable symbolTable, XMLErrorHandler errorHandler, XMLErrorReporter errorReporter) {
        this.fSymbolTable = symbolTable;
        this.fErrorHandler = errorHandler;
        this.fXPointerErrorReporter = errorReporter;
    }

    @Override
    public void setDocumentHandler(XMLDocumentHandler handler) {
        this.fDocumentHandler = handler;
    }

    @Override
    public void parseXPointer(String xpointer) throws XNIException {
        this.init();
        Tokens tokens = new Tokens(this.fSymbolTable);
        Scanner scanner = new Scanner(this, this.fSymbolTable){

            @Override
            protected void addToken(Tokens tokens, int token) throws XNIException {
                if (token == 0 || token == 1 || token == 3 || token == 4 || token == 2) {
                    super.addToken(tokens, token);
                    return;
                }
                this.reportError("InvalidXPointerToken", new Object[]{tokens.getTokenString(token)});
            }
        };
        int length = xpointer.length();
        boolean success = scanner.scanExpr(this.fSymbolTable, tokens, xpointer, 0, length);
        if (!success) {
            this.reportError("InvalidXPointerExpression", new Object[]{xpointer});
        }
        while (tokens.hasMore()) {
            int token = tokens.nextToken();
            switch (token) {
                case 2: {
                    token = tokens.nextToken();
                    String shortHandPointerName = tokens.getTokenString(token);
                    if (shortHandPointerName == null) {
                        this.reportError("InvalidXPointerExpression", new Object[]{xpointer});
                    }
                    ShortHandPointer shortHandPointer = new ShortHandPointer(this.fSymbolTable);
                    shortHandPointer.setSchemeName(shortHandPointerName);
                    this.fXPointerParts.add(shortHandPointer);
                    break;
                }
                case 3: {
                    token = tokens.nextToken();
                    String prefix = tokens.getTokenString(token);
                    token = tokens.nextToken();
                    String localName = tokens.getTokenString(token);
                    String schemeName = String.valueOf(prefix) + localName;
                    int openParenCount = 0;
                    int closeParenCount = 0;
                    token = tokens.nextToken();
                    String openParen = tokens.getTokenString(token);
                    if (openParen != "XPTRTOKEN_OPEN_PAREN") {
                        if (token == 2) {
                            this.reportError("MultipleShortHandPointers", new Object[]{xpointer});
                        } else {
                            this.reportError("InvalidXPointerExpression", new Object[]{xpointer});
                        }
                    }
                    ++openParenCount;
                    String schemeData = null;
                    while (tokens.hasMore()) {
                        token = tokens.nextToken();
                        schemeData = tokens.getTokenString(token);
                        if (schemeData != "XPTRTOKEN_OPEN_PAREN") break;
                        ++openParenCount;
                    }
                    token = tokens.nextToken();
                    schemeData = tokens.getTokenString(token);
                    token = tokens.nextToken();
                    String closeParen = tokens.getTokenString(token);
                    if (closeParen != "XPTRTOKEN_CLOSE_PAREN") {
                        this.reportError("SchemeDataNotFollowedByCloseParenthesis", new Object[]{xpointer});
                    }
                    ++closeParenCount;
                    while (tokens.hasMore()) {
                        if (tokens.getTokenString(tokens.peekToken()) != "XPTRTOKEN_OPEN_PAREN") break;
                        ++closeParenCount;
                    }
                    if (openParenCount != closeParenCount) {
                        this.reportError("UnbalancedParenthesisInXPointerExpression", new Object[]{xpointer, new Integer(openParenCount), new Integer(closeParenCount)});
                    }
                    if (schemeName.equals("element")) {
                        ElementSchemePointer elementSchemePointer = new ElementSchemePointer(this.fSymbolTable, this.fErrorReporter);
                        elementSchemePointer.setSchemeName(schemeName);
                        elementSchemePointer.setSchemeData(schemeData);
                        try {
                            elementSchemePointer.parseXPointer(schemeData);
                            this.fXPointerParts.add(elementSchemePointer);
                            break;
                        }
                        catch (XNIException e) {
                            throw new XNIException(e);
                        }
                    }
                    this.reportWarning("SchemeUnsupported", new Object[]{schemeName});
                    break;
                }
                default: {
                    this.reportError("InvalidXPointerExpression", new Object[]{xpointer});
                }
            }
        }
    }

    @Override
    public boolean resolveXPointer(QName element, XMLAttributes attributes, Augmentations augs, int event) throws XNIException {
        boolean resolved = false;
        if (!this.fFoundMatchingPtrPart) {
            int i = 0;
            while (i < this.fXPointerParts.size()) {
                this.fXPointerPart = (XPointerPart)this.fXPointerParts.get(i);
                if (this.fXPointerPart.resolveXPointer(element, attributes, augs, event)) {
                    this.fFoundMatchingPtrPart = true;
                    resolved = true;
                }
                ++i;
            }
        } else if (this.fXPointerPart.resolveXPointer(element, attributes, augs, event)) {
            resolved = true;
        }
        if (!this.fIsXPointerResolved) {
            this.fIsXPointerResolved = resolved;
        }
        return resolved;
    }

    @Override
    public boolean isFragmentResolved() throws XNIException {
        boolean resolved;
        boolean bl = resolved = this.fXPointerPart != null ? this.fXPointerPart.isFragmentResolved() : false;
        if (!this.fIsXPointerResolved) {
            this.fIsXPointerResolved = resolved;
        }
        return resolved;
    }

    public boolean isChildFragmentResolved() throws XNIException {
        boolean resolved = this.fXPointerPart != null ? this.fXPointerPart.isChildFragmentResolved() : false;
        return resolved;
    }

    @Override
    public boolean isXPointerResolved() throws XNIException {
        return this.fIsXPointerResolved;
    }

    public XPointerPart getXPointerPart() {
        return this.fXPointerPart;
    }

    private void reportError(String key, Object[] arguments) throws XNIException {
        throw new XNIException(this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/XPTR").formatMessage(this.fErrorReporter.getLocale(), key, arguments));
    }

    private void reportWarning(String key, Object[] arguments) throws XNIException {
        this.fXPointerErrorReporter.reportError("http://www.w3.org/TR/XPTR", key, arguments, (short)0);
    }

    protected void initErrorReporter() {
        if (this.fXPointerErrorReporter == null) {
            this.fXPointerErrorReporter = new XMLErrorReporter();
        }
        if (this.fErrorHandler == null) {
            this.fErrorHandler = new XPointerErrorHandler();
        }
        this.fXPointerErrorReporter.putMessageFormatter("http://www.w3.org/TR/XPTR", new XPointerMessageFormatter());
    }

    protected void init() {
        this.fXPointerParts.clear();
        this.fXPointerPart = null;
        this.fFoundMatchingPtrPart = false;
        this.fIsXPointerResolved = false;
        this.initErrorReporter();
    }

    public ArrayList getPointerParts() {
        return this.fXPointerParts;
    }

    @Override
    public void comment(XMLString text, Augmentations augs) throws XNIException {
        if (!this.isChildFragmentResolved()) {
            return;
        }
        super.comment(text, augs);
    }

    @Override
    public void processingInstruction(String target, XMLString data, Augmentations augs) throws XNIException {
        if (!this.isChildFragmentResolved()) {
            return;
        }
        super.processingInstruction(target, data, augs);
    }

    @Override
    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        if (!this.resolveXPointer(element, attributes, augs, 0)) {
            if (this.fFixupBase) {
                this.processXMLBaseAttributes(attributes);
            }
            if (this.fFixupLang) {
                this.processXMLLangAttributes(attributes);
            }
            this.fNamespaceContext.setContextInvalid();
            return;
        }
        super.startElement(element, attributes, augs);
    }

    @Override
    public void emptyElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
        if (!this.resolveXPointer(element, attributes, augs, 2)) {
            if (this.fFixupBase) {
                this.processXMLBaseAttributes(attributes);
            }
            if (this.fFixupLang) {
                this.processXMLLangAttributes(attributes);
            }
            this.fNamespaceContext.setContextInvalid();
            return;
        }
        super.emptyElement(element, attributes, augs);
    }

    @Override
    public void characters(XMLString text, Augmentations augs) throws XNIException {
        if (!this.isChildFragmentResolved()) {
            return;
        }
        super.characters(text, augs);
    }

    @Override
    public void ignorableWhitespace(XMLString text, Augmentations augs) throws XNIException {
        if (!this.isChildFragmentResolved()) {
            return;
        }
        super.ignorableWhitespace(text, augs);
    }

    @Override
    public void endElement(QName element, Augmentations augs) throws XNIException {
        if (!this.resolveXPointer(element, null, augs, 1)) {
            return;
        }
        super.endElement(element, augs);
    }

    @Override
    public void startCDATA(Augmentations augs) throws XNIException {
        if (!this.isChildFragmentResolved()) {
            return;
        }
        super.startCDATA(augs);
    }

    @Override
    public void endCDATA(Augmentations augs) throws XNIException {
        if (!this.isChildFragmentResolved()) {
            return;
        }
        super.endCDATA(augs);
    }

    @Override
    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        if (propertyId == "http://apache.org/xml/properties/internal/error-reporter") {
            this.fXPointerErrorReporter = value != null ? (XMLErrorReporter)value : null;
        }
        if (propertyId == "http://apache.org/xml/properties/internal/error-handler") {
            this.fErrorHandler = value != null ? (XMLErrorHandler)value : null;
        }
        if (propertyId == "http://apache.org/xml/features/xinclude/fixup-language") {
            this.fFixupLang = value != null ? (Boolean)value : false;
        }
        if (propertyId == "http://apache.org/xml/features/xinclude/fixup-base-uris") {
            this.fFixupBase = value != null ? (Boolean)value : false;
        }
        if (propertyId == "http://apache.org/xml/properties/internal/namespace-context") {
            this.fNamespaceContext = (XIncludeNamespaceSupport)value;
        }
        super.setProperty(propertyId, value);
    }

    private class Scanner {
        private static final byte CHARTYPE_INVALID = 0;
        private static final byte CHARTYPE_OTHER = 1;
        private static final byte CHARTYPE_WHITESPACE = 2;
        private static final byte CHARTYPE_CARRET = 3;
        private static final byte CHARTYPE_OPEN_PAREN = 4;
        private static final byte CHARTYPE_CLOSE_PAREN = 5;
        private static final byte CHARTYPE_MINUS = 6;
        private static final byte CHARTYPE_PERIOD = 7;
        private static final byte CHARTYPE_SLASH = 8;
        private static final byte CHARTYPE_DIGIT = 9;
        private static final byte CHARTYPE_COLON = 10;
        private static final byte CHARTYPE_EQUAL = 11;
        private static final byte CHARTYPE_LETTER = 12;
        private static final byte CHARTYPE_UNDERSCORE = 13;
        private static final byte CHARTYPE_NONASCII = 14;
        private final byte[] fASCIICharMap;
        private SymbolTable fSymbolTable;

        private Scanner(SymbolTable symbolTable) {
            byte[] byArray = new byte[128];
            byArray[9] = 2;
            byArray[10] = 2;
            byArray[13] = 2;
            byArray[32] = 2;
            byArray[33] = 1;
            byArray[34] = 1;
            byArray[35] = 1;
            byArray[36] = 1;
            byArray[37] = 1;
            byArray[38] = 1;
            byArray[39] = 1;
            byArray[40] = 4;
            byArray[41] = 5;
            byArray[42] = 1;
            byArray[43] = 1;
            byArray[44] = 1;
            byArray[45] = 6;
            byArray[46] = 7;
            byArray[47] = 8;
            byArray[48] = 9;
            byArray[49] = 9;
            byArray[50] = 9;
            byArray[51] = 9;
            byArray[52] = 9;
            byArray[53] = 9;
            byArray[54] = 9;
            byArray[55] = 9;
            byArray[56] = 9;
            byArray[57] = 9;
            byArray[58] = 10;
            byArray[59] = 1;
            byArray[60] = 1;
            byArray[61] = 11;
            byArray[62] = 1;
            byArray[63] = 1;
            byArray[64] = 1;
            byArray[65] = 12;
            byArray[66] = 12;
            byArray[67] = 12;
            byArray[68] = 12;
            byArray[69] = 12;
            byArray[70] = 12;
            byArray[71] = 12;
            byArray[72] = 12;
            byArray[73] = 12;
            byArray[74] = 12;
            byArray[75] = 12;
            byArray[76] = 12;
            byArray[77] = 12;
            byArray[78] = 12;
            byArray[79] = 12;
            byArray[80] = 12;
            byArray[81] = 12;
            byArray[82] = 12;
            byArray[83] = 12;
            byArray[84] = 12;
            byArray[85] = 12;
            byArray[86] = 12;
            byArray[87] = 12;
            byArray[88] = 12;
            byArray[89] = 12;
            byArray[90] = 12;
            byArray[91] = 1;
            byArray[92] = 1;
            byArray[93] = 1;
            byArray[94] = 3;
            byArray[95] = 13;
            byArray[96] = 1;
            byArray[97] = 12;
            byArray[98] = 12;
            byArray[99] = 12;
            byArray[100] = 12;
            byArray[101] = 12;
            byArray[102] = 12;
            byArray[103] = 12;
            byArray[104] = 12;
            byArray[105] = 12;
            byArray[106] = 12;
            byArray[107] = 12;
            byArray[108] = 12;
            byArray[109] = 12;
            byArray[110] = 12;
            byArray[111] = 12;
            byArray[112] = 12;
            byArray[113] = 12;
            byArray[114] = 12;
            byArray[115] = 12;
            byArray[116] = 12;
            byArray[117] = 12;
            byArray[118] = 12;
            byArray[119] = 12;
            byArray[120] = 12;
            byArray[121] = 12;
            byArray[122] = 12;
            byArray[123] = 1;
            byArray[124] = 1;
            byArray[125] = 1;
            byArray[126] = 1;
            byArray[127] = 1;
            this.fASCIICharMap = byArray;
            this.fSymbolTable = symbolTable;
        }

        private boolean scanExpr(SymbolTable symbolTable, Tokens tokens, String data, int currentOffset, int endOffset) throws XNIException {
            int openParen = 0;
            int closeParen = 0;
            boolean isQName = false;
            String name = null;
            String prefix = null;
            String schemeData = null;
            StringBuffer schemeDataBuff = new StringBuffer();
            block5: while (currentOffset != endOffset) {
                int ch = data.charAt(currentOffset);
                while (ch == 32 || ch == 10 || ch == 9 || ch == 13) {
                    if (++currentOffset == endOffset) break;
                    ch = data.charAt(currentOffset);
                }
                if (currentOffset == endOffset) break;
                int chartype = ch >= 128 ? 14 : this.fASCIICharMap[ch];
                switch (chartype) {
                    case 4: {
                        this.addToken(tokens, 0);
                        ++openParen;
                        ++currentOffset;
                        continue block5;
                    }
                    case 5: {
                        this.addToken(tokens, 1);
                        ++closeParen;
                        ++currentOffset;
                        continue block5;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: {
                        if (openParen == 0) {
                            int nameOffset = currentOffset;
                            if ((currentOffset = this.scanNCName(data, endOffset, currentOffset)) == nameOffset) {
                                XPointerHandler.this.reportError("InvalidShortHandPointer", new Object[]{data});
                                return false;
                            }
                            ch = currentOffset < endOffset ? (int)data.charAt(currentOffset) : -1;
                            name = symbolTable.addSymbol(data.substring(nameOffset, currentOffset));
                            prefix = XMLSymbols.EMPTY_STRING;
                            if (ch == 58) {
                                if (++currentOffset == endOffset) {
                                    return false;
                                }
                                ch = data.charAt(currentOffset);
                                prefix = name;
                                nameOffset = currentOffset;
                                if ((currentOffset = this.scanNCName(data, endOffset, currentOffset)) == nameOffset) {
                                    return false;
                                }
                                ch = currentOffset < endOffset ? (int)data.charAt(currentOffset) : -1;
                                isQName = true;
                                name = symbolTable.addSymbol(data.substring(nameOffset, currentOffset));
                            }
                            if (currentOffset != endOffset) {
                                this.addToken(tokens, 3);
                                tokens.addToken(prefix);
                                tokens.addToken(name);
                                isQName = false;
                            } else if (currentOffset == endOffset) {
                                this.addToken(tokens, 2);
                                tokens.addToken(name);
                                isQName = false;
                            }
                            closeParen = 0;
                            continue block5;
                        }
                        if (openParen > 0 && closeParen == 0 && name != null) {
                            int dataOffset = currentOffset;
                            if ((currentOffset = this.scanData(data, schemeDataBuff, endOffset, currentOffset)) == dataOffset) {
                                XPointerHandler.this.reportError("InvalidSchemeDataInXPointer", new Object[]{data});
                                return false;
                            }
                            ch = currentOffset < endOffset ? (int)data.charAt(currentOffset) : -1;
                            schemeData = symbolTable.addSymbol(schemeDataBuff.toString());
                            this.addToken(tokens, 4);
                            tokens.addToken(schemeData);
                            openParen = 0;
                            schemeDataBuff.delete(0, schemeDataBuff.length());
                            continue block5;
                        }
                        return false;
                    }
                }
            }
            return true;
        }

        /*
         * Unable to fully structure code
         */
        private int scanNCName(String data, int endOffset, int currentOffset) {
            ch = data.charAt(currentOffset);
            if (!(ch >= '\u0080' ? XMLChar.isNameStart(ch) == false : (chartype = this.fASCIICharMap[ch]) != 12 && chartype != 13)) ** GOTO lbl-1000
            return currentOffset;
            while (!((ch = data.charAt(currentOffset)) < '\u0080' ? (chartype = this.fASCIICharMap[ch]) != 12 && chartype != 9 && chartype != 7 && chartype != 6 && chartype != 13 : XMLChar.isName(ch) == false)) lbl-1000:
            // 2 sources

            {
                if (++currentOffset < endOffset) continue;
            }
            return currentOffset;
        }

        private int scanData(String data, StringBuffer schemeData, int endOffset, int currentOffset) {
            while (currentOffset != endOffset) {
                int chartype;
                char ch = data.charAt(currentOffset);
                int n = chartype = ch >= '\u0080' ? 14 : this.fASCIICharMap[ch];
                if (chartype == 4) {
                    schemeData.append((int)ch);
                    ++currentOffset;
                    currentOffset = this.scanData(data, schemeData, endOffset, currentOffset);
                    if (currentOffset == endOffset) {
                        return currentOffset;
                    }
                    ch = data.charAt(currentOffset);
                    int n2 = chartype = ch >= '\u0080' ? 14 : this.fASCIICharMap[ch];
                    if (chartype != 5) {
                        return endOffset;
                    }
                    schemeData.append(ch);
                    ++currentOffset;
                    continue;
                }
                if (chartype == 5) {
                    return currentOffset;
                }
                if (chartype == 3) {
                    int n3 = chartype = (ch = data.charAt(++currentOffset)) >= '\u0080' ? 14 : this.fASCIICharMap[ch];
                    if (chartype != 3 && chartype != 4 && chartype != 5) break;
                    schemeData.append(ch);
                    ++currentOffset;
                    continue;
                }
                schemeData.append(ch);
                ++currentOffset;
            }
            return currentOffset;
        }

        protected void addToken(Tokens tokens, int token) throws XNIException {
            tokens.addToken(token);
        }
    }

    private final class Tokens {
        private static final int XPTRTOKEN_OPEN_PAREN = 0;
        private static final int XPTRTOKEN_CLOSE_PAREN = 1;
        private static final int XPTRTOKEN_SHORTHAND = 2;
        private static final int XPTRTOKEN_SCHEMENAME = 3;
        private static final int XPTRTOKEN_SCHEMEDATA = 4;
        private final String[] fgTokenNames = new String[]{"XPTRTOKEN_OPEN_PAREN", "XPTRTOKEN_CLOSE_PAREN", "XPTRTOKEN_SHORTHAND", "XPTRTOKEN_SCHEMENAME", "XPTRTOKEN_SCHEMEDATA"};
        private static final int INITIAL_TOKEN_COUNT = 256;
        private int[] fTokens = new int[256];
        private int fTokenCount = 0;
        private int fCurrentTokenIndex;
        private SymbolTable fSymbolTable;
        private HashMap fTokenNames = new HashMap();

        private Tokens(SymbolTable symbolTable) {
            this.fSymbolTable = symbolTable;
            this.fTokenNames.put(new Integer(0), "XPTRTOKEN_OPEN_PAREN");
            this.fTokenNames.put(new Integer(1), "XPTRTOKEN_CLOSE_PAREN");
            this.fTokenNames.put(new Integer(2), "XPTRTOKEN_SHORTHAND");
            this.fTokenNames.put(new Integer(3), "XPTRTOKEN_SCHEMENAME");
            this.fTokenNames.put(new Integer(4), "XPTRTOKEN_SCHEMEDATA");
        }

        private String getTokenString(int token) {
            return (String)this.fTokenNames.get(new Integer(token));
        }

        private void addToken(String tokenStr) {
            Integer tokenInt = (Integer)this.fTokenNames.get(tokenStr);
            if (tokenInt == null) {
                tokenInt = new Integer(this.fTokenNames.size());
                this.fTokenNames.put(tokenInt, tokenStr);
            }
            this.addToken(tokenInt);
        }

        private void addToken(int token) {
            try {
                this.fTokens[this.fTokenCount] = token;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                int[] oldList = this.fTokens;
                this.fTokens = new int[this.fTokenCount << 1];
                System.arraycopy(oldList, 0, this.fTokens, 0, this.fTokenCount);
                this.fTokens[this.fTokenCount] = token;
            }
            ++this.fTokenCount;
        }

        private void rewind() {
            this.fCurrentTokenIndex = 0;
        }

        private boolean hasMore() {
            return this.fCurrentTokenIndex < this.fTokenCount;
        }

        private int nextToken() throws XNIException {
            if (this.fCurrentTokenIndex == this.fTokenCount) {
                XPointerHandler.this.reportError("XPointerProcessingError", null);
            }
            return this.fTokens[this.fCurrentTokenIndex++];
        }

        private int peekToken() throws XNIException {
            if (this.fCurrentTokenIndex == this.fTokenCount) {
                XPointerHandler.this.reportError("XPointerProcessingError", null);
            }
            return this.fTokens[this.fCurrentTokenIndex];
        }

        private String nextTokenAsString() throws XNIException {
            String tokenStrint = this.getTokenString(this.nextToken());
            if (tokenStrint == null) {
                XPointerHandler.this.reportError("XPointerProcessingError", null);
            }
            return tokenStrint;
        }
    }
}

