/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.util.Stack;
import org.apache.bcel.classfile.AnnotationDefault;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Annotations;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.BootstrapMethods;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantDouble;
import org.apache.bcel.classfile.ConstantDynamic;
import org.apache.bcel.classfile.ConstantFieldref;
import org.apache.bcel.classfile.ConstantFloat;
import org.apache.bcel.classfile.ConstantInteger;
import org.apache.bcel.classfile.ConstantInterfaceMethodref;
import org.apache.bcel.classfile.ConstantInvokeDynamic;
import org.apache.bcel.classfile.ConstantLong;
import org.apache.bcel.classfile.ConstantMethodHandle;
import org.apache.bcel.classfile.ConstantMethodType;
import org.apache.bcel.classfile.ConstantMethodref;
import org.apache.bcel.classfile.ConstantModule;
import org.apache.bcel.classfile.ConstantNameAndType;
import org.apache.bcel.classfile.ConstantPackage;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantString;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.Deprecated;
import org.apache.bcel.classfile.EnclosingMethod;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.InnerClass;
import org.apache.bcel.classfile.InnerClasses;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.LocalVariableTypeTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.MethodParameter;
import org.apache.bcel.classfile.MethodParameters;
import org.apache.bcel.classfile.Module;
import org.apache.bcel.classfile.ModuleExports;
import org.apache.bcel.classfile.ModuleMainClass;
import org.apache.bcel.classfile.ModuleOpens;
import org.apache.bcel.classfile.ModulePackages;
import org.apache.bcel.classfile.ModuleProvides;
import org.apache.bcel.classfile.ModuleRequires;
import org.apache.bcel.classfile.NestHost;
import org.apache.bcel.classfile.NestMembers;
import org.apache.bcel.classfile.ParameterAnnotationEntry;
import org.apache.bcel.classfile.ParameterAnnotations;
import org.apache.bcel.classfile.Signature;
import org.apache.bcel.classfile.SourceFile;
import org.apache.bcel.classfile.StackMap;
import org.apache.bcel.classfile.StackMapEntry;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.classfile.Unknown;
import org.apache.bcel.classfile.Visitor;

public class DescendingVisitor
implements Visitor {
    private final JavaClass clazz;
    private final Visitor visitor;
    private final Stack<Object> stack = new Stack();

    public Object predecessor() {
        return this.predecessor(0);
    }

    public Object predecessor(int level) {
        int size = this.stack.size();
        if (size < 2 || level < 0) {
            return null;
        }
        return this.stack.elementAt(size - (level + 2));
    }

    public Object current() {
        return this.stack.peek();
    }

    public DescendingVisitor(JavaClass clazz, Visitor visitor) {
        this.clazz = clazz;
        this.visitor = visitor;
    }

    public void visit() {
        this.clazz.accept(this);
    }

    @Override
    public void visitJavaClass(JavaClass _clazz) {
        Attribute[] attributes;
        Method[] methods;
        Field[] fields;
        this.stack.push(_clazz);
        _clazz.accept(this.visitor);
        Field[] fieldArray = fields = _clazz.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            field.accept(this);
            ++n2;
        }
        Method[] methodArray = methods = _clazz.getMethods();
        int n3 = methods.length;
        n = 0;
        while (n < n3) {
            Method method = methodArray[n];
            method.accept(this);
            ++n;
        }
        Attribute[] attributeArray = attributes = _clazz.getAttributes();
        int n4 = attributes.length;
        n3 = 0;
        while (n3 < n4) {
            Attribute attribute = attributeArray[n3];
            attribute.accept(this);
            ++n3;
        }
        _clazz.getConstantPool().accept(this);
        this.stack.pop();
    }

    @Override
    public void visitAnnotation(Annotations annotation) {
        AnnotationEntry[] entries;
        this.stack.push(annotation);
        annotation.accept(this.visitor);
        AnnotationEntry[] annotationEntryArray = entries = annotation.getAnnotationEntries();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            AnnotationEntry entrie = annotationEntryArray[n2];
            entrie.accept(this);
            ++n2;
        }
        this.stack.pop();
    }

    @Override
    public void visitAnnotationEntry(AnnotationEntry annotationEntry) {
        this.stack.push(annotationEntry);
        annotationEntry.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitField(Field field) {
        Attribute[] attributes;
        this.stack.push(field);
        field.accept(this.visitor);
        Attribute[] attributeArray = attributes = field.getAttributes();
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            attribute.accept(this);
            ++n2;
        }
        this.stack.pop();
    }

    @Override
    public void visitConstantValue(ConstantValue cv) {
        this.stack.push(cv);
        cv.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitMethod(Method method) {
        Attribute[] attributes;
        this.stack.push(method);
        method.accept(this.visitor);
        Attribute[] attributeArray = attributes = method.getAttributes();
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = attributeArray[n2];
            attribute.accept(this);
            ++n2;
        }
        this.stack.pop();
    }

    @Override
    public void visitExceptionTable(ExceptionTable table) {
        this.stack.push(table);
        table.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitCode(Code code) {
        Attribute[] attributes;
        CodeException[] table;
        this.stack.push(code);
        code.accept(this.visitor);
        CodeException[] codeExceptionArray = table = code.getExceptionTable();
        int n = table.length;
        int n2 = 0;
        while (n2 < n) {
            CodeException element = codeExceptionArray[n2];
            element.accept(this);
            ++n2;
        }
        Attribute[] attributeArray = attributes = code.getAttributes();
        int n3 = attributes.length;
        n = 0;
        while (n < n3) {
            Attribute attribute = attributeArray[n];
            attribute.accept(this);
            ++n;
        }
        this.stack.pop();
    }

    @Override
    public void visitCodeException(CodeException ce) {
        this.stack.push(ce);
        ce.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitLineNumberTable(LineNumberTable table) {
        LineNumber[] numbers;
        this.stack.push(table);
        table.accept(this.visitor);
        LineNumber[] lineNumberArray = numbers = table.getLineNumberTable();
        int n = numbers.length;
        int n2 = 0;
        while (n2 < n) {
            LineNumber number = lineNumberArray[n2];
            number.accept(this);
            ++n2;
        }
        this.stack.pop();
    }

    @Override
    public void visitLineNumber(LineNumber number) {
        this.stack.push(number);
        number.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitLocalVariableTable(LocalVariableTable table) {
        LocalVariable[] vars;
        this.stack.push(table);
        table.accept(this.visitor);
        LocalVariable[] localVariableArray = vars = table.getLocalVariableTable();
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            LocalVariable var = localVariableArray[n2];
            var.accept(this);
            ++n2;
        }
        this.stack.pop();
    }

    @Override
    public void visitStackMap(StackMap table) {
        StackMapEntry[] vars;
        this.stack.push(table);
        table.accept(this.visitor);
        StackMapEntry[] stackMapEntryArray = vars = table.getStackMap();
        int n = vars.length;
        int n2 = 0;
        while (n2 < n) {
            StackMapEntry var = stackMapEntryArray[n2];
            var.accept(this);
            ++n2;
        }
        this.stack.pop();
    }

    @Override
    public void visitStackMapEntry(StackMapEntry var) {
        this.stack.push(var);
        var.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitLocalVariable(LocalVariable var) {
        this.stack.push(var);
        var.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantPool(ConstantPool cp) {
        this.stack.push(cp);
        cp.accept(this.visitor);
        Constant[] constants = cp.getConstantPool();
        int i = 1;
        while (i < constants.length) {
            if (constants[i] != null) {
                constants[i].accept(this);
            }
            ++i;
        }
        this.stack.pop();
    }

    @Override
    public void visitConstantClass(ConstantClass constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantDouble(ConstantDouble constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantFieldref(ConstantFieldref constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantFloat(ConstantFloat constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantInteger(ConstantInteger constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantInterfaceMethodref(ConstantInterfaceMethodref constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantInvokeDynamic(ConstantInvokeDynamic constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantLong(ConstantLong constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantMethodref(ConstantMethodref constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantNameAndType(ConstantNameAndType constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantString(ConstantString constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantUtf8(ConstantUtf8 constant) {
        this.stack.push(constant);
        constant.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitInnerClasses(InnerClasses ic) {
        InnerClass[] ics;
        this.stack.push(ic);
        ic.accept(this.visitor);
        InnerClass[] innerClassArray = ics = ic.getInnerClasses();
        int n = ics.length;
        int n2 = 0;
        while (n2 < n) {
            InnerClass ic2 = innerClassArray[n2];
            ic2.accept(this);
            ++n2;
        }
        this.stack.pop();
    }

    @Override
    public void visitInnerClass(InnerClass inner) {
        this.stack.push(inner);
        inner.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitBootstrapMethods(BootstrapMethods bm) {
        this.stack.push(bm);
        bm.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitDeprecated(Deprecated attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitSignature(Signature attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitSourceFile(SourceFile attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitSynthetic(Synthetic attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitUnknown(Unknown attribute) {
        this.stack.push(attribute);
        attribute.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitAnnotationDefault(AnnotationDefault obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitEnclosingMethod(EnclosingMethod obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitLocalVariableTypeTable(LocalVariableTypeTable obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitParameterAnnotation(ParameterAnnotations obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitMethodParameters(MethodParameters obj) {
        MethodParameter[] table;
        this.stack.push(obj);
        obj.accept(this.visitor);
        MethodParameter[] methodParameterArray = table = obj.getParameters();
        int n = table.length;
        int n2 = 0;
        while (n2 < n) {
            MethodParameter element = methodParameterArray[n2];
            element.accept(this);
            ++n2;
        }
        this.stack.pop();
    }

    @Override
    public void visitMethodParameter(MethodParameter obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantMethodType(ConstantMethodType obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantMethodHandle(ConstantMethodHandle obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitParameterAnnotationEntry(ParameterAnnotationEntry obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantPackage(ConstantPackage obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantModule(ConstantModule obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitConstantDynamic(ConstantDynamic obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitModule(Module obj) {
        ModuleProvides[] ptable;
        ModuleOpens[] otable;
        ModuleExports[] etable;
        ModuleRequires[] rtable;
        this.stack.push(obj);
        obj.accept(this.visitor);
        ModuleRequires[] moduleRequiresArray = rtable = obj.getRequiresTable();
        int n = rtable.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleRequires element = moduleRequiresArray[n2];
            element.accept(this);
            ++n2;
        }
        ModuleExports[] moduleExportsArray = etable = obj.getExportsTable();
        int n3 = etable.length;
        n = 0;
        while (n < n3) {
            ModuleExports element = moduleExportsArray[n];
            element.accept(this);
            ++n;
        }
        ModuleOpens[] moduleOpensArray = otable = obj.getOpensTable();
        int n4 = otable.length;
        n3 = 0;
        while (n3 < n4) {
            ModuleOpens element = moduleOpensArray[n3];
            element.accept(this);
            ++n3;
        }
        ModuleProvides[] moduleProvidesArray = ptable = obj.getProvidesTable();
        int n5 = ptable.length;
        n4 = 0;
        while (n4 < n5) {
            ModuleProvides element = moduleProvidesArray[n4];
            element.accept(this);
            ++n4;
        }
        this.stack.pop();
    }

    @Override
    public void visitModuleRequires(ModuleRequires obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitModuleExports(ModuleExports obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitModuleOpens(ModuleOpens obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitModuleProvides(ModuleProvides obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitModulePackages(ModulePackages obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitModuleMainClass(ModuleMainClass obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitNestHost(NestHost obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }

    @Override
    public void visitNestMembers(NestMembers obj) {
        this.stack.push(obj);
        obj.accept(this.visitor);
        this.stack.pop();
    }
}

