/*
 * Decompiled with CFR 0.152.
 */
package ext.scf8.rmo;

import ext.base.log.BcLogUtil;
import ext.base.table.BcTableColumn;
import ext.base.table.BcTableContext;
import ext.lib.datasource.DtsSession;
import ext.lib.datasource.util.ScfMmdServerUtil;
import ext.lib.rmi.model.RmiRmoArgument;
import ext.lib.rmi.rmo.RmiAbstractRMO;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlStatement;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.scf3.rmo.ScfSqlUtil;
import ext.scf8.dao.KscfQueryColumnDAO;
import ext.scf8.model.KscfQueryColumn;
import java.util.ArrayList;
import java.util.List;

public class KscfQueryColumnRMO
extends RmiAbstractRMO {
    public void putQueryColumn(RmiRmoArgument rmoArg) throws Exception {
        List queryColumnList = (List)rmoArg.getRequest().getData();
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        int i = 0;
        while (i < queryColumnList.size()) {
            KscfQueryColumn queryColumn = (KscfQueryColumn)queryColumnList.get(i);
            KscfQueryColumnDAO.getInstance().putEntity(dtsSession, queryColumn);
            ++i;
        }
    }

    public void queryColumnList(RmiRmoArgument rmoArg) throws Exception {
        int queryId = rmoArg.getRequest().getDataAsInteger();
        DtsSession dtsSession = rmoArg.createDtsSession();
        SqlContext sqlContext = dtsSession.getSqlContext();
        StringBuilder query = new StringBuilder();
        ArrayList<String> columnNameList = new ArrayList<String>();
        columnNameList.add("frwk_query_column.column_name");
        columnNameList.add("frwk_query_column.view_index");
        query.append("SELECT " + SqlUtil.enumerateByCommma(columnNameList));
        query.append(" FROM frwk_query_column");
        query.append(" WHERE frwk_query_column.query_id = " + queryId);
        query.append(" ORDER BY frwk_query_column.column_name");
        BcLogUtil.debug("query=" + query);
        SqlStatement stmt = ScfSqlUtil.createStatement(dtsSession);
        try {
            SqlResultSet rs = stmt.executeQuery(query.toString());
            List<BcTableColumn> tableColumnList = ScfMmdServerUtil.createTableColumnList(dtsSession, rs.getMetaData(), columnNameList);
            BcTableContext tableContext = new BcTableContext();
            ScfSqlUtil.setRespons(dtsSession, rs, tableColumnList, tableContext, rmoArg);
        }
        catch (Exception ex) {
            stmt.close();
            throw ex;
        }
    }
}

