/*
 * Decompiled with CFR 0.152.
 */
package ext.scf6.fx;

import ext.base.core.BcNumberUtil;
import ext.base.log.BcLogUtil;
import ext.base.table.BcTableColumnModel;
import ext.base.table.BcTableContext;
import ext.base.util.BcWords;
import ext.lib.fx.control.FxButton;
import ext.lib.fx.control.FxTextField;
import ext.lib.fx.layout.FxDecoratePane;
import ext.lib.fx.util.FxImageHelper;
import ext.lib.fx.util.FxUtil;
import ext.lib.poi.PoiUtil;
import ext.module.dcmn.common.DcmcSimpleDocumentGenerator;
import ext.module.dcmn.stub.DcmnDocumentTemplateStub;
import ext.module.dcmn.swg.DcmnClientModule;
import ext.scf.util.ScfFileUtil;
import ext.scf4.fx.HfxExportWizard;
import ext.scf4.fx.TmpControler;
import ext.scf4.fx.TmpEvent;
import ext.scf4.table.ScfDisplayContext;
import ext.scf5.swg.IswgDocumentViewer;
import ext.scf6.fx.JfxDisplayContextPane;
import java.io.File;
import javafx.event.ActionEvent;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import javax.swing.table.TableModel;
import nlc.lib.doc.DcfBook;
import nlc.lib.doc.DcfPage;

public class JfxTableControlPane
extends FxDecoratePane {
    protected FxTextField textField = new FxTextField();
    protected Button refreshButton;
    protected Button exportButton;
    protected Button printButton;
    protected Button displaySettingButton;
    protected String title;
    protected int preFromIndex = -1;
    protected int preToIndex = -1;
    protected ScfDisplayContext displayContextOrigin;
    protected BcTableColumnModel swgTableColumnModel;
    protected TableModel swgTableModel;
    protected BcTableContext tableContext;
    int groupNumber = 0;
    TmpControler tmpControler;

    public JfxTableControlPane() throws Exception {
        this.setupControl();
    }

    protected void setupControl() throws Exception {
        this.getControlPane().setAlignmentPos(Pos.CENTER_LEFT);
        this.textField.setEditable(false);
        this.getControlPane().addControl(this.groupNumber, (Node)this.textField);
        this.refreshButton = new FxButton();
        this.refreshButton.setOnAction(this.actionEventHandler);
        this.refreshButton.setGraphic((Node)FxImageHelper.createImageView_icon("refresh_64x64.png"));
        this.refreshButton.setTooltip(new Tooltip(BcWords.getInstance().refresh));
        this.getControlPane().addControl(this.groupNumber, (Node)this.refreshButton);
        this.exportButton = new FxButton();
        this.exportButton.setOnAction(this.actionEventHandler);
        this.exportButton.setGraphic((Node)FxImageHelper.createImageView_icon("export_64x64.png"));
        this.exportButton.setTooltip(new Tooltip(BcWords.getInstance().export));
        this.getControlPane().addControl(this.groupNumber, (Node)this.exportButton);
        this.printButton = new FxButton();
        this.printButton.setOnAction(this.actionEventHandler);
        this.printButton.setGraphic((Node)FxImageHelper.createImageView_icon("printer_64x64.png"));
        this.printButton.setTooltip(new Tooltip(BcWords.getInstance().print));
        this.getControlPane().addControl(this.groupNumber, (Node)this.printButton);
    }

    public void setData(BcTableColumnModel swgTableColumnModel, TableModel swgTableModel, BcTableContext tableContext) throws Exception {
        BcLogUtil.debug("######### setData:swgTableModel=" + swgTableModel + "this.hashCode()=" + ((Object)((Object)this)).hashCode());
        this.swgTableColumnModel = swgTableColumnModel;
        this.swgTableModel = swgTableModel;
        this.tableContext = tableContext;
        if (tableContext != null) {
            this.setTitle(tableContext.tableName);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.refreshButton) {
            TmpEvent tmpEvent = new TmpEvent((Object)this, 1);
            this.tmpControler.reload(tmpEvent);
        } else if (ev.getSource() == this.exportButton) {
            String filePath = ScfFileUtil.createFilePath(this.getTitle());
            HfxExportWizard exportWizard = new HfxExportWizard();
            exportWizard.setCondition(PoiUtil.createExportCondition(), this.swgTableColumnModel, this.swgTableModel, new File(filePath));
            exportWizard.show(this.getScene().getWindow());
        } else if (ev.getSource() == this.printButton) {
            this.printButtonAction();
        } else if (ev.getSource() == this.displaySettingButton) {
            this.displaySettingButtonAction();
        }
    }

    public void setDisplaySettingButton(boolean disp) throws Exception {
        if (disp) {
            if (this.displaySettingButton == null) {
                this.displaySettingButton = new FxButton();
                this.displaySettingButton.setOnAction(this.actionEventHandler);
                this.displaySettingButton.setGraphic((Node)FxImageHelper.createImageView_icon("gear_64x64.png"));
                this.displaySettingButton.setTooltip(new Tooltip(BcWords.getInstance().configuration));
                this.getControlPane().addControl(this.groupNumber, (Node)this.displaySettingButton);
            }
        } else if (this.displaySettingButton != null) {
            this.getControlPane().removeControl((Node)this.displaySettingButton);
        }
    }

    protected void displaySettingButtonAction() throws Exception {
        JfxDisplayContextPane displayContextPane = new JfxDisplayContextPane();
        displayContextPane.tableDisplayContextPanel.setTargetData(this.swgTableColumnModel, this.tableContext.title, this.displayContextOrigin);
        ScfDisplayContext displayContext = displayContextPane.show(FxUtil.getWindow((Node)this));
        if (displayContext != null) {
            TmpEvent tmpEvent = new TmpEvent((Object)this, 2);
            tmpEvent.userObject = displayContext;
            this.tmpControler.reload(tmpEvent);
        }
    }

    protected void printButtonAction() throws Exception {
        DcfPage templatePage = DcmnDocumentTemplateStub.getInstance().getDocForm("general_table.dfm");
        DcmcSimpleDocumentGenerator documentGenerator = new DcmcSimpleDocumentGenerator();
        documentGenerator.setTemplatePage(templatePage);
        DcfBook dcfBook = documentGenerator.doGenerate(this.swgTableModel, this.swgTableColumnModel, this.tableContext, DcmnClientModule.getInstance().getReplaceProperties());
        IswgDocumentViewer.printPreview_v1(dcfBook, this.tableContext.title);
    }

    public void setTmpControler(TmpControler tmpControler) {
        this.tmpControler = tmpControler;
        tmpControler.rowCountProperty.addListener((observable, oldValue, newValue) -> {
            String str = null;
            try {
                str = String.valueOf(BcNumberUtil.toString(newValue)) + " \u4ef6";
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
            this.textField.setText(str);
        });
    }
}

