/*
 * Decompiled with CFR 0.152.
 */
package ext.scf5.dao;

import ext.base.mmd.MmdField;
import ext.base.mmd.MmdIndex;
import ext.base.mmd.MmdIndexElement;
import ext.base.mmd.MmdModel;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlConnection;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectSql;
import ext.scf5.model.ScfSchemaVersion;

public class ScfSchemaVersionDAO
extends OrmAbstractDAO<ScfSchemaVersion> {
    private ScfSchemaVersionDAO() {
        super(new ScfSchemaVersion[0]);
        this.setTableName("frwk_version");
    }

    public static ScfSchemaVersionDAO getInstance() {
        return SingletonHolder.instance;
    }

    public ScfSchemaVersion getLatest(DtsSession dtsSession) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlSelectSql selectSql = new SqlSelectSql();
        selectSql.getSelectColumnList().addAll(this.getColumnNameList(null));
        selectSql.setFromClause(this.tableName);
        selectSql.getOrderByList().add("version_id DESC");
        selectSql.rowLimit = 1;
        String sql = sqlContext.buildSelectSql(selectSql);
        return (ScfSchemaVersion)this.getEntity(dtsSession, sql);
    }

    public boolean existTable(DtsSession dtsSession) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        return sqlContext.existTable(dtsSession.getConnection(), this.getTableName());
    }

    public void createTable(SqlContext sqlContext, SqlConnection dbCon) throws Exception {
        MmdModel mmdModel = new MmdModel();
        mmdModel.tableName = this.getTableName();
        MmdField mmdField = new MmdField();
        mmdField.columnName = "version_id";
        mmdField.sqlTypeId = 4;
        mmdModel.addField(mmdField);
        mmdField = new MmdField();
        mmdField.columnName = "update_start_timestamp";
        mmdField.sqlTypeId = 93;
        mmdModel.addField(mmdField);
        mmdField = new MmdField();
        mmdField.columnName = "update_end_timestamp";
        mmdField.sqlTypeId = 93;
        mmdModel.addField(mmdField);
        MmdIndex mmdIndex = new MmdIndex();
        mmdIndex.name = String.valueOf(this.tableName) + "__k01";
        MmdIndexElement indexElement = new MmdIndexElement(mmdModel.getField((int)0).columnName, 1, true);
        mmdIndex.indexElementList.add(indexElement);
        mmdModel.primaryIndexName = mmdIndex.name;
        sqlContext.createTable(dbCon, mmdModel, this.getLogger());
        sqlContext.createIndex(dbCon, mmdModel, this.getLogger());
    }

    public void createTable(DtsSession dtsSession) throws Exception {
        this.createTable(dtsSession.getSqlContext(), dtsSession.getConnection());
    }

    /* synthetic */ ScfSchemaVersionDAO(ScfSchemaVersionDAO scfSchemaVersionDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final ScfSchemaVersionDAO instance = new ScfSchemaVersionDAO(null);

        private SingletonHolder() {
        }
    }
}

