/*
 * Decompiled with CFR 0.152.
 */
package ext.scf4.fx;

import ext.base.core.BcStringUtil;
import ext.base.util.BcInputValidator;
import ext.base.util.BcMessageCreator;
import ext.base.util.BcResult;
import ext.base.util.BcWords;
import ext.lib.fx.control.FxButton;
import ext.lib.fx.control.FxCheckBox;
import ext.lib.fx.control.FxComboBox;
import ext.lib.fx.control.FxLabel;
import ext.lib.fx.control.FxTextField;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.util.FxUtil;
import ext.lib.poi.PoiConstants;
import ext.lib.poi.PoiExportCondition;
import ext.lib.poi.PoiUtil;
import ext.scf4.fx.HfxExportWizard;
import ext.scf4.fx.XdtsWizardPane;
import java.io.File;
import java.util.Locale;
import javafx.event.ActionEvent;
import javafx.scene.Node;
import javafx.stage.FileChooser;

class HfxExportConditionPane
extends XdtsWizardPane {
    protected FxFlowPane centerPane = new FxFlowPane(11);
    protected FxTextField filePathField = new FxTextField();
    protected FxButton fileChooseButton;
    protected FileChooser fileChooser;
    protected FxComboBox<String> formatTypeCombo;
    protected FxComboBox<String> fieldSeparatorCombo;
    protected FxComboBox<String> lineSeparatorCombo;
    protected FxComboBox quotationMarkPolicyCombo;
    protected FxCheckBox headerEnabledCheckBox;
    protected FxComboBox<String> encodingCombo;
    protected FxLabel bomLabel;
    protected FxCheckBox bomCheckBox;
    protected FxCheckBox codeMapCheckBox;
    protected FxCheckBox notVisibleCheckBox;
    protected PoiExportCondition exportCondition;
    protected HfxExportWizard wizard;

    public HfxExportConditionPane(HfxExportWizard wizard) throws Exception {
        this.fileChooseButton = new FxButton(BcWords.getInstance().browse);
        this.fileChooser = new FileChooser();
        this.formatTypeCombo = new FxComboBox();
        this.fieldSeparatorCombo = new FxComboBox();
        this.lineSeparatorCombo = new FxComboBox();
        this.quotationMarkPolicyCombo = new FxComboBox();
        this.headerEnabledCheckBox = new FxCheckBox();
        this.encodingCombo = new FxComboBox();
        this.bomLabel = new FxLabel(BcWords.getInstance().bom);
        this.bomCheckBox = new FxCheckBox();
        this.codeMapCheckBox = new FxCheckBox();
        this.notVisibleCheckBox = new FxCheckBox();
        this.wizard = wizard;
        this.setComponant();
        FxUtil.defaultInitialize((Node)this);
    }

    protected void setComponant() throws Exception {
        this.mainDecoratePane.setCenter((Node)this.centerPane);
        this.filePathField.setPrefColumnCount(40);
        this.fileChooseButton.setOnAction(this.actionEventHandler);
        FxNodeUnit controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().destination), new Node[]{this.filePathField, this.fileChooseButton});
        this.centerPane.addNodeUnit(controlUnit);
        this.formatTypeCombo.getItems().add((Object)BcWords.getInstance().CSV);
        controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().format), new Node[]{this.formatTypeCombo});
        Enum[] enumArray = PoiConstants.FieldSeparator.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            PoiConstants.FieldSeparator fieldSeparator = enumArray[n2];
            this.fieldSeparatorCombo.getItems().add((Object)fieldSeparator.note);
            ++n2;
        }
        controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().fieldSeparator), new Node[]{this.fieldSeparatorCombo});
        this.centerPane.addNodeUnit(controlUnit);
        enumArray = BcStringUtil.LineSeparator.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum lineSeparator = enumArray[n2];
            this.lineSeparatorCombo.getItems().add((Object)((BcStringUtil.LineSeparator)lineSeparator).note);
            ++n2;
        }
        controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().lineSeparator), new Node[]{this.lineSeparatorCombo});
        this.centerPane.addNodeUnit(controlUnit);
        this.quotationMarkPolicyCombo.getItems().add((Object)PoiConstants.QuotationMarkPolicy.necessary.note);
        this.quotationMarkPolicyCombo.getItems().add((Object)PoiConstants.QuotationMarkPolicy.always.note);
        controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().quotationMark), new Node[]{this.quotationMarkPolicyCombo});
        this.centerPane.addNodeUnit(controlUnit);
        controlUnit = new FxNodeUnit((Node)new FxLabel("\u30d8\u30c3\u30c0\u51fa\u529b"), new Node[]{this.headerEnabledCheckBox});
        this.centerPane.addNodeUnit(controlUnit);
        int i = 0;
        while (i < PoiUtil.charsetListDefault.size()) {
            String charsetName = PoiUtil.charsetListDefault.get(i);
            this.encodingCombo.getItems().add((Object)charsetName);
            ++i;
        }
        this.encodingCombo.setOnAction(this.actionEventHandler);
        this.bomSetting();
        controlUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().encoding), new Node[]{this.encodingCombo});
        this.centerPane.addNodeUnit(controlUnit);
        controlUnit = new FxNodeUnit((Node)this.bomLabel, new Node[]{this.bomCheckBox});
        this.centerPane.addNodeUnit(controlUnit);
        controlUnit = new FxNodeUnit((Node)new FxLabel("\u5b9a\u6570\u5909\u63db"), new Node[]{this.codeMapCheckBox});
        this.centerPane.addNodeUnit(controlUnit);
        controlUnit = new FxNodeUnit((Node)new FxLabel("\u4e0d\u53ef\u8996\u5217\u51fa\u529b"), new Node[]{this.notVisibleCheckBox});
        this.centerPane.addNodeUnit(controlUnit);
        this.nextButton.setText(BcWords.getInstance().execute);
        this.nextButton.setVisible(true);
        this.cancelButton.setVisible(true);
    }

    public void bomSetting() {
        boolean isUtf8 = BcStringUtil.equalsIgnoreCase((CharSequence)this.encodingCombo.getValue(), "UTF-8");
        this.bomCheckBox.setDisable(!isUtf8);
        this.bomLabel.setDisable(!isUtf8);
    }

    public void setDataModel(PoiExportCondition exportCondition) throws Exception {
        this.exportCondition = exportCondition;
        this.fieldSeparatorCombo.getSelectionModel().select((Object)PoiConstants.FieldSeparator.getNoteBySeparator(exportCondition.fieldSeparator));
        this.lineSeparatorCombo.getSelectionModel().select((Object)BcStringUtil.LineSeparator.getNoteBySeparator(exportCondition.lineSeparator));
        if (exportCondition.quotationMarkPolicy == PoiConstants.QuotationMarkPolicy.always) {
            this.quotationMarkPolicyCombo.getSelectionModel().select(1);
        } else {
            this.quotationMarkPolicyCombo.getSelectionModel().select(0);
        }
        this.headerEnabledCheckBox.setSelected(exportCondition.headerEnabled);
        if (!BcStringUtil.isEmpty(exportCondition.encoding)) {
            this.encodingCombo.getSelectionModel().select((Object)exportCondition.encoding);
        }
        this.bomCheckBox.setSelected(exportCondition.bomEnabled);
        this.codeMapCheckBox.setSelected(exportCondition.codeMapEnabled);
        this.notVisibleCheckBox.setSelected(exportCondition.notVisibleEnabled);
        if (this.wizard.destFile != null) {
            this.filePathField.setText(this.wizard.destFile.getPath());
        }
    }

    protected void storeToDataModel() throws Exception {
        this.exportCondition.fieldSeparator = PoiConstants.FieldSeparator.getSeparatorByNote((String)this.fieldSeparatorCombo.getValue());
        this.exportCondition.lineSeparator = BcStringUtil.LineSeparator.getSeparatorByName((String)this.lineSeparatorCombo.getValue());
        this.exportCondition.quotationMarkPolicy = this.quotationMarkPolicyCombo.getSelectionModel().selectedIndexProperty().get() == 1 ? PoiConstants.QuotationMarkPolicy.always : PoiConstants.QuotationMarkPolicy.necessary;
        this.exportCondition.headerEnabled = this.headerEnabledCheckBox.isSelected();
        this.exportCondition.encoding = (String)this.encodingCombo.getValue();
        this.exportCondition.bomEnabled = this.bomCheckBox.isSelected();
        this.exportCondition.codeMapEnabled = this.codeMapCheckBox.isSelected();
        this.exportCondition.notVisibleEnabled = this.notVisibleCheckBox.isSelected();
        this.exportCondition.locale = Locale.getDefault();
    }

    protected BcResult validateInputValue() throws Exception {
        BcResult result = new BcResult();
        BcInputValidator inputValidator = BcInputValidator.getInstance();
        return result;
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.fileChooseButton) {
            FxUtil.initFileChooser(this.fileChooser, this.filePathField.getText());
            File file = this.fileChooser.showSaveDialog(this.getScene().getWindow());
            if (file != null) {
                this.filePathField.setText(file.getPath());
            }
        } else if (ev.getSource() == this.encodingCombo) {
            this.bomSetting();
        }
    }

    @Override
    protected void nextButtonAction() throws Exception {
        super.nextButtonAction();
        BcResult result = this.validateInputValue();
        if (result.hasError()) {
            String message = BcMessageCreator.getInstance().createMessage(result.getErrorList());
            return;
        }
        this.storeToDataModel();
        this.wizard.destFile = new File(this.filePathField.getText());
        this.wizard.step2();
    }

    @Override
    protected void cancelButtonAction() throws Exception {
        this.wizard.close();
    }
}

