/*
 * Decompiled with CFR 0.152.
 */
package ext.scf4.dao;

import ext.base.util.BcCollectionUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectSql;
import ext.lib.sql.model.SqlWhereElement;
import ext.scf4.model.ScfEvent;
import java.util.List;

public class ScfEventDAO
extends OrmAbstractDAO<ScfEvent> {
    public static final int MODE_default = 1;

    private ScfEventDAO() {
        super(new ScfEvent[0]);
        this.setTableName("fwk1_event");
    }

    public static ScfEventDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectSql createSelectSql(SqlContext sqlContext, int mode, String alias, long eventId) throws Exception {
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectSql selectSql = new SqlSelectSql();
        if (eventId > 0L) {
            SqlWhereElement whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "id = " + eventId);
            selectSql.addWhereElement(whereElement);
        }
        if (mode == 1) {
            selectSql.setFromClause(SqlUtil.createTableName(this.getTableName(), alias));
            selectSql.getOrderByList().add(String.valueOf(aliasWk) + "id");
        }
        return selectSql;
    }

    public List<ScfEvent> getList(DtsSession dtsSession, int mode, long eventId) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "ev";
        SqlSelectSql selectSql = this.createSelectSql(sqlContext, mode, alias, eventId);
        selectSql.getSelectColumnList().addAll(this.getColumnNameList(alias));
        String sql = sqlContext.buildSelectSql(selectSql);
        return this.getEntityList(dtsSession, sql);
    }

    public ScfEvent getById(DtsSession dtsSession, long eventId) throws Exception {
        List<ScfEvent> entityList = this.getList(dtsSession, 1, eventId);
        return BcCollectionUtil.getFirst(entityList);
    }

    /* synthetic */ ScfEventDAO(ScfEventDAO scfEventDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final ScfEventDAO instance = new ScfEventDAO(null);

        private SingletonHolder() {
        }
    }
}

