/*
 * Decompiled with CFR 0.152.
 */
package ext.scf3.rmo;

import ext.base.core.BcConstants;
import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.table.BcTableColumn;
import ext.base.table.BcTableModel;
import ext.base.util.BcMessageCreator;
import ext.lib.datasource.DtsConnectionManagerImpl;
import ext.lib.datasource.DtsSession;
import ext.lib.datasource.DtsSessionFactory;
import ext.lib.datasource.DtsSessionFactoryManegaer;
import ext.lib.datasource.util.DtsWordManagerImpl;
import ext.lib.orm.dao.OrmSequenceDAO;
import ext.lib.rmi.model.RmiRespons;
import ext.lib.rmi.model.RmiRmoArgument;
import ext.lib.rmi.rmo.RmiAbstractRMO;
import ext.lib.sql.SqlResultSet;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectSql;
import ext.scf.common.ScfHandle;
import ext.scf.common.ScfHandleResource;
import ext.scf.server.ScfServerContainer;
import ext.scf2.server.ScfTableHandleResource;
import ext.scf3.common.Scf3Words;
import ext.scf3.rmo.ScfSqlUtil;
import ext.scf3.server.ScfSqlHandleResource;
import ext.scf3.server.ScfSqlTask;
import ext.scf3.server.ScfTableModelTask;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ScfDatabaseRMO
extends RmiAbstractRMO {
    public static final String METHOD_getTableHeader = "getTableHeader";
    public static final String METHOD_stopQuery = "stopQuery";
    public static final String METHOD_getNextRecord = "getNextRecord";
    public static final String METHOD_getRowByRowNumbers = "getRowByRowNumbers";
    public static final String METHOD_getRowByRowNumber = "getRowByRowNumber";
    public static final String METHOD_generalList = "generalList";
    public static final String METHOD_getDatasourceProperties = "getDatasourceProperties";
    public static final String METHOD_getMmdFieldMap = "getMmdFieldMap";
    public static final String METHOD_remakeSequenceTable = "remakeSequenceTable";

    public ScfDatabaseRMO() {
        this.objectPoolEnabled = true;
    }

    public void getTableHeader(RmiRmoArgument rmoArg) throws Exception {
        String handleId = rmoArg.getRequest().getDataAsString();
        ScfHandle handle = ScfServerContainer.getInstance().getHandleManager().getHandle(handleId);
        if (handle == null) {
            String msg = "handle '" + handleId + "' is not found.";
            throw new Exception(msg);
        }
        ScfHandleResource handleResource = handle.getHandleResource(0);
        if (ScfSqlHandleResource.class.isAssignableFrom(handleResource.getClass())) {
            ScfSqlHandleResource sqlHandleResource = (ScfSqlHandleResource)handleResource;
            this.getTableHeaderByQueryTask(rmoArg, handle, sqlHandleResource);
        } else if (ScfTableHandleResource.class.isAssignableFrom(handleResource.getClass())) {
            ScfTableHandleResource tableHandleResource = (ScfTableHandleResource)handleResource;
            this.getTableHeaderByTableModelTask(rmoArg, handle, tableHandleResource);
        }
    }

    private void getTableHeaderByQueryTask(RmiRmoArgument rmoArg, ScfHandle handle, ScfSqlHandleResource sqlHandleResource) throws Exception {
        block9: {
            RmiRespons rmiRes = rmoArg.getRespons();
            rmiRes.addData(false);
            ScfSqlTask sqlTask = sqlHandleResource.sqlTask;
            int tryCnt = 0;
            while (true) {
                block10: {
                    ++tryCnt;
                    if (sqlTask.getThrowable() != null) {
                        if (sqlTask.getThrowable() instanceof Exception) {
                            Exception exception = (Exception)sqlTask.getThrowable();
                            throw exception;
                        }
                        throw new Exception(sqlTask.getThrowable());
                    }
                    if (sqlTask.stmt == null) {
                        BcLogUtil.warning("getTableHeader():sqlTask.stmt is null.");
                        break block9;
                    }
                    try {
                        if (!sqlTask.stmt.isClosed()) break block10;
                        BcLogUtil.debug("sqlTask.stmt isClosed.");
                        break block9;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (sqlTask.result != null) break;
                Thread.sleep(100L);
            }
            if (sqlTask.result instanceof ResultSet) {
                SqlResultSet rs = (SqlResultSet)sqlTask.result;
                sqlHandleResource.setDBResource(sqlTask.dtsSession, rs, sqlTask.tableColumnList);
                ScfSqlUtil.setRespons(sqlTask.dtsSession.getSqlContext(), rmiRes, handle, sqlTask.tableColumnList, sqlTask.tableContext, rs);
                rmiRes.putData((Object)new Integer(0), new Boolean(true));
            } else if (sqlTask.result instanceof Number) {
                Number updateCount = (Number)sqlTask.result;
                ScfSqlUtil.setRespons(rmiRes, handle, updateCount);
                rmiRes.putData((Object)new Integer(0), new Boolean(true));
            }
        }
    }

    private void getTableHeaderByTableModelTask(RmiRmoArgument rmoArg, ScfHandle handle, ScfTableHandleResource tableHandleResource) throws Exception {
        RmiRespons rmiRes = rmoArg.getRespons();
        rmiRes.addData(false);
        ScfTableModelTask tableModelTask = (ScfTableModelTask)tableHandleResource.tmpObject;
        int tryCnt = 0;
        while (true) {
            ++tryCnt;
            if (tableModelTask.getThrowable() != null) {
                throw new Exception(tableModelTask.getThrowable());
            }
            if (tableModelTask.tableColumnList != null) break;
            Thread.sleep(100L);
        }
        tableHandleResource.tableModel = tableModelTask.tableModel;
        tableHandleResource.tableContext = tableModelTask.tableContext;
        ScfSqlUtil.setRespons(rmiRes, handle, (List<BcTableColumn>)tableModelTask.tableColumnList, tableModelTask.tableContext);
        rmiRes.putData((Object)new Integer(0), new Boolean(true));
    }

    public void stopQuery(RmiRmoArgument rmoArg) throws Exception {
        String handleId = rmoArg.getRequest().getDataAsString();
        ScfHandle handle = ScfServerContainer.getInstance().getHandleManager().getHandle(handleId);
        if (handle == null) {
            return;
        }
        ScfHandleResource handleResource = handle.getHandleResource(0);
        if (ScfSqlHandleResource.class.isAssignableFrom(handleResource.getClass())) {
            ScfSqlHandleResource sqlHandleResource = (ScfSqlHandleResource)handleResource;
            this.stopQuery(sqlHandleResource);
        }
    }

    public void stopQuery(ScfSqlHandleResource sqlHandleResource) throws Exception {
        String msg;
        ScfSqlTask sqlTask = sqlHandleResource.sqlTask;
        if (sqlTask == null) {
            return;
        }
        if (sqlTask.stmt != null) {
            try {
                BcLogUtil.info("stmt canceling... hashCode=" + sqlTask.stmt.hashCode());
                sqlTask.stmt.cancel();
                BcLogUtil.info("stmt canceled. hashCode=" + sqlTask.stmt.hashCode());
            }
            catch (Exception ex) {
                String msg2 = String.valueOf(ex.getMessage()) + " Statement.cancel() \u306b\u3066\u4f8b\u5916";
                BcLogUtil.error(msg2);
            }
        } else {
            String msg3 = "stmt is null.";
            throw new Exception(msg3);
        }
        sqlTask.stmt.close();
        sqlTask.stmt = null;
        if (sqlTask.dtsSession != null) {
            try {
                sqlTask.dtsSession.desturuct();
            }
            catch (SQLException ex) {
                BcLogUtil.error(ex);
            }
        } else {
            msg = "sqlTask.dtsSession is null.";
            BcLogUtil.warning(msg);
        }
        if (sqlTask.dtsSessionForWord != null) {
            try {
                sqlTask.dtsSessionForWord.desturuct();
            }
            catch (SQLException ex) {
                BcLogUtil.error(ex);
            }
        } else {
            msg = "sqlTask.dtsSessionFowWord is null.";
            BcLogUtil.warning(msg);
        }
    }

    public void getRow(List<BcTableColumn> tableColumnList, SqlResultSet rs, List valueList) throws Exception {
        ResultSetMetaData rsmd = rs.getMetaData();
        int i = 0;
        while (i < rsmd.getColumnCount()) {
            BcTableColumn tableColumn = tableColumnList.get(i);
            Object value = SqlUtil.getValue((ResultSet)rs, i + 1, tableColumn);
            valueList.add(value);
            ++i;
        }
    }

    public void getNextRecord(RmiRmoArgument rmoArg) throws Exception {
        String handleId = rmoArg.getRequest().getDataAsString();
        int reqRecCnt = rmoArg.getRequest().getDataAsNumber().intValue();
        ScfHandle handle = ScfServerContainer.getInstance().getHandleManager().getHandle(handleId, true);
        ScfHandleResource handleResource = handle.getHandleResource(0);
        if (ScfSqlHandleResource.class.isAssignableFrom(handleResource.getClass())) {
            ScfSqlHandleResource sqlHandleResource = (ScfSqlHandleResource)handleResource;
            this.getNextRecord(rmoArg, handle, sqlHandleResource, reqRecCnt);
        } else if (ScfTableHandleResource.class.isAssignableFrom(handleResource.getClass())) {
            ScfTableHandleResource tableHandleResource = (ScfTableHandleResource)handleResource;
            this.getNextRecord(rmoArg, handle, tableHandleResource, reqRecCnt);
        }
    }

    public void getNextRecord(RmiRmoArgument rmoArg, ScfHandle handle, ScfSqlHandleResource sqlHandleResource, int reqRecCnt) throws Exception {
        ArrayList<ArrayList<Object>> rowList = new ArrayList<ArrayList<Object>>(reqRecCnt);
        SqlResultSet rs = sqlHandleResource.getResultSet();
        List<BcTableColumn> tableColumnList = sqlHandleResource.getTableColumnList();
        ScfSqlTask sqlTask = sqlHandleResource.sqlTask;
        while ((reqRecCnt <= 0 || rowList.size() < reqRecCnt) && rs.next()) {
            ++sqlHandleResource.rowCount;
            if (sqlTask != null && sqlTask.rowLimit > 0L && sqlHandleResource.rowCount > sqlTask.rowLimit) break;
            ArrayList<Object> row = new ArrayList<Object>();
            if (sqlHandleResource.sqlHandleResolver != null) {
                sqlHandleResource.sqlHandleResolver.getCurrentRow(sqlHandleResource.getdtsSession(), rs, row);
            } else {
                this.getRow(tableColumnList, rs, row);
            }
            rowList.add(row);
        }
        if (rowList.size() < reqRecCnt) {
            rmoArg.getRespons().putData((Object)"eod", BcConstants.Existence.TRUE.value);
        } else {
            rmoArg.getRespons().putData((Object)"eod", BcConstants.Existence.FALSE.value);
        }
        rmoArg.getRespons().putData((Object)"tb_rl", rowList);
    }

    public void getNextRecord(RmiRmoArgument rmoArg, ScfHandle handle, ScfTableHandleResource tableHandleResource, int reqRecCnt) throws Exception {
        ArrayList<List> rowList = new ArrayList<List>(reqRecCnt);
        BcTableModel tableModel = tableHandleResource.tableModel;
        while (tableHandleResource.rowSeq < tableModel.getRowCount() - 1 && (reqRecCnt <= 0 || rowList.size() < reqRecCnt)) {
            ++tableHandleResource.rowSeq;
            List row = tableModel.getRow(tableHandleResource.rowSeq);
            rowList.add(row);
        }
        if (rowList.size() < reqRecCnt) {
            rmoArg.getRespons().putData((Object)"eod", BcConstants.Existence.TRUE.value);
        } else {
            rmoArg.getRespons().putData((Object)"eod", BcConstants.Existence.FALSE.value);
        }
        rmoArg.getRespons().putData((Object)"tb_rl", rowList);
    }

    public void getRowByRowNumbers(RmiRmoArgument rmoArg) throws Exception {
        String handleId = rmoArg.getRequest().getDataAsString();
        String rowNumbers = rmoArg.getRequest().getDataAsString();
        ScfHandle handle = ScfServerContainer.getInstance().getHandleManager().getHandle(handleId, true);
        ScfHandleResource handleResource = handle.getHandleResource(0);
        ScfSqlHandleResource sqlHandleResource = (ScfSqlHandleResource)handleResource;
        SqlResultSet rs = sqlHandleResource.getResultSet();
        String[] rowNumberArray = rowNumbers.split(BcStringUtil.COMMA_STR);
        ArrayList rowList = new ArrayList();
        int i = 0;
        while (i < rowNumberArray.length) {
            Integer rowNumber = Integer.parseInt(rowNumberArray[i]);
            rs.absolute(rowNumber);
            ArrayList row = new ArrayList();
            this.getRow(sqlHandleResource.getTableColumnList(), rs, row);
            rowList.add(row);
            ++i;
        }
        rmoArg.getRespons().addData(rowList);
    }

    public void getRowByRowNumber(RmiRmoArgument rmoArg) throws Exception {
        String handleId = rmoArg.getRequest().getDataAsString();
        Integer rowNumber = rmoArg.getRequest().getDataAsInteger();
        ScfHandle handle = ScfServerContainer.getInstance().getHandleManager().getHandle(handleId, true);
        ScfHandleResource handleResource = handle.getHandleResource(0);
        ScfSqlHandleResource sqlHandleResource = (ScfSqlHandleResource)handleResource;
        SqlResultSet rs = sqlHandleResource.getResultSet();
        rs.absolute(rowNumber);
        ArrayList row = new ArrayList();
        this.getRow(sqlHandleResource.getTableColumnList(), rs, row);
        rmoArg.getRespons().addData(row);
    }

    public void generalList(RmiRmoArgument rmoArg) throws Exception {
        String datasourceName = rmoArg.getRequest().getDataAsString();
        Object queryObj = rmoArg.getRequest().getData();
        DtsSession dtsSessionWk = DtsSessionFactoryManegaer.getInstance().createSession(datasourceName, this);
        if (CharSequence.class.isAssignableFrom(queryObj.getClass())) {
            ScfSqlTask sqlTask = ScfSqlUtil.createSqlTask(rmoArg, dtsSessionWk);
            sqlTask.sql = queryObj.toString();
            ScfSqlUtil.generalListNew(sqlTask, (Object)this);
        } else if (SqlSelectSql.class.isAssignableFrom(queryObj.getClass())) {
            ScfSqlTask sqlTask = ScfSqlUtil.createSqlTask(rmoArg, dtsSessionWk);
            SqlSelectSql selectSql = (SqlSelectSql)queryObj;
            SqlContext sqlContextWk = dtsSessionWk.getSqlContext();
            sqlTask.tableColumnNameList = selectSql.getSelectColumnList();
            sqlTask.sql = sqlContextWk.buildSelectSql(selectSql);
            ScfSqlUtil.generalListNew(sqlTask, (Object)this);
        } else {
            String msg = BcMessageCreator.getInstance().bindMessage(Scf3Words.getInstance().MSG_\u30aa\u30d6\u30b8\u30a7\u30af\u30c8_0_\u306f\u30b5\u30dd\u30fc\u30c8\u5bfe\u8c61\u5916\u3067\u3059, queryObj);
            throw new Exception(msg);
        }
    }

    public void getDatasourceProperties(RmiRmoArgument rmoArg) throws Exception {
        String datasourceName = rmoArg.getRequest().getDataAsString();
        DtsSessionFactory sessionFactory = DtsSessionFactoryManegaer.getInstance().getSessionFactory(datasourceName);
        if (sessionFactory == null) {
            rmoArg.getRespons().addData(null);
            return;
        }
        DtsConnectionManagerImpl connectionManager = (DtsConnectionManagerImpl)sessionFactory.getConnectionManager();
        Properties dtsProps = connectionManager.getDtsProps();
        rmoArg.getRespons().addData(dtsProps);
    }

    public void getMmdFieldMap(RmiRmoArgument rmoArg) throws Exception {
        String datasourceName = rmoArg.getRequest().getDataAsString();
        BcLogUtil.debug("datasourceName=" + datasourceName);
        DtsSessionFactory sessionFactory = DtsSessionFactoryManegaer.getInstance().getSessionFactory(datasourceName);
        rmoArg.getRespons().addData(sessionFactory.mmdFieldMap);
        DtsWordManagerImpl wordManager = (DtsWordManagerImpl)sessionFactory.wordManager;
        rmoArg.getRespons().addData(wordManager.wordMap);
        rmoArg.getRespons().addData(wordManager.langCodeList);
    }

    public void remakeSequenceTable(RmiRmoArgument rmoArg) throws Exception {
        DtsSession dtsSession = rmoArg.getDtsSession(this);
        OrmSequenceDAO.getInstance().conpareNumber(dtsSession, true);
    }
}

