/*
 * Decompiled with CFR 0.152.
 */
package ext.scf.server;

import ext.base.log.BcLogUtil;
import ext.lib.rmi.common.RmiLoggerEventHandler;
import ext.scf.server.ScfServerLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScfServerLoggerManager {
    protected Map<String, ScfServerLogger> loggerMap = new HashMap<String, ScfServerLogger>();
    List<RmiLoggerEventHandler> loggerEventHandler = new ArrayList<RmiLoggerEventHandler>();

    public static ScfServerLoggerManager getInstance() throws Exception {
        return SingletonHolder.instance;
    }

    public synchronized ScfServerLogger getLogger(String handleId) throws Exception {
        ScfServerLogger serverLogger = this.loggerMap.get(handleId);
        if (serverLogger == null) {
            serverLogger = new ScfServerLogger(this);
            this.loggerMap.put(handleId, serverLogger);
        }
        BcLogUtil.debug("serverLogger.hashCode()=" + serverLogger.hashCode());
        return serverLogger;
    }

    public ScfServerLogger removeLogger(String handleId) throws Exception {
        ScfServerLogger serverLogger = this.loggerMap.remove(handleId);
        return serverLogger;
    }

    public void addLoggerEventHandler(RmiLoggerEventHandler eventHandler) {
        this.loggerEventHandler.add(eventHandler);
    }

    public boolean removeLoggerEventHandler(RmiLoggerEventHandler eventHandler) {
        return this.loggerEventHandler.remove(eventHandler);
    }

    public void fireException(Object obj) {
        RmiLoggerEventHandler[] eventHandlers = this.loggerEventHandler.toArray(new RmiLoggerEventHandler[0]);
        int i = 0;
        while (i < eventHandlers.length) {
            RmiLoggerEventHandler eventHandler = eventHandlers[i];
            try {
                eventHandler.dataReceived(24, obj);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
            ++i;
        }
    }

    private static final class SingletonHolder {
        private static final ScfServerLoggerManager instance = new ScfServerLoggerManager();

        private SingletonHolder() {
        }
    }
}

