/*
 * Decompiled with CFR 0.152.
 */
package ext.scf.server;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.base.util.BcMessageCreator;
import ext.base.util.BcRandamUtil;
import ext.scf.common.ScfHandle;
import ext.scf.server.ScfHandleLifeCheckTask;
import ext.scf.server.ScfHandleManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;

public class ScfHandleManagerImpl
implements ScfHandleManager {
    private int handleIdLength;
    private long checkDelayMillis;
    private int initialSize;
    private Map<Object, ScfHandle> handleMap;
    private Random random;
    private boolean isCluster;
    private int removedHandleCount;

    public ScfHandleManagerImpl(boolean isCluster) {
        this.isCluster = isCluster;
        this.handleIdLength = 32;
        this.checkDelayMillis = 180000L;
        this.initialSize = 256;
        this.handleMap = new HashMap<Object, ScfHandle>(this.initialSize);
        this.random = new Random();
        ScfHandleLifeCheckTask handleLifeCheckTask = new ScfHandleLifeCheckTask(this);
        Timer timer = new Timer();
        timer.schedule((TimerTask)handleLifeCheckTask, this.checkDelayMillis, this.checkDelayMillis);
    }

    @Override
    public String craeteHandleId() throws Exception {
        return BcRandamUtil.createCode(this.random, 5, this.handleIdLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHandle(ScfHandle handle) throws Exception {
        Map<Object, ScfHandle> map = this.handleMap;
        synchronized (map) {
            if (!this.isCluster) {
                if (BcStringUtil.isEmpty(handle.getHandleId())) {
                    String handleId;
                    while (this.getHandle(handleId = this.craeteHandleId(), false) != null) {
                    }
                    handle.setHandleId(handleId);
                }
            } else {
                ScfHandle handle2 = this.handleMap.get(handle.getHandleId());
                if (handle2 != null) {
                    throw new Exception("invalid handleId '" + handle.getHandleId() + "'");
                }
            }
        }
        handle.setStartTimeMillis(System.currentTimeMillis());
        handle.setLastAccessTimeMillis(handle.getStartTimeMillis());
        this.handleMap.put(handle.getHandleId(), handle);
    }

    @Override
    public ScfHandle getHandle(Object handleId, boolean checkExistence) throws Exception {
        if (BcStringUtil.isEmpty(handleId)) {
            String msg = BcMessageCreator.getInstance().bindMessage("\u30cf\u30f3\u30c9\u30ebID\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002", new Object[0]);
            throw new Exception(msg);
        }
        ScfHandle handle = this.handleMap.get(handleId);
        if (handle == null) {
            if (checkExistence) {
                String msg = BcMessageCreator.getInstance().bindMessage("\u30cf\u30f3\u30c9\u30ebID '{0}' \u306e \u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002", handleId);
                throw new Exception(msg);
            }
        } else {
            handle.setLastAccessTimeMillis(System.currentTimeMillis());
            handle.incrementAccessCount();
        }
        return handle;
    }

    @Override
    public ScfHandle getHandle(Object handleId) throws Exception {
        return this.getHandle(handleId, true);
    }

    @Override
    public ScfHandle removeHandle(Object handleId) throws Exception {
        ScfHandle handle = this.handleMap.remove(handleId);
        if (handle != null) {
            ++this.removedHandleCount;
            try {
                handle.close();
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }
        return handle;
    }

    @Override
    public Map<Object, ScfHandle> getHandleMap() {
        return this.handleMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHandleByOwner(Object owner) throws Exception {
        Object[] handles = null;
        Map<Object, ScfHandle> map = this.handleMap;
        synchronized (map) {
            handles = this.handleMap.values().toArray();
        }
        int i = 0;
        while (i < handles.length) {
            ScfHandle handle = (ScfHandle)handles[i];
            if (handle.getOwner() != null && handle.getOwner().equals(owner)) {
                this.removeHandle(handle.getHandleId());
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkHandleLifeSpan() throws Exception {
        Object[] handles = null;
        Map<Object, ScfHandle> map = this.handleMap;
        synchronized (map) {
            handles = this.handleMap.values().toArray();
        }
        int i = 0;
        while (i < handles.length) {
            long elapedMillis;
            ScfHandle handle = (ScfHandle)handles[i];
            if (handle.getLifeSpanMillis() > 0L && (elapedMillis = System.currentTimeMillis() - handle.getLastAccessTimeMillis()) > handle.getLifeSpanMillis()) {
                this.removeHandle(handle.getHandleId());
            }
            ++i;
        }
    }

    public int getRemovedHandleCount() {
        return this.removedHandleCount;
    }
}

