/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xsod.dao;

import ext.base.core.BcStringUtil;
import ext.base.util.BcCollectionUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectSql;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.xsod.model.XsodOrderSession;
import java.util.List;

public class XsodOrderSessionDAO
extends OrmAbstractDAO<XsodOrderSession> {
    public static final int MODE_sessionId = 1;
    public static final int MODE_\uff57orking = 2;

    private XsodOrderSessionDAO() {
        super(new XsodOrderSession[0]);
        this.setTableName("xsod_order_session");
    }

    public static XsodOrderSessionDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectSql createSelectSql(SqlContext sqlContext, int mode, String alias, int sessionId, String tableNumber) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectSql selectSql = new SqlSelectSql();
        if (sessionId > 0) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "id = " + sessionId);
            selectSql.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(tableNumber)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "table_number " + sqlContext.toCondition_string("=", tableNumber));
            selectSql.addWhereElement(whereElement);
        }
        if (mode == 2) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("(" + aliasWk + "start_date_time Is Not Null AND " + aliasWk + "end_date_time Is Null)");
            selectSql.addWhereElement(whereElement);
        }
        selectSql.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        if (mode == 1) {
            selectSql.getOrderByList().add(String.valueOf(aliasWk) + "id");
        } else if (mode == 2) {
            selectSql.getOrderByList().add(String.valueOf(aliasWk) + "table_number");
        }
        return selectSql;
    }

    public List<XsodOrderSession> getList(DtsSession dtsSession, int mode, int sessionId, String tableNumber) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "ods";
        SqlSelectSql selectSql = this.createSelectSql(sqlContext, mode, alias, sessionId, tableNumber);
        selectSql.getSelectColumnList().addAll(this.getColumnNameList(alias));
        String query = sqlContext.buildSelectSql(selectSql);
        return this.getEntityList(dtsSession, query);
    }

    public XsodOrderSession geById(DtsSession dtsSession, int sessionId) throws Exception {
        List<XsodOrderSession> entityList = this.getList(dtsSession, 2, sessionId, null);
        return BcCollectionUtil.getFirst(entityList);
    }

    public XsodOrderSession getWorkingByTableNumber(DtsSession dtsSession, String tableNumber) throws Exception {
        List<XsodOrderSession> entityList = this.getList(dtsSession, 2, -1, tableNumber);
        if (entityList.size() > 1) {
            String msg = "\u30c6\u30fc\u30d6\u30eb\u756a\u53f7'" + tableNumber + "'\u306e\u7a3c\u50cd\u4e2d\u304c2\u4ef6\u4ee5\u4e0a\u5b58\u5728\uff01";
            throw new Exception(msg);
        }
        return BcCollectionUtil.getFirst(entityList);
    }

    /* synthetic */ XsodOrderSessionDAO(XsodOrderSessionDAO xsodOrderSessionDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final XsodOrderSessionDAO instance = new XsodOrderSessionDAO(null);

        private SingletonHolder() {
        }
    }
}

