/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xmmd.dao;

import ext.base.core.BcStringUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectSql;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.xmmd.model.XmmdScreenItem;
import java.util.List;

public class XmmdScreenItemDAO
extends OrmAbstractDAO<XmmdScreenItem> {
    private XmmdScreenItemDAO() {
        super(new XmmdScreenItem[0]);
        this.setTableName("xmmd_screen_item");
    }

    public static XmmdScreenItemDAO getInstance() {
        return SingletonHolder.instance;
    }

    public List<XmmdScreenItem> getEntityList(DtsSession dtsSession, Integer schemaId, String modelName) throws Exception {
        SqlWhereElement whereElement;
        SqlContext sqlContext = dtsSession.getSqlContext();
        SqlSelectSql selectSql = new SqlSelectSql();
        selectSql.getSelectColumnList().addAll(this.getColumnNameList(null));
        selectSql.setFromClause(this.tableName);
        if (schemaId != null) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("schema_id = " + schemaId);
            selectSql.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(modelName)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("model_name " + sqlContext.toCondition_string("=", modelName));
            selectSql.addWhereElement(whereElement);
        }
        selectSql.getOrderByList().add("schema_id");
        selectSql.getOrderByList().add("model_name");
        String query = sqlContext.buildSelectSql(selectSql);
        return this.getEntityList(dtsSession, query);
    }

    public XmmdScreenItem getByName(DtsSession dtsSession, Integer schemaId, String modelName) throws Exception {
        List<XmmdScreenItem> profileList = this.getEntityList(dtsSession, schemaId, modelName);
        XmmdScreenItem profile = null;
        if (profileList.size() > 0) {
            profile = profileList.get(0);
        }
        return profile;
    }

    /* synthetic */ XmmdScreenItemDAO(XmmdScreenItemDAO xmmdScreenItemDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final XmmdScreenItemDAO instance = new XmmdScreenItemDAO(null);

        private SingletonHolder() {
        }
    }
}

