/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xmmd.dao;

import ext.base.core.BcStringUtil;
import ext.base.log.BcLogUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectSql;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.xmmd.model.XmmdIndexField;
import java.util.List;

public class XmmdIndexFieldDAO
extends OrmAbstractDAO<XmmdIndexField> {
    public static final int MODE_default = 1;

    private XmmdIndexFieldDAO() {
        super(new XmmdIndexField[0]);
        this.setTableName("xmmd_index_field");
    }

    public static XmmdIndexFieldDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectSql createSelectSql(SqlContext sqlContext, int mode, String alias, Integer schemaId, String indexName) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectSql selectSql = new SqlSelectSql();
        if (schemaId != null) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("schema_id = " + schemaId);
            selectSql.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(indexName)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula("index_name " + sqlContext.toCondition_string("=", indexName));
            selectSql.addWhereElement(whereElement);
        }
        selectSql.setFromClause(String.valueOf(this.getTableName()) + BcStringUtil.appendCaseOfTestDataNotEmpty(alias, " AS " + alias));
        if (mode == 1) {
            selectSql.getOrderByList().add(String.valueOf(aliasWk) + "schema_id");
            selectSql.getOrderByList().add(String.valueOf(aliasWk) + "index_name");
            selectSql.getOrderByList().add(String.valueOf(aliasWk) + "order_number");
        }
        return selectSql;
    }

    public List<XmmdIndexField> getList(DtsSession dtsSession, Integer schemaId, String indexName) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = null;
        SqlSelectSql selectSql = this.createSelectSql(sqlContext, 1, alias, schemaId, indexName);
        selectSql.getSelectColumnList().addAll(this.getColumnNameList(alias));
        String query = sqlContext.buildSelectSql(selectSql);
        return this.getEntityList(dtsSession, query);
    }

    public long deleteByIndexName(DtsSession dtsSession, Integer schemaId, String indexName) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String query = "DELETE FROM " + this.getTableName() + " WHERE schema_id = " + schemaId + " AND index_name" + sqlContext.toCondition_string("=", indexName);
        BcLogUtil.debug("query=" + query);
        return SqlUtil.executeUpdate(dtsSession.getConnection(), query);
    }

    /* synthetic */ XmmdIndexFieldDAO(XmmdIndexFieldDAO xmmdIndexFieldDAO) {
        this();
    }

    private static final class SingletonHolder {
        private static final XmmdIndexFieldDAO instance = new XmmdIndexFieldDAO(null);

        private SingletonHolder() {
        }
    }
}

