/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xjps.fx;

import ext.base.log.BcLogUtil;
import ext.base.table.BcTableColumnModel;
import ext.base.table.BcTableModel;
import ext.base.thread.BcMonitor;
import ext.base.util.BcInputValidator;
import ext.base.util.BcMessageCreator;
import ext.base.util.BcResult;
import ext.base.util.BcWords;
import ext.lib.fx.FxPlatform;
import ext.lib.fx.control.FxButton;
import ext.lib.fx.control.FxLabel;
import ext.lib.fx.control.FxTextArea;
import ext.lib.fx.control.FxTextField;
import ext.lib.fx.layout.FxDecoratePane;
import ext.lib.fx.layout.FxFlowPane;
import ext.lib.fx.layout.FxNodeUnit;
import ext.lib.fx.scene.FxScene;
import ext.lib.fx.stage.FxStage;
import ext.lib.fx.table.FxTableRowList;
import ext.lib.fx.table.FxTableUtil;
import ext.lib.fx.table.FxTableView;
import ext.lib.fx.util.FxOptionPane;
import ext.lib.fx.util.FxUtil;
import ext.module.xjps.fx.XjpsJavaParser;
import ext.module.xjps.fx.XjpsJavaParserResultPane;
import ext.scf4.fx.HfxLoadableTablePane;
import java.io.File;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class XjpsJavaParserPane
extends FxDecoratePane {
    FxFlowPane centerPane = new FxFlowPane(11);
    FxTextField directoryPathField = new FxTextField();
    FxButton directoryChooseButton = FxUtil.createBrowsButton(null);
    DirectoryChooser directoryChooser = new DirectoryChooser();
    FxTextArea statusTextArea = new FxTextArea();
    Button executeButton;
    Button cancelButton;
    BcMonitor monitor = new BcMonitor();
    InnerJavaParser javaParser = new InnerJavaParser();
    static final String title = "Java\u30bd\u30fc\u30b9\u89e3\u6790";
    Stage stage;

    public XjpsJavaParserPane() throws Exception {
        this.setComponent();
        this.directoryPathField.setText(System.getProperty("user.home"));
    }

    protected void setComponent() throws Exception {
        this.setCenter((Node)this.centerPane);
        this.executeButton = this.createButton(BcWords.getInstance().execute);
        this.cancelButton = this.createButton(BcWords.getInstance().close);
        this.directoryPathField.setPrefColumnCount(80);
        this.directoryChooseButton.setOnAction(this.actionEventHandler);
        FxNodeUnit nodeUnit = new FxNodeUnit((Node)new FxLabel("\u30bd\u30fc\u30b9\u30c7\u30a3\u30ec\u30af\u30c8\u30ea"), new Node[]{this.directoryPathField, this.directoryChooseButton});
        this.centerPane.addNodeUnit(nodeUnit);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(""), new Node[0]);
        this.centerPane.addNodeUnit(nodeUnit);
        this.statusTextArea.setPrefColumnCount(82);
        this.statusTextArea.setPrefRowCount(6);
        this.statusTextArea.setEditable(false);
        nodeUnit = new FxNodeUnit((Node)new FxLabel(BcWords.getInstance().situation), new Node[]{this.statusTextArea});
        this.centerPane.addNodeUnit(nodeUnit);
        FxUtil.defaultInitialize((Node)this);
    }

    @Override
    protected void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.directoryChooseButton) {
            FxUtil.initDirectoryChooser(this.directoryChooser, this.directoryPathField.getText());
            File file = this.directoryChooser.showDialog((Window)this.stage);
            if (file != null) {
                this.directoryPathField.setText(file.getPath());
            }
        } else if (ev.getSource() == this.executeButton) {
            BcResult result = new BcResult();
            BcInputValidator inputValidator = BcInputValidator.getInstance();
            inputValidator.isFileExists(this.directoryPathField.getText(), BcWords.getInstance().file, result.getErrorList());
            if (result.hasError()) {
                String msg = BcMessageCreator.getInstance().createMessage(BcWords.getInstance().warning, result.getErrorList()).toString();
                FxOptionPane.showMessageDialog((Window)this.stage, (Object)msg, BcWords.getInstance().warning, 2);
                return;
            }
            InnerTask task = new InnerTask();
            new Thread((Runnable)((Object)task)).start();
        } else if (ev.getSource() == this.cancelButton) {
            this.close();
        }
    }

    protected void showResult(final BcTableColumnModel tableColumnModel, final BcTableModel tableModel) throws Exception {
        FxPlatform.runLater(new Runnable(){

            @Override
            public void run() {
                try {
                    XjpsJavaParserPane.this.showResult2(tableColumnModel, tableModel);
                }
                catch (Exception ex) {
                    XjpsJavaParserPane.this.handleException(ex);
                }
            }
        });
    }

    protected void showResult2(BcTableColumnModel tableColumnModel, BcTableModel tableModel) throws Exception {
        FxTableView tableView = new FxTableView();
        FxTableUtil.createColumn(tableColumnModel, tableView, null);
        FxTableRowList tableRowList = new FxTableRowList(tableModel);
        tableView.setItems(tableRowList);
        HfxLoadableTablePane optionTablePane = new HfxLoadableTablePane();
        optionTablePane.setTableView(tableView);
        optionTablePane.setMainContent((Node)tableView);
        XjpsJavaParserResultPane javaParserResultPane = new XjpsJavaParserResultPane();
        javaParserResultPane.setCenter((Node)optionTablePane);
        javaParserResultPane.show(null);
        javaParserResultPane.stage.toFront();
    }

    public void close() throws Exception {
        this.stage.close();
    }

    public void show() throws Exception {
        this.stage = new FxStage();
        this.stage.setOnShown((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                try {
                    XjpsJavaParserPane.this.directoryPathField.requestFocus();
                }
                catch (Exception ex) {
                    XjpsJavaParserPane.this.handleException(ex);
                }
            }
        });
        this.stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent ev) {
                ev.consume();
                try {
                    XjpsJavaParserPane.this.close();
                }
                catch (Exception ex) {
                    XjpsJavaParserPane.this.handleException(ex);
                }
            }
        });
        FxScene scene = new FxScene((Parent)this);
        this.stage.setScene((Scene)scene);
        this.stage.setWidth(800.0);
        this.stage.setHeight(260.0);
        this.stage.setResizable(false);
        this.stage.setTitle(title);
        this.stage.show();
    }

    class InnerJavaParser
    extends XjpsJavaParser {
        @Override
        public void setStatus(final String status) throws Exception {
            BcLogUtil.info(status);
            FxPlatform.runLater(new Runnable(){

                @Override
                public void run() {
                    ((InnerJavaParser)InnerJavaParser.this).XjpsJavaParserPane.this.statusTextArea.setText(status);
                }
            });
        }
    }

    class InnerTask
    extends Task {
        public Void call() {
            try {
                File sourceFile = new File(XjpsJavaParserPane.this.directoryPathField.getText());
                XjpsJavaParserPane.this.javaParser.init();
                XjpsJavaParserPane.this.javaParser.parse(sourceFile);
                XjpsJavaParserPane.this.showResult(XjpsJavaParserPane.this.javaParser.tableColumnModel, XjpsJavaParserPane.this.javaParser.tableModel);
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
            XjpsJavaParserPane.this.monitor.unLock();
            return null;
        }
    }
}

