/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.fx;

import ext.base.log.BcLogUtil;
import ext.lib.fx.FxPlatform;
import ext.lib.fx.layout.FxBorderPane;
import ext.lib.fx.tree.FxTreeView;
import ext.lib.fx.util.FxImageHelper;
import ext.libx.fx.FxxMouseEventUtil;
import ext.libx.fx.viewer.FxxImageView;
import ext.libx.fx.viewer.FxxUrlEvent;
import ext.module.xdts.fx.XdtsMenuIF;
import ext.module.xfil.common.XfilUtil;
import ext.module.xfil.common.XfilWords;
import ext.module.xfil.fx.XfilExplorerPane;
import ext.module.xfil.fx.XfilFileSettingPane;
import ext.module.xfil.fx.XfilFileTreeView;
import ext.module.xfil.fx.XfilMainViewPane;
import ext.module.xfil.fx.XfilResultPane;
import ext.module.xfil.model.XfilAnalysisResult;
import ext.module.xfil.model.XfilUriEntity;
import ext.module.xfil.model.XfilUriEntityWrap;
import ext.module.xfil.stub.XfilFileStub;
import ext.module.xfil.swg.XfilFileListPanel;
import java.awt.Desktop;
import java.io.File;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.MenuBar;
import javafx.scene.control.TreeItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.VBox;

public class XfilMenuPane
extends FxBorderPane
implements XdtsMenuIF {
    VBox flowPane = new VBox(8.0);
    Button analysisButton = new Button("Analysis");
    Button fileListButton = new Button("fileList");
    Button fileList2Button = new Button("fileList2");
    Button deleteFileIndexButton;

    public XfilMenuPane() throws Exception {
        this.deleteFileIndexButton = new Button(XfilWords.getInstance().\u30d5\u30a1\u30a4\u30eb\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u524a\u9664);
        this.setComponant();
    }

    protected void setComponant() throws Exception {
        this.fileListButton.setOnAction(this.actionEventHandler);
        this.flowPane.getChildren().add((Object)this.fileListButton);
        this.analysisButton.setOnAction(this.actionEventHandler);
        this.flowPane.getChildren().add((Object)this.analysisButton);
        this.fileList2Button.setOnAction(this.actionEventHandler);
        this.flowPane.getChildren().add((Object)this.fileList2Button);
        this.deleteFileIndexButton.setOnAction(this.actionEventHandler);
        this.flowPane.getChildren().add((Object)this.deleteFileIndexButton);
        this.flowPane.setAlignment(Pos.CENTER);
        this.setCenter((Node)this.flowPane);
    }

    @Override
    public void actionPerformed(ActionEvent ev) throws Exception {
        super.actionPerformed(ev);
        if (ev.getSource() == this.analysisButton) {
            XfilFileSettingPane fileSettingPane = new XfilFileSettingPane();
            XfilAnalysisResult analysisResult = fileSettingPane.show(this.getScene().getWindow());
            BcLogUtil.debug("#4:analysisResult=" + analysisResult);
            if (analysisResult != null) {
                XfilResultPane resultPane = new XfilResultPane();
                resultPane.setData(analysisResult);
                resultPane.show(null);
            }
        } else if (ev.getSource() == this.fileListButton) {
            FxPlatform.runLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        XfilFileListPanel fileListPanel = new XfilFileListPanel();
                        fileListPanel.init();
                        fileListPanel.showAsFrame();
                        fileListPanel.doSearch();
                    }
                    catch (Exception ex) {
                        XfilMenuPane.this.handleException(ex);
                    }
                }
            });
        } else if (ev.getSource() == this.fileList2Button) {
            XfilMenuPane.temp();
        } else if (ev.getSource() == this.deleteFileIndexButton) {
            XfilFileStub.getInstance().deleteFileIndex();
        }
    }

    @Override
    public String getTitle() throws Exception {
        return XfilWords.getInstance().\u30d5\u30a1\u30a4\u30eb\u30e6\u30fc\u30c6\u30a3\u30ea\u30c6\u30a3;
    }

    @Override
    public void setMenu(MenuBar menuBar) throws Exception {
    }

    @Override
    public ImageView getImageView() throws Exception {
        return FxImageHelper.createImageView_icon("schedule_64x64.png");
    }

    public static void temp() throws Exception {
        XfilFileTreeView fileTreeView = new XfilFileTreeView();
        XfilExplorerPane explorerPane = new XfilExplorerPane();
        explorerPane.addTab((Node)fileTreeView, 0);
        XfilMainViewPane mainViewPane = new XfilMainViewPane();
        mainViewPane.show(null);
        fileTreeView.setEventHandler((EventHandler<? super FxxUrlEvent>)((EventHandler)ev -> {
            if (ev.getEventType() == FxxUrlEvent.SELECTED) {
                try {
                    TreeItem treeItem = (TreeItem)ev.getSource();
                    BcLogUtil.debug("#### treeItem.getValue()=" + treeItem.getValue());
                    XfilUriEntityWrap uriEntityWrap = (XfilUriEntityWrap)treeItem.getValue();
                    BcLogUtil.debug("uriEntityWrap.uri=" + uriEntityWrap.uri);
                    if (XfilFileTreeView.dummyUrl.equals(uriEntityWrap.uriStr)) {
                        File file = fileTreeView.getFile(treeItem);
                        fileTreeView.setFiles_L2(file.toPath(), treeItem);
                    }
                    List<XfilUriEntityWrap> uriEntityWrapList = XfilUtil.createUriEntityWrapList(uriEntityWrap.uri);
                    explorerPane.clear();
                    for (XfilUriEntityWrap uriEntityWrap2 : uriEntityWrapList) {
                        explorerPane.addUriEntityWrap(uriEntityWrap2);
                    }
                }
                catch (Exception ex) {
                    BcLogUtil.error(ex);
                }
            }
        }));
        explorerPane.setEventHandler((EventHandler<? super FxxUrlEvent>)((EventHandler)ev -> {
            try {
                BcLogUtil.debug("FxxUrlEvent.URL_SELECTED:ev.getSource()=" + ev.getSource());
                if (ev.getEventType() == FxxUrlEvent.SELECTED) {
                    XfilUriEntityWrap uriEntityWrap = (XfilUriEntityWrap)ev.getSource();
                    if (FxxMouseEventUtil.isImageExtention(uriEntityWrap.uri)) {
                        Image image = FxxMouseEventUtil.createBaseImage(uriEntityWrap.uri);
                        FxxImageView imageView = new FxxImageView(image);
                        mainViewPane.addNode((Node)imageView);
                    } else if (FxxMouseEventUtil.isMediaExtention(uriEntityWrap.uri)) {
                        // empty if block
                    }
                    fileTreeView.setUri(uriEntityWrap.uri);
                } else if (ev.getEventType() == FxxUrlEvent.EXE) {
                    XfilUriEntityWrap uriEntityWrap = (XfilUriEntityWrap)ev.getSource();
                    if (!FxxMouseEventUtil.isImageExtention(uriEntityWrap.uri) && FxxMouseEventUtil.isMediaExtention(uriEntityWrap.uri)) {
                        File file = new File(uriEntityWrap.uri.getPath());
                        BcLogUtil.debug("file.getPath()=" + file.getPath() + " exists=" + file.exists());
                        if (file.exists()) {
                            Desktop.getDesktop().open(file);
                        }
                    }
                }
            }
            catch (Exception ex) {
                BcLogUtil.error(ex);
            }
        }));
        explorerPane.show(null);
    }

    protected class FavoriteTreeView<T>
    extends FxTreeView {
        public FavoriteTreeView(TreeItem<T> rootTreeItem) {
            super(rootTreeItem);
        }

        protected void selectionChanged(ObservableValue observable, TreeItem oldTreeItem, TreeItem newTreeItem) throws Exception {
            XfilUriEntity uriEntity = (XfilUriEntity)newTreeItem.getValue();
        }

        protected void treeItemCollapsed(TreeItem.TreeModificationEvent ev) throws Exception {
        }
    }
}

