/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.dao;

import ext.base.core.BcStringUtil;
import ext.base.util.BcCollectionUtil;
import ext.lib.datasource.DtsSession;
import ext.lib.orm.dao.OrmAbstractDAO;
import ext.lib.sql.SqlUtil;
import ext.lib.sql.context.SqlContext;
import ext.lib.sql.model.SqlSelectSql;
import ext.lib.sql.model.SqlWhereElement;
import ext.module.xfil.model.XfilWebPage;
import java.util.List;

public class XfilWebPageDAO
extends OrmAbstractDAO<XfilWebPage> {
    private XfilWebPageDAO() {
        super(new XfilWebPage[0]);
        this.setTableName("xfil_web_page");
    }

    public static XfilWebPageDAO getInstance() {
        return SingletonHolder.instance;
    }

    public SqlSelectSql createSelectSql(SqlContext sqlContext, Mode mode, String alias, String host, String directory) throws Exception {
        SqlWhereElement whereElement;
        String aliasWk = SqlUtil.tableAliasToNotNull(alias);
        SqlSelectSql selectSql = new SqlSelectSql();
        if (!BcStringUtil.isEmpty(host)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "host" + sqlContext.toCondition_string("=", host));
            selectSql.addWhereElement(whereElement);
        }
        if (!BcStringUtil.isEmpty(directory)) {
            whereElement = new SqlWhereElement();
            whereElement.setLogical_AND();
            whereElement.setFormula(String.valueOf(aliasWk) + "directory" + sqlContext.toCondition_string("=", directory));
            selectSql.addWhereElement(whereElement);
        }
        selectSql.setFromClause(String.valueOf(this.getTableName()) + " AS " + alias);
        selectSql.getOrderByList().add(String.valueOf(aliasWk) + mode.orderBy);
        return selectSql;
    }

    public <T> List<T> getList(DtsSession dtsSession, Mode mode, String host, String directory) throws Exception {
        SqlContext sqlContext = dtsSession.getSqlContext();
        String alias = "a";
        SqlSelectSql selectSql = this.createSelectSql(sqlContext, mode, alias, host, directory);
        selectSql.getSelectColumnList().addAll(this.getColumnNameList(alias));
        String sql = sqlContext.buildSelectSql(selectSql);
        return this.getEntityList(dtsSession, sql);
    }

    public <T> T getByUrl(DtsSession dtsSession, String host, String directory) throws Exception {
        List<T> entityList = this.getList(dtsSession, Mode.host, host, directory);
        return BcCollectionUtil.getFirst(entityList);
    }

    /* synthetic */ XfilWebPageDAO(XfilWebPageDAO xfilWebPageDAO) {
        this();
    }

    public static enum Mode {
        host("host, directory");

        public final String orderBy;

        private Mode(String orderBy) {
            this.orderBy = orderBy;
        }
    }

    private static final class SingletonHolder {
        private static final XfilWebPageDAO instance = new XfilWebPageDAO(null);

        private SingletonHolder() {
        }
    }
}

