/*
 * Decompiled with CFR 0.152.
 */
package ext.module.xfil.common;

import ext.base.core.BcStringUtil;
import ext.base.core.BcTimeUtil;
import ext.base.io.BcFileUtil;
import ext.base.log.BcLogUtil;
import ext.base.mmd.MmdField;
import ext.base.net.BcNetUtil;
import ext.base.table.BcTableColumn;
import ext.base.table.BcTableColumnModel;
import ext.base.util.BcWords;
import ext.module.xfil.common.XfilConstants;
import ext.module.xfil.model.XfilUriEntity;
import ext.module.xfil.model.XfilUriEntityWrap;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;

public final class XfilUtil {
    private XfilUtil() {
    }

    public static String toSchemaName(int schemeId) throws Exception {
        if (schemeId == XfilConstants.Scheme.file.id) {
            return "file";
        }
        if (schemeId == XfilConstants.Scheme.http.id) {
            return "http";
        }
        throw new Exception("\u30b9\u30ad\u30fc\u30e0ID " + schemeId + " \u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
    }

    public static StringBuilder createInfo(Path path) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("path=" + path.toFile().getPath());
        sb.append(BcStringUtil.lineSeparator);
        sb.append("isDirectory=" + Files.isDirectory(path, new LinkOption[0]));
        sb.append(BcStringUtil.lineSeparator);
        sb.append("isReadable=" + Files.isReadable(path));
        sb.append(BcStringUtil.lineSeparator);
        sb.append("isRegularFile=" + Files.isRegularFile(path, new LinkOption[0]));
        return sb;
    }

    public static void toUriEntity(Path path, XfilUriEntity uriEntity) throws Exception {
        uriEntity.schemeId = XfilConstants.Scheme.file.id;
        uriEntity.path = path.getParent() != null ? BcFileUtil.toCommonPath(path.getParent().toString()) : null;
        if (path.getFileName() != null) {
            uriEntity.name = path.getFileName().toString();
            uriEntity.extention = BcFileUtil.getExtention(uriEntity.name);
        } else {
            uriEntity.name = null;
            uriEntity.extention = null;
        }
        uriEntity.entityType = Files.isDirectory(path, new LinkOption[0]) ? Short.valueOf(XfilConstants.FileType.directory.id) : Short.valueOf(XfilConstants.FileType.file.id);
        if (Files.isReadable(path)) {
            uriEntity.size = Files.size(path);
            if (path.getParent() != null) {
                Calendar tmpCalendar = BcTimeUtil.toCalendar(Files.getLastModifiedTime(path, new LinkOption[0]).toMillis());
                uriEntity.updateDate = BcTimeUtil.toYyyyMMdd(tmpCalendar);
                uriEntity.updateTime = BcTimeUtil.toHHmmss(tmpCalendar);
            }
        }
    }

    public static XfilUriEntity toUriEntity(Path path) throws Exception {
        XfilUriEntity uriEntity = new XfilUriEntity();
        XfilUtil.toUriEntity(path, uriEntity);
        return uriEntity;
    }

    public static XfilUriEntity toUriEntity(File file) throws Exception {
        return XfilUtil.toUriEntity(file.toPath());
    }

    public static void toUriEntity(XfilUriEntity uriEntity, URI uri) throws Exception {
        if (BcNetUtil.isFile(uri)) {
            File file = new File(uri);
            XfilUtil.toUriEntity(file.toPath(), uriEntity);
        } else if (BcNetUtil.isHttp(uri)) {
            uriEntity.schemeId = XfilConstants.Scheme.http.id;
            uriEntity.name = BcNetUtil.getFileName(uri);
            int fileNameLength = BcStringUtil.length(uriEntity.name);
            int pathLength = uri.toString().length();
            uriEntity.path = uri.toString().substring(0, pathLength - fileNameLength);
            uriEntity.path = BcStringUtil.replace((CharSequence)uriEntity.path, "http" + BcNetUtil.PROTOCOL_suffix, "").toString();
            uriEntity.extention = BcFileUtil.getExtention(uriEntity.name);
        }
    }

    public static XfilUriEntity toUriEntity(URI uri) throws Exception {
        XfilUriEntity uriEntity = new XfilUriEntity();
        XfilUtil.toUriEntity(uriEntity, uri);
        return uriEntity;
    }

    public static URI toUri(XfilUriEntity uriEntity) throws Exception {
        URI uri = null;
        if (uriEntity.schemeId == XfilConstants.Scheme.file.id) {
            String filePath = String.valueOf(BcFileUtil.appendEndSlash(uriEntity.path)) + uriEntity.name;
            File file = new File(filePath);
            uri = file.toURI();
        } else if (uriEntity.schemeId == XfilConstants.Scheme.http.id) {
            URL url = XfilUtil.toUrl(uriEntity);
            uri = url.toURI();
        } else {
            String scheme = XfilUtil.toSchemaName(uriEntity.schemeId);
            String userInfo = null;
            String host = null;
            int port = 0;
            String path = uriEntity.path;
            String query = null;
            String fragment = null;
            uri = new URI(scheme, userInfo, host, port, path, query, fragment);
        }
        return uri;
    }

    public static URL toUrl(Object source) throws Exception {
        URL url = null;
        if (source instanceof URL) {
            url = (URL)source;
        } else if (source instanceof XfilUriEntity) {
            XfilUriEntity uriEntity = (XfilUriEntity)source;
            url = XfilUtil.toUrl(uriEntity);
        }
        return url;
    }

    public static File toFile(XfilUriEntity uriEntity) throws Exception {
        URI uri = XfilUtil.toUri(uriEntity);
        File file = new File(uri);
        return file;
    }

    public static List<XfilUriEntity> createUriEntityList(Collection<File> fileCollection) throws Exception {
        ArrayList<XfilUriEntity> uriEntityList = new ArrayList<XfilUriEntity>();
        for (File file : fileCollection) {
            XfilUriEntity uriEntity = XfilUtil.toUriEntity(file);
            uriEntityList.add(uriEntity);
        }
        return uriEntityList;
    }

    public static List<XfilUriEntity> createUriEntityList(File dirFile) throws Exception {
        ArrayList<File> dirList = new ArrayList<File>();
        ArrayList<File> fileList = new ArrayList<File>();
        File[] files = dirFile.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.isDirectory()) {
                    dirList.add(file);
                } else {
                    fileList.add(file);
                }
                ++i;
            }
        }
        dirList.addAll(fileList);
        return XfilUtil.createUriEntityList(dirList);
    }

    public static List<XfilUriEntity> createUriEntityList(URI uri) throws Exception {
        String urlStr2 = URLDecoder.decode(uri.toString(), "UTF-8");
        Path path = BcNetUtil.uriToPath(urlStr2);
        File file = path.toFile();
        return XfilUtil.createUriEntityList(file);
    }

    public static XfilUriEntityWrap createUriEntityWrap(URI uri) throws Exception {
        BcLogUtil.debug("createUriEntityWrap:uri=" + uri);
        XfilUriEntityWrap uriEntityWrap = new XfilUriEntityWrap();
        uriEntityWrap.uriEntity = XfilUtil.toUriEntity(uri);
        uriEntityWrap.uri = uri;
        uriEntityWrap.uriStr = uriEntityWrap.uri.toString();
        return uriEntityWrap;
    }

    public static XfilUriEntityWrap createUriEntityWrap(File file) throws Exception {
        BcLogUtil.debug("createUriEntityWrap:file=" + file.getPath());
        return XfilUtil.createUriEntityWrap(file.toURI());
    }

    public static List<XfilUriEntityWrap> createUriEntityWrapList(URI uri) throws Exception {
        ArrayList<XfilUriEntityWrap> uriEntityWrapList = new ArrayList<XfilUriEntityWrap>();
        List<XfilUriEntity> uriEntityList = XfilUtil.createUriEntityList(uri);
        BcLogUtil.debug("uriEntityList.size()=" + uriEntityList.size());
        for (XfilUriEntity uriEntity : uriEntityList) {
            XfilUriEntityWrap uriEntityWrap = new XfilUriEntityWrap();
            uriEntityWrap.uriEntity = uriEntity;
            uriEntityWrap.uri = XfilUtil.toUri(uriEntity);
            BcLogUtil.debug("uriEntityWrap.uri=" + uriEntityWrap.uri);
            uriEntityWrap.uriStr = uriEntityWrap.uri.toString();
            uriEntityWrapList.add(uriEntityWrap);
        }
        return uriEntityWrapList;
    }

    public static String createKey(XfilUriEntity uriEntity) {
        String key = String.valueOf(uriEntity.name) + "-" + uriEntity.size;
        return key;
    }

    public static BcTableColumnModel createTableColumnModel_1() throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableColumn tableColumn = new BcTableColumn();
        MmdField mmdField = new MmdField();
        mmdField.displayName = BcWords.getInstance().folder;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 60;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = BcWords.getInstance().fileName;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 30;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = "\u30b5\u30a4\u30ba";
        mmdField.dataClass = Long.class;
        mmdField.columnCount = 8;
        mmdField.horizonalAlignment = 4;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = BcWords.getInstance().fileExtention;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 8;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = "\u30d5\u30e9\u30b0";
        mmdField.dataClass = Boolean.class;
        mmdField.columnCount = 6;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        return tableColumnModel;
    }

    public static BcTableColumnModel createTableColumnModel_2() throws Exception {
        BcTableColumnModel tableColumnModel = new BcTableColumnModel();
        BcTableColumn tableColumn = new BcTableColumn();
        MmdField mmdField = new MmdField();
        mmdField.displayName = BcWords.getInstance().fileName;
        mmdField.dataClass = String.class;
        mmdField.columnCount = 30;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = "\u30b5\u30a4\u30ba";
        mmdField.dataClass = Long.class;
        mmdField.columnCount = 8;
        mmdField.horizonalAlignment = 4;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        tableColumn = new BcTableColumn();
        mmdField = new MmdField();
        mmdField.displayName = "\u4ef6\u6570";
        mmdField.dataClass = Long.class;
        mmdField.columnCount = 4;
        mmdField.horizonalAlignment = 4;
        tableColumn.setMmdField(mmdField);
        tableColumn.isEditable = false;
        tableColumnModel.addColumn(tableColumn);
        return tableColumnModel;
    }
}

